/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DefaultAction;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class PathExtensionRule
extends Rule {
    private Pattern allow;
    private Pattern deny;

    public PathExtensionRule(String id, Pattern allow, Pattern deny) {
        this.allow = allow;
        this.deny = deny;
        this.setId(id);
    }

    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        if (this.allow != null && this.allow.matcher(request.getRequestURI()).matches()) {
            return new DoNothingAction();
        }
        if (this.deny != null && this.deny.matcher(request.getRequestURI()).matches()) {
            this.log(request, "Disallowed extension pattern '" + this.deny.pattern() + "' found on URI '" + request.getRequestURI() + "'");
            return new DefaultAction();
        }
        return new DoNothingAction();
    }
}

