/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class DefaultFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    private final String description;
    private final Pattern pattern;

    public DefaultFileFilter(String pattern) {
        this(pattern, new File(pattern).getName());
    }

    public DefaultFileFilter(String pattern, String description) {
        this.description = description.trim();
        int length = pattern.length();
        StringBuilder buffer = new StringBuilder(length + 8);
        block4: for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                switch (c) {
                    case '?': {
                        buffer.append('.');
                        continue block4;
                    }
                    case '*': {
                        buffer.append(".*");
                        continue block4;
                    }
                    default: {
                        buffer.append('\\');
                    }
                }
            }
            buffer.append(c);
        }
        this.pattern = Pattern.compile(buffer.toString());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File file) {
        return file != null && this.pattern.matcher(file.getName()).matches();
    }

    @Override
    public boolean accept(File directory, String name) {
        return name != null && this.pattern.matcher(name).matches();
    }
}

