/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

public class Tiling {
    private final int rank;
    private final int[] shape;
    private final int[] tileSize;
    private final int[] stride;

    public Tiling(int[] shape, int[] tileSize) {
        assert (shape.length <= tileSize.length);
        this.rank = shape.length;
        this.tileSize = tileSize;
        this.shape = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.shape[i] = Math.max(shape[i], tileSize[i]);
        }
        int[] tiles = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            tiles[i] = (this.shape[i] + tileSize[i] - 1) / tileSize[i];
        }
        this.stride = new int[this.rank];
        int strider = 1;
        for (int k = this.rank - 1; k >= 0; --k) {
            this.stride[k] = strider;
            strider *= tiles[k];
        }
    }

    public int[] tile(int[] pt) {
        int useRank = Math.min(this.rank, pt.length);
        int[] tile = new int[useRank];
        for (int i = 0; i < useRank; ++i) {
            assert (this.shape[i] >= pt[i]);
            tile[i] = pt[i] / this.tileSize[i];
        }
        return tile;
    }

    public int order(int[] pt) {
        int[] tile = this.tile(pt);
        int order = 0;
        int useRank = Math.min(this.rank, pt.length);
        for (int i = 0; i < useRank; ++i) {
            order += this.stride[i] * tile[i];
        }
        return order;
    }

    public int compare(int[] p1, int[] p2) {
        return this.order(p1) - this.order(p2);
    }
}

