/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import thredds.wcs.v1_0_0_Plus.WcsDataset;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public abstract class WcsRequest {
    protected static final Namespace wcsNS = Namespace.getNamespace((String)"http://www.opengis.net/wcs");
    protected static final Namespace gmlNS = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml");
    protected static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private Operation operation;
    private String version;
    private WcsDataset dataset;

    WcsRequest(Operation operation, String version, WcsDataset dataset) {
        this.operation = operation;
        this.version = version;
        this.dataset = dataset;
        if (operation == null) {
            throw new IllegalArgumentException("Non-null operation required.");
        }
        if (this.dataset == null) {
            throw new IllegalArgumentException("Non-null dataset required.");
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getVersion() {
        return this.version;
    }

    public WcsDataset getDataset() {
        return this.dataset;
    }

    protected Element genCoverageOfferingBriefElem(String elemName, String covName, String covLabel, String covDescription, GridCoordSystem gridCoordSys) {
        Element briefElem = new Element(elemName, wcsNS);
        if (covDescription != null && covDescription.length() != 0) {
            briefElem.addContent((Content)new Element("description", wcsNS).addContent(covDescription));
        }
        briefElem.addContent((Content)new Element("name", wcsNS).addContent(covName));
        briefElem.addContent((Content)new Element("label", wcsNS).addContent(covLabel));
        briefElem.addContent((Content)this.genLonLatEnvelope(gridCoordSys));
        return briefElem;
    }

    protected Element genLonLatEnvelope(GridCoordSystem gcs) {
        Element lonLatEnvelopeElem = new Element("lonLatEnvelope", wcsNS);
        lonLatEnvelopeElem.setAttribute("srsName", "urn:ogc:def:crs:OGC:1.3:CRS84");
        LatLonRect llbb = gcs.getLatLonBoundingBox();
        LatLonPointImpl llpt = llbb.getLowerLeftPoint();
        LatLonPointImpl urpt = llbb.getUpperRightPoint();
        String firstPosition = llpt.getLongitude() + " " + llpt.getLatitude();
        double lon = llpt.getLongitude() + llbb.getWidth();
        String secondPosition = lon + " " + urpt.getLatitude();
        CoordinateAxis1D vertAxis = gcs.getVerticalAxis();
        if (vertAxis != null) {
            double zeroIndexValue = vertAxis.getCoordValue(0);
            double sizeIndexValue = vertAxis.getCoordValue((int)vertAxis.getSize() - 1);
            if (vertAxis.getPositive().equals("up")) {
                firstPosition = firstPosition + " " + zeroIndexValue;
                secondPosition = secondPosition + " " + sizeIndexValue;
            } else {
                firstPosition = firstPosition + " " + sizeIndexValue;
                secondPosition = secondPosition + " " + zeroIndexValue;
            }
        }
        lonLatEnvelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(firstPosition));
        lonLatEnvelopeElem.addContent((Content)new Element("pos", gmlNS).addContent(secondPosition));
        if (gcs.hasTimeAxis()) {
            lonLatEnvelopeElem.addContent((Content)new Element("timePosition", gmlNS).addContent(gcs.getCalendarDateRange().getStart().toString()));
            lonLatEnvelopeElem.addContent((Content)new Element("timePosition", gmlNS).addContent(gcs.getCalendarDateRange().getEnd().toString()));
        }
        return lonLatEnvelopeElem;
    }

    public static enum Format {
        NONE(""),
        GeoTIFF("image/tiff"),
        GeoTIFF_Float("image/tiff"),
        NetCDF3("application/x-netcdf");

        private String mimeType;

        private Format(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public static Format getFormat(String mimeType) {
            for (Format curSection : Format.values()) {
                if (!curSection.mimeType.equals(mimeType)) continue;
                return curSection;
            }
            throw new IllegalArgumentException("No such instance <" + mimeType + ">.");
        }
    }

    public static enum RequestEncoding {
        GET_KVP,
        POST_XML,
        POST_SOAP;

    }

    public static enum Operation {
        GetCapabilities,
        DescribeCoverage,
        GetCoverage;

    }
}

