/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.Builder;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.GraphicBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.geotools.styling.builder.SymbolizerBuilder;
import org.opengis.filter.expression.Expression;

public class PointSymbolizerBuilder
extends SymbolizerBuilder<PointSymbolizer> {
    Expression geometry;
    GraphicBuilder graphic = new GraphicBuilder(this).unset();
    Unit<Length> uom = null;

    public PointSymbolizerBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public PointSymbolizerBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public PointSymbolizerBuilder geometry(Expression geometry) {
        this.geometry = geometry;
        return this;
    }

    public PointSymbolizerBuilder geometry(String cqlExpression) {
        return this.geometry(this.cqlExpression(cqlExpression));
    }

    public GraphicBuilder graphic() {
        this.unset = false;
        return this.graphic;
    }

    public PointSymbolizerBuilder uom(Unit<Length> uom) {
        this.uom = uom;
        return this;
    }

    @Override
    public PointSymbolizer build() {
        if (this.unset) {
            return null;
        }
        PointSymbolizer ps = this.sf.createPointSymbolizer();
        ps.setGeometry(this.geometry);
        ps.setGraphic(this.graphic.build());
        if (this.uom != null) {
            ps.setUnitOfMeasure(this.uom);
        }
        ps.getOptions().putAll(this.options);
        if (this.parent == null) {
            this.reset();
        }
        return ps;
    }

    public PointSymbolizerBuilder reset() {
        this.geometry = null;
        this.graphic.reset();
        this.uom = null;
        this.unset = false;
        return this;
    }

    @Override
    public Builder<PointSymbolizer> reset(PointSymbolizer original) {
        if (original == null) {
            return this.unset();
        }
        this.geometry = original.getGeometry();
        this.graphic.reset(original.getGraphic());
        this.uom = original.getUnitOfMeasure();
        this.unset = false;
        return this;
    }

    @Override
    public Builder<PointSymbolizer> reset(org.opengis.style.PointSymbolizer original) {
        if (original == null) {
            return this.unset();
        }
        if (original instanceof PointSymbolizer) {
            return this.reset((PointSymbolizer)original);
        }
        this.geometry = this.property(original.getGeometryPropertyName());
        this.graphic.reset(original.getGraphic());
        this.uom = original.getUnitOfMeasure();
        this.unset = false;
        return this;
    }

    @Override
    public PointSymbolizerBuilder unset() {
        return (PointSymbolizerBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().point().reset(this.build());
    }
}

