/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ByteCollection;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.map.LongKeyByteMap;
import bak.pcj.map.LongKeyByteMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractLongKeyByteMap
implements LongKeyByteMap {
    protected AbstractLongKeyByteMap() {
    }

    public void clear() {
        LongKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public byte remove(long key) {
        LongKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            byte value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultByte();
    }

    public void putAll(LongKeyByteMap map) {
        LongKeyByteMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(long key) {
        LongKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public byte get(long key) {
        LongKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultByte();
    }

    public boolean containsValue(byte value) {
        LongKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongKeyByteMap)) {
            return false;
        }
        LongKeyByteMap map = (LongKeyByteMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        LongKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            long k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        LongKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultLongHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultByteHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        LongKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public byte tget(long key) {
        byte value = this.get(key);
        if (value == MapDefaults.defaultByte() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        LongKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ByteCollection values();

    public abstract byte put(long var1, byte var3);

    public abstract byte lget();

    public abstract LongSet keySet();

    public abstract LongKeyByteMapIterator entries();
}

