/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.DoubleCollection;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.map.IntKeyDoubleMap;
import bak.pcj.map.IntKeyDoubleMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.IntSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractIntKeyDoubleMap
implements IntKeyDoubleMap {
    protected AbstractIntKeyDoubleMap() {
    }

    public void clear() {
        IntKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public double remove(int key) {
        IntKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            double value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultDouble();
    }

    public void putAll(IntKeyDoubleMap map) {
        IntKeyDoubleMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(int key) {
        IntKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public double get(int key) {
        IntKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultDouble();
    }

    public boolean containsValue(double value) {
        IntKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntKeyDoubleMap)) {
            return false;
        }
        IntKeyDoubleMap map = (IntKeyDoubleMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        IntKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            int k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        IntKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultIntHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultDoubleHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        IntKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public double tget(int key) {
        double value = this.get(key);
        if (value == MapDefaults.defaultDouble() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        IntKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract DoubleCollection values();

    public abstract double put(int var1, double var2);

    public abstract double lget();

    public abstract IntSet keySet();

    public abstract IntKeyDoubleMapIterator entries();
}

