/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.SetToByteSetAdapter;
import bak.pcj.map.AbstractByteKeyMap;
import bak.pcj.map.ByteKeyMap;
import bak.pcj.map.ByteKeyMapIterator;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MapToByteKeyMapAdapter
extends AbstractByteKeyMap
implements ByteKeyMap {
    protected Map map;

    public MapToByteKeyMapAdapter(Map map) {
        this(map, false);
    }

    public MapToByteKeyMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(byte key) {
        return this.map.get(new Byte(key)) != null;
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public ByteKeyMapIterator entries() {
        return new ByteKeyMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToByteKeyMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public byte getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getKey();
            }

            public Object getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public Object get(byte key) {
        return this.map.get(new Byte(key));
    }

    public ByteSet keySet() {
        return new SetToByteSetAdapter(this.map.keySet());
    }

    public Object put(byte key, Object value) {
        return this.map.put(new Byte(key), value);
    }

    public Object remove(byte key) {
        return this.map.remove(new Byte(key));
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public boolean validate() {
        return Adapter.isByteKeyAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

