/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ByteCollection;
import bak.pcj.adapter.CollectionToByteCollectionAdapter;
import bak.pcj.adapter.SetToByteSetAdapter;
import bak.pcj.map.AbstractByteKeyByteMap;
import bak.pcj.map.ByteKeyByteMap;
import bak.pcj.map.ByteKeyByteMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToByteKeyByteMapAdapter
extends AbstractByteKeyByteMap
implements ByteKeyByteMap {
    protected Map map;
    protected Byte lastValue;

    public MapToByteKeyByteMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToByteKeyByteMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(byte key) {
        this.lastValue = (Byte)this.map.get(new Byte(key));
        return this.lastValue != null;
    }

    public boolean containsValue(byte value) {
        return this.map.containsValue(new Byte(value));
    }

    public ByteKeyByteMapIterator entries() {
        return new ByteKeyByteMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToByteKeyByteMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public byte getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getKey();
            }

            public byte getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public byte get(byte key) {
        Byte value = (Byte)this.map.get(new Byte(key));
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public ByteSet keySet() {
        return new SetToByteSetAdapter(this.map.keySet());
    }

    public byte lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public byte put(byte key, byte value) {
        Byte oldValue = this.map.put(new Byte(key), new Byte(value));
        return oldValue == null ? MapDefaults.defaultByte() : oldValue;
    }

    public byte remove(byte key) {
        Byte value = (Byte)this.map.remove(new Byte(key));
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ByteCollection values() {
        return new CollectionToByteCollectionAdapter(this.map.values());
    }

    public byte tget(byte key) {
        Byte value = (Byte)this.map.get(new Byte(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isByteKeyByteAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

