/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.ShortCollection;
import bak.pcj.ShortIterator;
import bak.pcj.util.Exceptions;

public class SynchronizedShortCollection
implements ShortCollection {
    protected ShortCollection collection;
    protected Object m;

    public SynchronizedShortCollection(ShortCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = c;
        this.m = this;
    }

    public boolean add(short v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.add(v);
            return bl;
        }
    }

    public boolean addAll(ShortCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.addAll(c);
            return bl;
        }
    }

    public void clear() {
        Object object = this.m;
        synchronized (object) {
            this.collection.clear();
        }
    }

    public boolean contains(short v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.contains(v);
            return bl;
        }
    }

    public boolean containsAll(ShortCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.containsAll(c);
            return bl;
        }
    }

    public boolean equals(Object obj) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.equals(obj);
            return bl;
        }
    }

    public int hashCode() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.hashCode();
            return n;
        }
    }

    public boolean isEmpty() {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.isEmpty();
            return bl;
        }
    }

    public ShortIterator iterator() {
        Object object = this.m;
        synchronized (object) {
            ShortIterator shortIterator = this.collection.iterator();
            return shortIterator;
        }
    }

    public boolean remove(short v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.remove(v);
            return bl;
        }
    }

    public boolean removeAll(ShortCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.removeAll(c);
            return bl;
        }
    }

    public boolean retainAll(ShortCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.retainAll(c);
            return bl;
        }
    }

    public int size() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.size();
            return n;
        }
    }

    public short[] toArray() {
        Object object = this.m;
        synchronized (object) {
            short[] sArray = this.collection.toArray();
            return sArray;
        }
    }

    public short[] toArray(short[] a) {
        Object object = this.m;
        synchronized (object) {
            short[] sArray = this.collection.toArray(a);
            return sArray;
        }
    }

    public void trimToSize() {
        Object object = this.m;
        synchronized (object) {
            this.collection.trimToSize();
        }
    }
}

