/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.handler.factory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.http.handler.RequestHandler;
import ro.isdc.wro.http.handler.factory.DefaultRequestHandlerFactory;
import ro.isdc.wro.http.handler.factory.RequestHandlerFactory;
import ro.isdc.wro.http.handler.factory.SimpleRequestHandlerFactory;
import ro.isdc.wro.http.handler.spi.RequestHandlerProvider;
import ro.isdc.wro.model.resource.support.AbstractConfigurableMultipleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableRequestHandlerFactory
extends AbstractConfigurableMultipleStrategy<RequestHandler, RequestHandlerProvider>
implements RequestHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableRequestHandlerFactory.class);
    public static final String KEY = "requestHandlers";
    private final RequestHandlerFactory requestHandlerFactory = this.newRequestHandlerFactory();

    @Override
    protected String getStrategyKey() {
        return KEY;
    }

    @Override
    protected Map<String, RequestHandler> getStrategies(RequestHandlerProvider provider) {
        return provider.provideRequestHandlers();
    }

    @Override
    public Collection<RequestHandler> create() {
        return (Collection)this.requestHandlerFactory.create();
    }

    private RequestHandlerFactory newRequestHandlerFactory() {
        SimpleRequestHandlerFactory factory = new SimpleRequestHandlerFactory();
        List requestHandlers = this.getConfiguredStrategies();
        for (RequestHandler requestHandler : requestHandlers) {
            factory.addHandler(requestHandler);
        }
        if (requestHandlers.isEmpty()) {
            LOG.debug("No locators configured. Using Default locator factory.");
            return new DefaultRequestHandlerFactory();
        }
        return factory;
    }

    @Override
    protected Class<RequestHandlerProvider> getProviderClass() {
        return RequestHandlerProvider.class;
    }
}

