/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Table;
import org.h2.util.New;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(Session session) {
        super(session);
    }

    @Override
    public int update() {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0;
    }

    private void dropAllObjects() {
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        database.lockMeta(this.session);
        for (Schema object52 : database.getAllSchemas()) {
            if (!object52.canDrop()) continue;
            database.removeDatabaseObject(this.session, object52);
        }
        ArrayList<Table> arrayList = database.getAllTablesAndViews(false);
        Iterator bl2 = arrayList.iterator();
        while (bl2.hasNext()) {
            object3 = (Table)bl2.next();
            if (((DbObjectBase)object3).getName() == null || !"VIEW".equals(((Table)object3).getTableType())) continue;
            database.removeSchemaObject(this.session, (SchemaObject)object3);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object3 = (Table)iterator.next();
            if (((DbObjectBase)object3).getName() == null || !"TABLE LINK".equals(((Table)object3).getTableType())) continue;
            database.removeSchemaObject(this.session, (SchemaObject)object3);
        }
        boolean bl3 = false;
        do {
            bl = false;
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                object2 = (Table)object3.next();
                if (((DbObjectBase)object2).getName() == null || !"TABLE".equals(((Table)object2).getTableType()) || ((Table)object2).isHidden()) continue;
                if (database.getDependentTable((SchemaObject)object2, (Table)object2) == null) {
                    database.removeSchemaObject(this.session, (SchemaObject)object2);
                    continue;
                }
                bl = true;
            }
        } while (bl);
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = (Table)object3.next();
            if (((DbObjectBase)object2).getName() == null || !"EXTERNAL".equals(((Table)object2).getTableType()) || ((Table)object2).isHidden()) continue;
            database.removeSchemaObject(this.session, (SchemaObject)object2);
        }
        this.session.findLocalTempTable(null);
        object3 = New.arrayList();
        ((ArrayList)object3).addAll(database.getAllSchemaObjects(3));
        ((ArrayList)object3).addAll(database.getAllSchemaObjects(5));
        ((ArrayList)object3).addAll(database.getAllSchemaObjects(4));
        ((ArrayList)object3).addAll(database.getAllSchemaObjects(11));
        ((ArrayList)object3).addAll(database.getAllSchemaObjects(9));
        object2 = ((ArrayList)object3).iterator();
        while (object2.hasNext()) {
            SchemaObject schemaObject = (SchemaObject)object2.next();
            if (schemaObject.isHidden()) continue;
            database.removeSchemaObject(this.session, schemaObject);
        }
        for (User user : database.getAllUsers()) {
            if (user == this.session.getUser()) continue;
            database.removeDatabaseObject(this.session, user);
        }
        for (Role role : database.getAllRoles()) {
            object = role.getCreateSQL();
            if (object == null) continue;
            database.removeDatabaseObject(this.session, role);
        }
        object2 = New.arrayList();
        ((ArrayList)object2).addAll(database.getAllRights());
        ((ArrayList)object2).addAll(database.getAllAggregates());
        ((ArrayList)object2).addAll(database.getAllUserDataTypes());
        Iterator iterator2 = ((ArrayList)object2).iterator();
        while (iterator2.hasNext()) {
            object = (DbObject)iterator2.next();
            String string = object.getCreateSQL();
            if (string == null) continue;
            database.removeDatabaseObject(this.session, (DbObject)object);
        }
    }

    public void setDropAllObjects(boolean bl) {
        this.dropAllObjects = bl;
    }

    public void setDeleteFiles(boolean bl) {
        this.deleteFiles = bl;
    }

    @Override
    public int getType() {
        return 38;
    }
}

