/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.util.StringUtils;

public class OrderBySource {
    private static final String BLOCK_SPLIT = "(?<=Asc|Desc)(?=\\p{Lu})";
    private static final Pattern DIRECTION_SPLIT = Pattern.compile("(.+)(Asc|Desc)$");
    private final List<Sort.Order> orders = new ArrayList<Sort.Order>();

    public OrderBySource(String clause) {
        this(clause, null);
    }

    public OrderBySource(String clause, Class<?> domainClass) {
        for (String part : clause.split(BLOCK_SPLIT)) {
            Matcher matcher = DIRECTION_SPLIT.matcher(part);
            if (!matcher.find()) {
                throw new IllegalArgumentException(String.format("Invalid order syntax for part %s!", part));
            }
            Sort.Direction direction = Sort.Direction.fromString(matcher.group(2));
            this.orders.add(this.createOrder(matcher.group(1), direction, domainClass));
        }
    }

    private Sort.Order createOrder(String propertySource, Sort.Direction direction, Class<?> domainClass) {
        if (null == domainClass) {
            return new Sort.Order(direction, StringUtils.uncapitalize((String)propertySource));
        }
        PropertyPath propertyPath = PropertyPath.from(propertySource, domainClass);
        return new Sort.Order(direction, propertyPath.toDotPath());
    }

    public Sort toSort() {
        return this.orders.isEmpty() ? null : new Sort(this.orders);
    }

    public String toString() {
        return "Order By " + StringUtils.collectionToDelimitedString(this.orders, (String)", ");
    }
}

