/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.GeonetEntity;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="MetadataFileUploads", indexes={@Index(name="ix_metadatafileuploads_mdid", columnList="metadataid")})
@SequenceGenerator(name="metadata_fileupload_id_seq", initialValue=100, allocationSize=1)
public class MetadataFileUpload
extends GeonetEntity {
    static final String ID_SEQ_NAME = "metadata_fileupload_id_seq";
    private int _id;
    private int _metadataId;
    private String _fileName;
    private String _uploadDate;
    private Double _fileSize;
    private String _userName;
    private String _deletedDate;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="metadata_fileupload_id_seq")
    public int getId() {
        return this._id;
    }

    public MetadataFileUpload setId(int id) {
        this._id = id;
        return this;
    }

    @Column(nullable=false)
    public String getUploadDate() {
        return this._uploadDate;
    }

    public MetadataFileUpload setUploadDate(String uploadDate) {
        this._uploadDate = uploadDate;
        return this;
    }

    @Column(nullable=false)
    public Double getFileSize() {
        return this._fileSize;
    }

    public MetadataFileUpload setFileSize(Double fileSize) {
        this._fileSize = fileSize;
        return this;
    }

    @Column(nullable=false)
    public int getMetadataId() {
        return this._metadataId;
    }

    public MetadataFileUpload setMetadataId(int metadataId) {
        this._metadataId = metadataId;
        return this;
    }

    @Column(nullable=false)
    public String getUserName() {
        return this._userName;
    }

    public MetadataFileUpload setUserName(String userName) {
        this._userName = userName;
        return this;
    }

    @Column(nullable=false)
    public String getFileName() {
        return this._fileName;
    }

    public MetadataFileUpload setFileName(String fileName) {
        this._fileName = fileName;
        return this;
    }

    @Column(nullable=true)
    public String getDeletedDate() {
        return this._deletedDate;
    }

    public MetadataFileUpload setDeletedDate(String deletedDate) {
        this._deletedDate = deletedDate;
        return this;
    }

    @Transient
    public boolean isDeleted() {
        return StringUtils.isNotEmpty((String)this._deletedDate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataFileUpload that = (MetadataFileUpload)o;
        if (this._id != that._id) {
            return false;
        }
        if (this._metadataId != that._metadataId) {
            return false;
        }
        if (this._deletedDate != null ? !this._deletedDate.equals(that._deletedDate) : that._deletedDate != null) {
            return false;
        }
        if (!this._fileName.equals(that._fileName)) {
            return false;
        }
        if (!this._fileSize.equals(that._fileSize)) {
            return false;
        }
        if (!this._uploadDate.equals(that._uploadDate)) {
            return false;
        }
        return !(this._userName != null ? !this._userName.equals(that._userName) : that._userName != null);
    }

    public int hashCode() {
        int result = this._id;
        result = 31 * result + this._metadataId;
        result = 31 * result + this._fileName.hashCode();
        result = 31 * result + this._uploadDate.hashCode();
        result = 31 * result + this._fileSize.hashCode();
        result = 31 * result + (this._userName != null ? this._userName.hashCode() : 0);
        result = 31 * result + (this._deletedDate != null ? this._deletedDate.hashCode() : 0);
        return result;
    }
}

