/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.rmi;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.rmi.ConnectException;
import java.rmi.Naming;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.handlers.SystemConfigFileHandler;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.rmi.FactoryInterfaceImpl;
import org.openrdf.sesame.server.rmi.RMICenter;
import org.openrdf.util.log.ThreadLog;

class RegisteringThread
extends Thread {
    String system_conf_path;
    Object exernalSignal;

    RegisteringThread(String path, Object signal) {
        this.exernalSignal = signal;
        this.system_conf_path = path;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.exernalSignal;
        synchronized (object) {
            ThreadLog.registerThread(null, (int)5);
            try {
                File sysFile = new File(this.system_conf_path);
                FileInputStream in = new FileInputStream(sysFile);
                SystemConfig sysConfig = SystemConfigFileHandler.readConfiguration(in);
                ((InputStream)in).close();
                SesameServer.setSystemConfig(sysConfig);
                String[] sFound = null;
                try {
                    sFound = Naming.list("rmi://localhost:" + RMICenter.sRMIPort + "/FactoryInterface");
                }
                catch (ConnectException e) {
                    // empty catch block
                }
                if (sFound == null || sFound.length == 0) {
                    if (RMICenter.sRMIPort != null && RMICenter.sRMIPort.length() > 0 && Integer.parseInt(RMICenter.sRMIPort) > 0) {
                        SesameServer.getSystemConfig().setRMIFactory("org.openrdf.sesame.server.rmi.FactoryInterfaceImpl", Integer.parseInt(RMICenter.sRMIPort));
                        SesameServer.getSystemConfig().setRMIEnabled(true);
                        FactoryInterfaceImpl.bind(new Integer(RMICenter.sRMIPort));
                        ThreadLog.log((String)("RMI binded to " + RMICenter.sRMIPort));
                    }
                } else {
                    ThreadLog.log((String)("Probably RMI binded to " + sFound[0]));
                }
                if (RMICenter.sSesameUser != null && RMICenter.sRepository != null) {
                    ThreadLog.log((String)("repository " + RMICenter.sRepository + " is being initializing..."));
                    SesameServer.getLocalService().login(RMICenter.sSesameUser, RMICenter.sSesamePass);
                    SesameRepository rep = SesameServer.getLocalService().getRepository(RMICenter.sRepository);
                    ThreadLog.log((String)("repository " + RMICenter.sRepository + " initialized!"));
                }
                this.exernalSignal.notifyAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ThreadLog.log((String)"RUN ENDED!");
    }
}

