/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.And;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.BooleanExprEvaluationException;
import org.openrdf.sesame.sail.query.PathExpression;
import org.openrdf.sesame.sail.query.SailQueryException;

public class GraphPattern
implements PathExpression {
    private List _pathExpressions = new ArrayList();
    private List _constraints = new ArrayList();
    private List _optionals = new ArrayList();
    private List _expressions = new ArrayList();
    private boolean _firstCall;
    private boolean _exhausted;

    public void addAll(Collection triplePatterns) {
        Iterator iter = triplePatterns.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof PathExpression) {
                this.add((PathExpression)o);
                continue;
            }
            if (o instanceof BooleanExpr) {
                this.addConstraint((BooleanExpr)o);
                continue;
            }
            throw new IllegalArgumentException("object in collection is not of type PathExpression or BooleanExpr but: " + o.getClass());
        }
    }

    public void add(PathExpression pathExpr) {
        this._pathExpressions.add(pathExpr);
    }

    public List getPathExpressions() {
        return Collections.unmodifiableList(this._pathExpressions);
    }

    public void setPathExpressions(List pathExpressions) {
        this._pathExpressions.clear();
        this.addAll(pathExpressions);
    }

    public List getPathExpressionsRecursively() {
        ArrayList result = new ArrayList(this._pathExpressions);
        Iterator iter = this._optionals.iterator();
        while (iter.hasNext()) {
            GraphPattern optionalGP = (GraphPattern)iter.next();
            result.addAll(optionalGP.getPathExpressionsRecursively());
        }
        return Collections.unmodifiableList(result);
    }

    public BooleanExpr getRootConstraint() {
        BooleanExpr result = null;
        ListIterator iter = this._constraints.listIterator(this._constraints.size());
        if (iter.hasPrevious()) {
            result = (BooleanExpr)iter.previous();
            while (iter.hasPrevious()) {
                BooleanExpr leftArg = (BooleanExpr)iter.previous();
                result = new And(leftArg, result);
            }
        }
        return result;
    }

    public List getConjunctiveConstraints() {
        return Collections.unmodifiableList(this._constraints);
    }

    public void setConstraints(BooleanExpr constraint) {
        this._constraints.clear();
        this.addConstraint(constraint);
    }

    public void setConstraints(List constraints) {
        this._constraints.clear();
        Iterator iter = constraints.iterator();
        while (iter.hasNext()) {
            BooleanExpr constraint = (BooleanExpr)iter.next();
            this.addConstraint(constraint);
        }
    }

    public void addConstraint(BooleanExpr constraint) {
        if (constraint instanceof And) {
            And and = (And)constraint;
            this.addConstraint(and.getLeftArg());
            this.addConstraint(and.getRightArg());
        } else {
            this._constraints.add(constraint);
        }
    }

    public void addOptional(GraphPattern optionalGP) {
        this._optionals.add(optionalGP);
    }

    public List getOptionals() {
        return Collections.unmodifiableList(this._optionals);
    }

    public void setOptionals(Collection optionals) {
        this._optionals.clear();
        this._optionals.addAll(optionals);
    }

    public List getExpressions() {
        return Collections.unmodifiableList(this._expressions);
    }

    public void setExpressions(List expressions) {
        this._expressions.clear();
        this._expressions.addAll(expressions);
    }

    public boolean findFirst(RdfSource rdfSource) throws SailQueryException {
        this.initialize(rdfSource);
        return this._findNext(rdfSource, true);
    }

    public boolean findNext(RdfSource rdfSource) throws SailQueryException {
        return this._findNext(rdfSource, false);
    }

    public void initialize(RdfSource rdfSource) {
        if (this._expressions.size() == 0 && this._pathExpressions.size() > 0) {
            this._expressions.addAll(this._pathExpressions);
            this._expressions.addAll(this._optionals);
            this._expressions.addAll(this._constraints);
        }
        this._firstCall = true;
        this._exhausted = false;
    }

    public boolean selectNext(RdfSource rdfSource) throws SailQueryException {
        boolean result;
        if (this._exhausted) {
            return false;
        }
        if (this._firstCall) {
            this._firstCall = false;
            result = this._findNext(rdfSource, true);
            if (!result) {
                this._exhausted = true;
                result = true;
            }
        } else {
            result = this._findNext(rdfSource, false);
            if (!result) {
                this._exhausted = true;
            }
        }
        return result;
    }

    public void clear() {
        for (int i = this._expressions.size() - 1; i >= 0; --i) {
            Object expression = this._expressions.get(i);
            if (!(expression instanceof PathExpression)) continue;
            ((PathExpression)expression).clear();
        }
    }

    public void getLocalVariables(Collection variables) {
        Iterator iter = this._pathExpressions.iterator();
        while (iter.hasNext()) {
            PathExpression pe = (PathExpression)iter.next();
            pe.getVariables(variables);
        }
    }

    public void getVariables(Collection variables) {
        this.getLocalVariables(variables);
        Iterator iter = this._optionals.iterator();
        while (iter.hasNext()) {
            GraphPattern pel = (GraphPattern)iter.next();
            pel.getVariables(variables);
        }
    }

    private boolean _findNext(RdfSource rdfSource, boolean firstCall) throws SailQueryException {
        int index;
        int lastIndex = this._expressions.size() - 1;
        Object expr = null;
        PathExpression pathExpr = null;
        BooleanExpr boolExpr = null;
        if (firstCall) {
            index = 0;
            if (this._expressions.size() == 0) {
                return true;
            }
            expr = this._expressions.get(index);
            if (expr instanceof PathExpression) {
                ((PathExpression)expr).initialize(rdfSource);
            }
        } else {
            index = lastIndex;
            if (this._expressions.size() == 0) {
                return false;
            }
            expr = this._expressions.get(index);
            while (expr instanceof BooleanExpr && index > 0) {
                expr = this._expressions.get(--index);
            }
            if (expr instanceof BooleanExpr) {
                return false;
            }
        }
        while (true) {
            boolean success = false;
            if (expr instanceof PathExpression) {
                pathExpr = (PathExpression)expr;
                success = pathExpr.selectNext(rdfSource);
            } else if (expr instanceof BooleanExpr) {
                boolExpr = (BooleanExpr)expr;
                try {
                    success = boolExpr.isTrue(rdfSource);
                }
                catch (BooleanExprEvaluationException e) {}
            } else {
                throw new RuntimeException("Unknown expression type: " + expr.getClass().toString());
            }
            if (success) {
                if (index == lastIndex) {
                    return true;
                }
                if (!((expr = this._expressions.get(++index)) instanceof PathExpression)) continue;
                ((PathExpression)expr).initialize(rdfSource);
                continue;
            }
            if (expr instanceof PathExpression) {
                pathExpr.clear();
            }
            if (index == 0) {
                return false;
            }
            expr = this._expressions.get(--index);
            while (expr instanceof BooleanExpr && index > 0) {
                expr = this._expressions.get(--index);
            }
            if (expr instanceof BooleanExpr) break;
        }
        return false;
    }

    public String toString() {
        ArrayList expressions = this._expressions;
        if (expressions.size() == 0) {
            expressions = new ArrayList();
            expressions.addAll(this._pathExpressions);
            expressions.addAll(this._optionals);
            expressions.addAll(this._constraints);
        }
        StringBuffer result = new StringBuffer(256);
        result.append("[\n");
        Iterator iter = expressions.iterator();
        while (iter.hasNext()) {
            Object expr = iter.next();
            result.append('\t');
            result.append(expr.toString());
            if (!iter.hasNext()) continue;
            result.append(",\n");
        }
        result.append("\n]");
        return result.toString();
    }
}

