/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.utilint.VLSN;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsufficientLogException
extends RestartRequiredException {
    private final RepNode repNode;
    private final VLSN refreshVLSN;
    private final Set<ReplicationNode> logProviders;

    private InsufficientLogException(RepNode repNode, VLSN refreshVLSN, Set<ReplicationNode> logProviders, Exception cause) {
        super((EnvironmentImpl)repNode.getRepImpl(), EnvironmentFailureReason.INSUFFICIENT_LOG, cause);
        this.repNode = repNode;
        this.refreshVLSN = refreshVLSN;
        this.logProviders = logProviders;
    }

    public InsufficientLogException(RepNode repNode, VLSN refreshVLSN, Set<ReplicationNode> hashSet) {
        this(repNode, refreshVLSN, hashSet, null);
    }

    public InsufficientLogException(InsufficientLogException cause) {
        this(cause.getRepNode(), cause.getRefreshVLSN(), cause.getLogProviders(), null);
    }

    private InsufficientLogException(String message, InsufficientLogException cause) {
        super(message, cause);
        this.repNode = cause.getRepNode();
        this.refreshVLSN = cause.getRefreshVLSN();
        this.logProviders = cause.getLogProviders();
    }

    @Override
    public EnvironmentFailureException wrapSelf(String msg) {
        return new InsufficientLogException(msg, this);
    }

    public VLSN getRefreshVLSN() {
        return this.refreshVLSN;
    }

    public Set<ReplicationNode> getLogProviders() {
        return this.logProviders;
    }

    public RepNode getRepNode() {
        return this.repNode;
    }
}

