/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;

public class ThreadUtils {
    private static SettingManager settingMan;
    private static boolean dbCanUseMultipleThreads;

    private ThreadUtils() {
    }

    private static int setCountFromSettings() {
        int threadCount = 1;
        String nrThreadsStr = settingMan.getValue("system/threadedindexing/maxthreads");
        if (nrThreadsStr == null) {
            Log.error((String)"geonetwork", (Object)"Number of Threads for indexing setting is missing from settings table. Using *one* thread");
            nrThreadsStr = "1";
        }
        try {
            threadCount = Integer.parseInt(nrThreadsStr);
        }
        catch (NumberFormatException nfe) {
            Log.error((String)"geonetwork", (Object)"Number of Threads for indexing setting is not valid. Using *one* thread");
        }
        return threadCount;
    }

    public static void init(String dbUrl, SettingManager sm) throws Exception {
        settingMan = sm;
        if (dbUrl != null) {
            if (dbUrl.toLowerCase().contains("postgres")) {
                dbCanUseMultipleThreads = true;
            } else if (dbUrl.toLowerCase().contains("oracle")) {
                dbCanUseMultipleThreads = true;
            }
        }
    }

    public static int getNumberOfThreads() {
        int threadCount = ThreadUtils.setCountFromSettings();
        if (!dbCanUseMultipleThreads && threadCount > 1) {
            threadCount = 1;
            Log.error((String)"geonetwork", (Object)"Theaded Indexing for not supported or hasn't been tested - so only *one* thread will be used");
        }
        Log.info((String)"geonetwork", (Object)("Using " + threadCount + " thread(s) to process indexing job"));
        return threadCount;
    }

    public static int getPriority() {
        return 5;
    }

    public static String getNumberOfProcessors() {
        int result = 1;
        if (dbCanUseMultipleThreads) {
            result = Runtime.getRuntime().availableProcessors();
        }
        return result + "";
    }

    static {
        dbCanUseMultipleThreads = false;
    }
}

