/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Util;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.exceptions.JeevesException;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.search.GeoNetworkAnalyzer;
import org.fao.geonet.kernel.search.ISearchManager;
import org.fao.geonet.kernel.search.IndexAndTaxonomy;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.LuceneOptimizerManager;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.kernel.search.StopwordFileParser;
import org.fao.geonet.kernel.search.UnusedSearcher;
import org.fao.geonet.kernel.search.classifier.Classifier;
import org.fao.geonet.kernel.search.facet.Dimension;
import org.fao.geonet.kernel.search.function.DocumentBoosting;
import org.fao.geonet.kernel.search.index.GeonetworkMultiReader;
import org.fao.geonet.kernel.search.index.IndexInformation;
import org.fao.geonet.kernel.search.index.LuceneIndexLanguageTracker;
import org.fao.geonet.kernel.search.spatial.ContainsFilter;
import org.fao.geonet.kernel.search.spatial.CrossesFilter;
import org.fao.geonet.kernel.search.spatial.EqualsFilter;
import org.fao.geonet.kernel.search.spatial.IntersectionFilter;
import org.fao.geonet.kernel.search.spatial.IsFullyOutsideOfFilter;
import org.fao.geonet.kernel.search.spatial.OgcGenericFilters;
import org.fao.geonet.kernel.search.spatial.OrSpatialFilter;
import org.fao.geonet.kernel.search.spatial.OverlapsBBoxFilter;
import org.fao.geonet.kernel.search.spatial.OverlapsFilter;
import org.fao.geonet.kernel.search.spatial.SpatialFilter;
import org.fao.geonet.kernel.search.spatial.SpatialIndexWriter;
import org.fao.geonet.kernel.search.spatial.TouchesFilter;
import org.fao.geonet.kernel.search.spatial.WithinBBoxFilter;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.util.GMLParsers;
import org.fao.geonet.utils.Xml;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.Transaction;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.filter.v2_0.FESConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.jdom.Content;
import org.jdom.Element;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class SearchManager
implements ISearchManager {
    private static Logger SE_LOGGER = LoggerFactory.getLogger((String)"geonetwork.search");
    private static Logger LU_LOGGER = LoggerFactory.getLogger((String)"geonetwork.lucene");
    private static Logger IE_LOGGER = LoggerFactory.getLogger((String)"geonetwork.index");
    private static Logger SP_LOGGER = LoggerFactory.getLogger((String)"geonetwork.spatial");
    public static final String INDEXING_ERROR_FIELD = "_indexingError";
    private static final String INDEXING_ERROR_MSG = "_indexingErrorMsg";
    private static final String SEARCH_STYLESHEETS_DIR_PATH = "xml/search";
    private static final String STOPWORDS_DIR_PATH = "resources/stopwords";
    private static final Configuration FILTER_1_0_0 = new org.geotools.filter.v1_0.OGCConfiguration();
    private static final Configuration FILTER_1_1_0 = new OGCConfiguration();
    private static final Configuration FILTER_2_0_0 = new FESConfiguration();
    private static Path _stopwordsDir;
    private static PerFieldAnalyzerWrapper _analyzer;
    private static PerFieldAnalyzerWrapper _searchAnalyzer;
    private static Map<String, Analyzer> analyzerMap;
    private static Map<String, Analyzer> searchAnalyzerMap;
    private static DocumentBoosting _documentBoostClass;
    private static PerFieldAnalyzerWrapper _defaultAnalyzer;
    private Path _stylesheetsDir;
    private Path _htmlCacheDir;
    private Spatial _spatial;
    private LuceneOptimizerManager _luceneOptimizerManager;

    private static Analyzer createGeoNetworkAnalyzer(Set<String> stopwords, char[] ignoreChars) {
        SE_LOGGER.debug("Creating GeoNetworkAnalyzer");
        return new GeoNetworkAnalyzer(stopwords, ignoreChars);
    }

    private static PerFieldAnalyzerWrapper createHardCodedPerFieldAnalyzerWrapper(Set<String> stopwords, char[] ignoreChars) {
        Analyzer geoNetworkAnalyzer = SearchManager.createGeoNetworkAnalyzer(stopwords, ignoreChars);
        HashMap<String, GeoNetworkAnalyzer> analyzers = new HashMap<String, GeoNetworkAnalyzer>();
        analyzers.put("_uuid", new GeoNetworkAnalyzer());
        analyzers.put("parentUuid", new GeoNetworkAnalyzer());
        analyzers.put("operatesOn", new GeoNetworkAnalyzer());
        analyzers.put("subject", (GeoNetworkAnalyzer)new KeywordAnalyzer());
        PerFieldAnalyzerWrapper pfaw = new PerFieldAnalyzerWrapper(geoNetworkAnalyzer, analyzers);
        return pfaw;
    }

    public static PerFieldAnalyzerWrapper getAnalyzer() {
        return _analyzer;
    }

    public static PerFieldAnalyzerWrapper getSearchAnalyzer() {
        return _searchAnalyzer;
    }

    public static PerFieldAnalyzerWrapper getAnalyzer(String language, boolean forSearching) {
        LU_LOGGER.debug("Get analyzer for searching: {} and language: {}", (Object)forSearching, (Object)language);
        Map<String, Analyzer> map = forSearching ? searchAnalyzerMap : analyzerMap;
        PerFieldAnalyzerWrapper analyzer = (PerFieldAnalyzerWrapper)map.get(language);
        if (analyzer != null) {
            return analyzer;
        }
        LU_LOGGER.debug("Returning default analyzer.");
        return forSearching ? _searchAnalyzer : _analyzer;
    }

    private static void initHardCodedAnalyzers(char[] ignoreChars) throws IOException {
        SE_LOGGER.debug("initializing hardcoded analyzers");
        if (_defaultAnalyzer == null) {
            _defaultAnalyzer = SearchManager.createHardCodedPerFieldAnalyzerWrapper(null, ignoreChars);
        }
        if (_stopwordsDir == null || !Files.isDirectory(_stopwordsDir, new LinkOption[0])) {
            SE_LOGGER.warn("Invalid stopwords directory {}, not using any stopwords.", (Object)_stopwordsDir);
        } else {
            LU_LOGGER.debug("loading stopwords");
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(_stopwordsDir);){
                for (Path stopwordsFile : paths) {
                    Set<String> stopwordsForLanguage;
                    String fileName = stopwordsFile.getFileName().toString();
                    String language = fileName.substring(0, fileName.indexOf(46));
                    if (language.length() != 2) {
                        LU_LOGGER.info("invalid iso 639-1 code for language: {}", (Object)language);
                    }
                    if ((stopwordsForLanguage = StopwordFileParser.parse(stopwordsFile.toAbsolutePath())) != null) {
                        LU_LOGGER.debug("loaded # {} stopwords for language {}", (Object)stopwordsForLanguage.size(), (Object)language);
                        PerFieldAnalyzerWrapper languageAnalyzer = SearchManager.createHardCodedPerFieldAnalyzerWrapper(stopwordsForLanguage, ignoreChars);
                        analyzerMap.put(language, (Analyzer)languageAnalyzer);
                        continue;
                    }
                    LU_LOGGER.debug("failed to load any stopwords for language {}", (Object)language);
                }
            }
        }
    }

    private static void addField(Element xmlDoc, String name, String value, boolean store, boolean index) {
        Element field = SearchManager.makeField(name, value, store, index);
        xmlDoc.addContent((Content)field);
    }

    public static Element makeField(String name, String value, boolean store, boolean index) {
        Element field = new Element("Field");
        field.setAttribute(LuceneFieldAttribute.NAME.toString(), name);
        field.setAttribute(LuceneFieldAttribute.STRING.toString(), value == null ? "" : value);
        field.setAttribute(LuceneFieldAttribute.STORE.toString(), Boolean.toString(store));
        field.setAttribute(LuceneFieldAttribute.INDEX.toString(), Boolean.toString(index));
        return field;
    }

    private static Constructor<? extends SpatialFilter> constructor(Class<? extends SpatialFilter> clazz) throws SecurityException, NoSuchMethodException {
        return clazz.getConstructor(Query.class, Integer.TYPE, Geometry.class, Pair.class);
    }

    public SettingInfo getSettingInfo() {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        return (SettingInfo)applicationContext.getBean(SettingInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Analyzer createAnalyzerFromLuceneConfig(String analyzerClassName, String field, Set<String> stopwords) {
        Analyzer analyzer;
        block11: {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            SettingInfo settingInfo = (SettingInfo)applicationContext.getBean(SettingInfo.class);
            LuceneConfig _luceneConfig = (LuceneConfig)applicationContext.getBean(LuceneConfig.class);
            char[] ignoreChars = settingInfo.getAnalyzerIgnoreChars();
            analyzer = null;
            try {
                SE_LOGGER.debug("Creating analyzer defined in Lucene config: {}", (Object)analyzerClassName);
                if (analyzerClassName.equals("org.fao.geonet.kernel.search.GeoNetworkAnalyzer")) {
                    analyzer = SearchManager.createGeoNetworkAnalyzer(stopwords, ignoreChars);
                    break block11;
                }
                try {
                    Class<?> analyzerClass = Class.forName(analyzerClassName);
                    Class<?>[] clTypesArray = _luceneConfig.getAnalyzerParameterClass((field == null ? "" : field) + analyzerClassName);
                    Object[] inParamsArray = _luceneConfig.getAnalyzerParameter((field == null ? "" : field) + analyzerClassName);
                    try {
                        SE_LOGGER.debug(" Creating analyzer with parameter");
                        Constructor<?> c = analyzerClass.getConstructor(clTypesArray);
                        analyzer = (Analyzer)c.newInstance(inParamsArray);
                    }
                    catch (Exception x) {
                        SE_LOGGER.warn("   Failed to create analyzer with parameter: {}", (Object)x.getMessage());
                        x.printStackTrace();
                        SE_LOGGER.warn("   Now trying without parameter");
                        analyzer = (Analyzer)analyzerClass.newInstance();
                    }
                }
                catch (Exception y) {
                    SE_LOGGER.warn("Failed to create analyzer as specified in lucene config, default analyzer will be used for field {}. Exception message is: {}", (Object)field, (Object)y.getMessage());
                    y.printStackTrace();
                }
            }
            catch (Exception z) {
                SE_LOGGER.warn(" Error on analyzer initialization: {}. Check your Lucene configuration. Hardcoded default analyzer will be used for field {}", (Object)z.getMessage(), (Object)field);
                z.printStackTrace();
            }
            finally {
                if (analyzer == null) {
                    SE_LOGGER.warn("Creating analyzer has failed, defaulting to GeoNetworkAnalyzer");
                    analyzer = SearchManager.createGeoNetworkAnalyzer(stopwords, ignoreChars);
                }
            }
        }
        return analyzer;
    }

    public void createAnalyzer() throws IOException {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SettingInfo settingInfo = (SettingInfo)applicationContext.getBean(SettingInfo.class);
        LuceneConfig luceneConfig = (LuceneConfig)applicationContext.getBean(LuceneConfig.class);
        String defaultAnalyzerClass = luceneConfig.getDefaultAnalyzerClass();
        SE_LOGGER.debug("createAnalyzer start");
        SE_LOGGER.debug("defaultAnalyzer defined in Lucene config: {}", (Object)defaultAnalyzerClass);
        char[] ignoreChars = settingInfo.getAnalyzerIgnoreChars();
        if (defaultAnalyzerClass == null) {
            SearchManager.initHardCodedAnalyzers(ignoreChars);
        } else {
            if (_stopwordsDir == null || !Files.isDirectory(_stopwordsDir, new LinkOption[0])) {
                SE_LOGGER.warn("Invalid stopwords directory {}, not using any stopwords.", (Object)_stopwordsDir);
            } else {
                LU_LOGGER.debug("Loading stopwords and creating per field anlayzer ...");
                try (DirectoryStream<Path> files = Files.newDirectoryStream(_stopwordsDir);){
                    for (Path stopwordsFile : files) {
                        Set<String> stopwordsForLanguage;
                        String fileName = stopwordsFile.getFileName().toString();
                        String language = fileName.substring(0, fileName.indexOf(46));
                        if (language.length() != 3) {
                            LU_LOGGER.warn("Stopwords file with incorrect ISO 639-2 language as filename: {}", (Object)language);
                        }
                        if ((stopwordsForLanguage = StopwordFileParser.parse(stopwordsFile.toAbsolutePath())) != null) {
                            LU_LOGGER.debug("Loaded # {} stopwords for language {}", (Object)stopwordsForLanguage.size(), (Object)language);
                            this.configurePerFieldAnalyzerWrapper(defaultAnalyzerClass, luceneConfig.getFieldSpecificAnalyzers(), analyzerMap, language, stopwordsForLanguage);
                            this.configurePerFieldAnalyzerWrapper(defaultAnalyzerClass, luceneConfig.getFieldSpecificSearchAnalyzers(), searchAnalyzerMap, language, stopwordsForLanguage);
                            continue;
                        }
                        LU_LOGGER.debug("Failed to load any stopwords for language {}", (Object)language);
                    }
                }
            }
            _analyzer = this.configurePerFieldAnalyzerWrapper(defaultAnalyzerClass, luceneConfig.getFieldSpecificAnalyzers(), null, null, null);
            _searchAnalyzer = this.configurePerFieldAnalyzerWrapper(defaultAnalyzerClass, luceneConfig.getFieldSpecificSearchAnalyzers(), null, null, null);
        }
    }

    private PerFieldAnalyzerWrapper configurePerFieldAnalyzerWrapper(String defaultAnalyzerClass, Map<String, String> fieldAnalyzers, Map<String, Analyzer> referenceMap, String referenceKey, Set<String> stopwordsForLanguage) {
        SE_LOGGER.debug(" Default analyzer class: {}", (Object)defaultAnalyzerClass);
        Analyzer defaultAnalyzer = this.createAnalyzerFromLuceneConfig(defaultAnalyzerClass, null, stopwordsForLanguage);
        HashMap<String, Analyzer> extraFieldAnalyzers = new HashMap<String, Analyzer>();
        for (Map.Entry<String, String> e : fieldAnalyzers.entrySet()) {
            String field = e.getKey();
            String aClassName = e.getValue();
            SE_LOGGER.debug(" Add analyzer for field: {}={}", (Object)field, (Object)aClassName);
            Analyzer analyzer = this.createAnalyzerFromLuceneConfig(aClassName, field, stopwordsForLanguage);
            extraFieldAnalyzers.put(field, analyzer);
        }
        PerFieldAnalyzerWrapper pfa = new PerFieldAnalyzerWrapper(defaultAnalyzer, extraFieldAnalyzers);
        if (referenceMap != null) {
            referenceMap.put(referenceKey, (Analyzer)pfa);
        }
        return pfa;
    }

    public void init(int maxWritesInTransaction) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        _stopwordsDir = geonetworkDataDirectory.resolveWebResource(STOPWORDS_DIR_PATH);
        this.createAnalyzer();
        this.createDocumentBoost();
        this.initNonStaticData(maxWritesInTransaction);
    }

    @VisibleForTesting
    public void initNonStaticData(int maxWritesInTransaction) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SettingInfo settingInfo = (SettingInfo)applicationContext.getBean(SettingInfo.class);
        GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        this._stylesheetsDir = geonetworkDataDirectory.resolveWebResource(SEARCH_STYLESHEETS_DIR_PATH);
        if (this._stylesheetsDir == null || !Files.isDirectory(this._stylesheetsDir, new LinkOption[0])) {
            throw new Exception("directory " + this._stylesheetsDir + " not found");
        }
        Path htmlCacheDirTest = geonetworkDataDirectory.getHtmlCacheDir();
        Files.createDirectories(htmlCacheDirTest, new FileAttribute[0]);
        this._htmlCacheDir = htmlCacheDirTest.toAbsolutePath();
        this._spatial = new Spatial((DataStore)applicationContext.getBean(DataStore.class), maxWritesInTransaction);
        this.initLucene();
        this._luceneOptimizerManager = new LuceneOptimizerManager(this, settingInfo);
    }

    @Override
    public void init(ServiceConfig handlerConfig) throws Exception {
    }

    @Override
    @PreDestroy
    public void end() throws Exception {
        this._spatial.end();
        this._luceneOptimizerManager.shutdown();
    }

    @Override
    public MetaSearcher newSearcher(String stylesheetName) throws Exception {
        return null;
    }

    private void createDocumentBoost() {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneConfig luceneConfig = (LuceneConfig)applicationContext.getBean(LuceneConfig.class);
        String className = luceneConfig.getDocumentBoostClass();
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                Class<?>[] clTypesArray = luceneConfig.getDocumentBoostParameterClass();
                Object[] inParamsArray = luceneConfig.getDocumentBoostParameter();
                try {
                    SE_LOGGER.debug(" Creating document boost object with parameter");
                    Constructor<?> c = clazz.getConstructor(clTypesArray);
                    _documentBoostClass = (DocumentBoosting)c.newInstance(inParamsArray);
                }
                catch (Exception x) {
                    SE_LOGGER.warn("   Failed to create document boost object with parameter: {}", (Object)x.getMessage());
                    x.printStackTrace();
                    SE_LOGGER.warn("   Now trying without parameter");
                    _documentBoostClass = (DocumentBoosting)clazz.newInstance();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void reloadLuceneConfiguration() throws IOException {
        this.createAnalyzer();
        this.createDocumentBoost();
    }

    @Override
    public synchronized void disableOptimizer() throws Exception {
        IE_LOGGER.info("Scheduling thread that optimizes lucene index is disabled");
        this._luceneOptimizerManager.cancel();
    }

    @Override
    public synchronized void rescheduleOptimizer(Calendar optimizerBeginAt, int optimizerInterval) throws Exception {
        this._luceneOptimizerManager.reschedule(optimizerBeginAt, optimizerInterval);
    }

    public MetaSearcher newSearcher(SearcherType type, String stylesheetName) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SchemaManager schemaManager = (SchemaManager)applicationContext.getBean(SchemaManager.class);
        LuceneConfig luceneConfig = (LuceneConfig)applicationContext.getBean(LuceneConfig.class);
        switch (type) {
            case LUCENE: {
                return new LuceneSearcher(this, stylesheetName, luceneConfig);
            }
            case UNUSED: {
                return new UnusedSearcher();
            }
        }
        throw new Exception("unknown MetaSearcher type: " + (Object)((Object)type));
    }

    private void initLucene() throws Exception {
        this.setupIndex(false);
    }

    public Path getHtmlCacheDir() {
        return this._htmlCacheDir;
    }

    @Override
    public void forceIndexChanges() throws IOException {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneIndexLanguageTracker tracker = (LuceneIndexLanguageTracker)applicationContext.getBean(LuceneIndexLanguageTracker.class);
        tracker.commit();
        tracker.maybeRefreshBlocking();
    }

    @Override
    public void index(Path schemaDir, Element metadata, String id, List<Element> moreFields, MetadataType metadataType, String root, boolean forceRefreshReaders) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneIndexLanguageTracker tracker = (LuceneIndexLanguageTracker)applicationContext.getBean(LuceneIndexLanguageTracker.class);
        this.indexGeometry(schemaDir, metadata, id, moreFields);
        List<IndexInformation> docs = this.buildIndexDocument(schemaDir, metadata, id, moreFields, metadataType, root);
        tracker.deleteDocuments(new Term("_id", id));
        for (IndexInformation document : docs) {
            tracker.addDocument(document);
        }
        if (forceRefreshReaders) {
            this.forceIndexChanges();
        }
    }

    private void indexGeometry(Path schemaDir, Element metadata, String id, List<Element> moreFields) throws Exception {
        try {
            this._spatial.writer().delete(id);
            this._spatial.writer().index(schemaDir, id, metadata);
        }
        catch (Exception e) {
            IE_LOGGER.error("Failed to properly index geometry of metadata {}. Error: {}", (Object)id, (Object)e.getMessage());
            moreFields.add(SearchManager.makeField(INDEXING_ERROR_FIELD, "1", true, true));
            moreFields.add(SearchManager.makeField(INDEXING_ERROR_MSG, "GNIDX-GEOWRITE||" + e.getMessage(), true, false));
        }
        Map<String, String> errors = this._spatial.writer().getErrorMessage();
        if (errors.size() > 0) {
            for (Map.Entry<String, String> e : errors.entrySet()) {
                moreFields.add(SearchManager.makeField(INDEXING_ERROR_FIELD, "1", true, true));
                moreFields.add(SearchManager.makeField(INDEXING_ERROR_MSG, "GNIDX-GEO|" + e.getKey() + "|" + e.getValue(), true, false));
            }
        }
    }

    public void deleteGroup(String fld, String txt) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneIndexLanguageTracker tracker = (LuceneIndexLanguageTracker)applicationContext.getBean(LuceneIndexLanguageTracker.class);
        IE_LOGGER.debug("Deleting document ");
        tracker.deleteDocuments(new Term(fld, txt));
        this._spatial.writer().delete(txt);
    }

    private List<IndexInformation> buildIndexDocument(Path schemaDir, Element metadata, String id, List<Element> moreFields, MetadataType metadataType, String root) throws Exception {
        if (IE_LOGGER.isDebugEnabled()) {
            IE_LOGGER.debug("Metadata to index:\n{}", (Object)Xml.getString((Element)metadata));
        }
        Path defaultLangStyleSheet = this.getIndexFieldsXsl(schemaDir, root, "");
        Path otherLocalesStyleSheet = this.getIndexFieldsXsl(schemaDir, root, "language-");
        Path subtemplateStyleSheet = schemaDir.resolve("index-fields").resolve("index-subtemplate.xsl");
        Element xmlDoc = metadataType.equals((Object)MetadataType.SUB_TEMPLATE) || metadataType.equals((Object)MetadataType.TEMPLATE_OF_SUB_TEMPLATE) ? this.getIndexFields(metadata, subtemplateStyleSheet, id) : this.getIndexFields(metadata, defaultLangStyleSheet, otherLocalesStyleSheet);
        if (IE_LOGGER.isDebugEnabled()) {
            IE_LOGGER.debug("Indexing fields:\n{}", (Object)Xml.getString((Element)xmlDoc));
        }
        List documentElements = xmlDoc.getContent();
        Collection<Field> multilingualSortFields = this.findMultilingualSortElements(documentElements);
        ArrayList documents = Lists.newArrayList();
        for (Element doc : documentElements) {
            SearchManager.addField(doc, "_id", id, true, true);
            for (Element moreField : moreFields) {
                doc.addContent((Content)moreField.clone());
            }
            String locale = this.getLocaleFromIndexDoc(doc);
            documents.add(this.newDocument(locale, doc, multilingualSortFields));
        }
        if (IE_LOGGER.isDebugEnabled()) {
            IE_LOGGER.debug("Lucene document:\n{}", (Object)Xml.getString((Element)xmlDoc));
        }
        return documents;
    }

    private Path getIndexFieldsXsl(Path schemaDir, String root, String indexName) {
        if (root == null) {
            root = "";
        }
        if ((root = root.toLowerCase()).contains(":")) {
            root = root.split(":", 2)[1];
        }
        String basicName = "index-fields";
        Path defaultLangStyleSheet = schemaDir.resolve("index-fields").resolve(indexName + root + ".xsl");
        if (!Files.exists(defaultLangStyleSheet, new LinkOption[0])) {
            defaultLangStyleSheet = schemaDir.resolve("index-fields").resolve(indexName + "default.xsl");
        }
        if (!Files.exists(defaultLangStyleSheet, new LinkOption[0])) {
            defaultLangStyleSheet = schemaDir.resolve(indexName + "index-fields" + ".xsl");
        }
        return defaultLangStyleSheet;
    }

    private Collection<Field> findMultilingualSortElements(List<Element> documentElements) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneConfig luceneConfig = (LuceneConfig)applicationContext.getBean(LuceneConfig.class);
        HashMap<String, Field> multilingualSortFields = new HashMap<String, Field>();
        for (Element doc : documentElements) {
            String locale = this.getLocaleFromIndexDoc(doc);
            List fields = doc.getChildren("Field");
            Set<String> configuredMultilingualSortFields = luceneConfig.getMultilingualSortFields();
            for (Object object : fields) {
                String nameWithLocale;
                Element field = (Element)object;
                String fieldName = field.getAttributeValue("name");
                if (!configuredMultilingualSortFields.contains(fieldName) || multilingualSortFields.containsKey(nameWithLocale = LuceneConfig.multilingualSortFieldName(fieldName, locale))) continue;
                String fieldValue = field.getAttributeValue("string");
                FieldType fieldType = new FieldType();
                fieldType.setIndexed(true);
                fieldType.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
                fieldType.setOmitNorms(true);
                fieldType.setTokenized(false);
                fieldType.setStored(true);
                multilingualSortFields.put(nameWithLocale, new Field(nameWithLocale, fieldValue, fieldType));
            }
        }
        return multilingualSortFields.values();
    }

    private String getLocaleFromIndexDoc(Element doc) {
        String locale = doc.getAttributeValue("locale");
        if (locale == null || locale.trim().isEmpty()) {
            locale = "eng";
        }
        return locale;
    }

    private void allText(Element metadata, StringBuilder sb) {
        String text = metadata.getText().trim();
        if (text.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(text);
        }
        List children = metadata.getChildren();
        for (Element aChildren : children) {
            this.allText(aChildren, sb);
        }
    }

    public void delete(String fld, String txt) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneIndexLanguageTracker tracker = (LuceneIndexLanguageTracker)applicationContext.getBean(LuceneIndexLanguageTracker.class);
        tracker.deleteDocuments(new Term(fld, txt));
        this._spatial.writer().delete(txt);
    }

    public void delete(String fld, List<String> txts) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneIndexLanguageTracker tracker = (LuceneIndexLanguageTracker)applicationContext.getBean(LuceneIndexLanguageTracker.class);
        for (String txt : txts) {
            tracker.deleteDocuments(new Term(fld, txt));
        }
        this._spatial.writer().delete(txts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Integer> getDocsWithXLinks() throws Exception {
        IndexAndTaxonomy indexAndTaxonomy = this.getNewIndexReader(null);
        try {
            GeonetworkMultiReader reader = indexAndTaxonomy.indexReader;
            LinkedHashSet<Integer> docs = new LinkedHashSet<Integer>();
            for (int i = 0; i < reader.maxDoc(); ++i) {
                DocumentStoredFieldVisitor idXLinkSelector = new DocumentStoredFieldVisitor(new String[]{"_id", "_hasxlinks"});
                reader.document(i, (StoredFieldVisitor)idXLinkSelector);
                Document doc = idXLinkSelector.getDocument();
                String id = doc.get("_id");
                String hasxlinks = doc.get("_hasxlinks");
                IE_LOGGER.debug("Got id {} : '{}'", (Object)id, (Object)hasxlinks);
                if (id == null) {
                    IE_LOGGER.error("Document with no _id field skipped! Document is {}", (Object)doc);
                    continue;
                }
                if (!hasxlinks.trim().equals("1")) continue;
                docs.add(Integer.valueOf(id));
            }
            LinkedHashSet<Integer> linkedHashSet = docs;
            return linkedHashSet;
        }
        finally {
            this.releaseIndexReader(indexAndTaxonomy);
        }
    }

    @Override
    public void delete(String txt) throws Exception {
        this.delete("_id", txt);
    }

    @Override
    public void delete(List<String> txts) throws Exception {
        this.delete("_id", txts);
    }

    @Override
    public ISODate getDocChangeDate(String mdId) throws Exception {
        TermQuery query = new TermQuery(new Term("_id", mdId));
        try (IndexAndTaxonomy indexReader = this.getIndexReader("eng", -1L);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader.indexReader);
            TopDocs search = searcher.search((Query)query, 1);
            if (search.totalHits == 0) {
                throw new NoSuchFieldException("There is no metadata with id/uuid/fileIdentifier = " + mdId);
            }
            Document doc = searcher.doc(search.scoreDocs[0].doc, Collections.singleton("_changeDate"));
            if (doc != null) {
                ISODate iSODate = new ISODate(doc.get("_changeDate"));
                return iSODate;
            }
            ISODate iSODate = null;
            return iSODate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getDocsChangeDate() throws Exception {
        IndexAndTaxonomy indexAndTaxonomy = this.getNewIndexReader(null);
        try {
            GeonetworkMultiReader reader = indexAndTaxonomy.indexReader;
            int capacity = (int)((double)reader.maxDoc() / 0.75) + 1;
            HashMap<String, String> docs = new HashMap<String, String>(capacity);
            for (int i = 0; i < reader.maxDoc(); ++i) {
                DocumentStoredFieldVisitor idChangeDateSelector = new DocumentStoredFieldVisitor(new String[]{"_id", "_changeDate"});
                reader.document(i, (StoredFieldVisitor)idChangeDateSelector);
                Document doc = idChangeDateSelector.getDocument();
                String id = doc.get("_id");
                if (id == null) {
                    IE_LOGGER.error("Document with no _id field skipped! Document is {}", (Object)doc);
                    continue;
                }
                docs.put(id, doc.get("_changeDate"));
            }
            HashMap<String, String> hashMap = docs;
            return hashMap;
        }
        finally {
            this.releaseIndexReader(indexAndTaxonomy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getTerms(String fld) throws Exception {
        Vector<String> foundTerms = new Vector<String>();
        IndexAndTaxonomy indexAndTaxonomy = this.getNewIndexReader(null);
        try {
            AtomicReader reader = SlowCompositeReaderWrapper.wrap((IndexReader)indexAndTaxonomy.indexReader);
            Terms terms = reader.terms(fld);
            if (terms != null) {
                TermsEnum enu = terms.iterator(null);
                BytesRef term = enu.next();
                while (term != null && term.utf8ToString().equals(fld)) {
                    foundTerms.add(term.utf8ToString());
                    term = enu.next();
                }
            }
            Vector<String> vector = foundTerms;
            return vector;
        }
        finally {
            this.releaseIndexReader(indexAndTaxonomy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TermFrequency> getTermsFequency(String fieldName, String searchValue, int maxNumberOfTerms, int threshold, ServiceContext context) throws Exception {
        HashMap termList = Maps.newHashMap();
        IndexAndTaxonomy indexAndTaxonomy = this.getNewIndexReader(null);
        String searchValueWithoutWildcard = searchValue.replaceAll("[*?]", "");
        Element request = new Element("request").addContent((Content)new Element("any").setText(searchValue));
        String language = LuceneSearcher.determineLanguage((ServiceContext)context, (Element)request, (SettingInfo)context.getBean(SettingInfo.class)).analyzerLanguage;
        PerFieldAnalyzerWrapper analyzer = SearchManager.getAnalyzer(language, true);
        String analyzedSearchValue = LuceneSearcher.analyzeText(fieldName, searchValueWithoutWildcard, analyzer);
        boolean startsWithOnly = !searchValue.startsWith("*") && searchValue.endsWith("*");
        try {
            GeonetworkMultiReader multiReader = indexAndTaxonomy.indexReader;
            for (AtomicReaderContext atomicReaderContext : multiReader.getContext().leaves()) {
                AtomicReader reader = atomicReaderContext.reader();
                Terms terms = reader.terms(fieldName);
                if (terms == null) continue;
                TermsEnum termEnum = terms.iterator(null);
                int i = 1;
                BytesRef term = termEnum.next();
                while (term != null && i++ < maxNumberOfTerms) {
                    String text = term.utf8ToString();
                    if (termEnum.docFreq() >= threshold) {
                        String analyzedText = LuceneSearcher.analyzeText(fieldName, text, analyzer);
                        if (startsWithOnly && StringUtils.startsWithIgnoreCase((String)analyzedText, (String)analyzedSearchValue) || !startsWithOnly && StringUtils.containsIgnoreCase((String)analyzedText, (String)analyzedSearchValue) || startsWithOnly && StringUtils.startsWithIgnoreCase((String)text, (String)searchValueWithoutWildcard) || !startsWithOnly && StringUtils.containsIgnoreCase((String)text, (String)searchValueWithoutWildcard)) {
                            TermFrequency existing = (TermFrequency)termList.get(text);
                            if (existing != null) {
                                existing.inc(termEnum.docFreq());
                            } else {
                                TermFrequency freq = new TermFrequency(text, termEnum.docFreq());
                                termList.put(text, freq);
                            }
                        }
                    }
                    term = termEnum.next();
                }
            }
        }
        finally {
            this.releaseIndexReader(indexAndTaxonomy);
        }
        return termList.values();
    }

    Element getIndexFields(Element xml, Path defaultLangStyleSheet, Path otherLocalesStyleSheet) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        Element documents = new Element("Documents");
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("inspire", Boolean.toString(this.isInspireEnabled()));
            params.put("thesauriDir", geonetworkDataDirectory.getThesauriDir().toAbsolutePath().toString());
            Element defaultLang = Xml.transform((Element)xml, (Path)defaultLangStyleSheet, params);
            if (Files.exists(otherLocalesStyleSheet, new LinkOption[0])) {
                List otherLanguages = Xml.transform((Element)xml, (Path)otherLocalesStyleSheet, params).removeContent();
                this.mergeDefaultLang(defaultLang, otherLanguages);
                documents.addContent((Collection)otherLanguages);
            }
            documents.addContent((Content)defaultLang);
        }
        catch (Exception e) {
            documents.addContent((Content)this.onGetIndexFieldsError(e, xml));
        }
        return documents;
    }

    Element getIndexFields(Element xml, Path singleStyleSheet, String id) throws Exception {
        Element documents = new Element("Documents");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        params.put("uuid", ((DataManager)ApplicationContextHolder.get().getBean(DataManager.class)).getMetadataUuid(id));
        params.put("title", ((DataManager)ApplicationContextHolder.get().getBean(DataManager.class)).getMetadataTitle(id));
        try {
            documents = Xml.transform((Element)xml, (Path)singleStyleSheet, params);
        }
        catch (Exception e) {
            documents.addContent((Content)this.onGetIndexFieldsError(e, xml));
        }
        return documents;
    }

    private Element onGetIndexFieldsError(Exception e, Element xml) {
        IE_LOGGER.error("Indexing stylesheet contains errors: {}\t Marking the metadata as _indexingError=1 in index", (Object)e.getMessage());
        Element xmlDoc = new Element("Document");
        SearchManager.addField(xmlDoc, INDEXING_ERROR_FIELD, "1", true, true);
        SearchManager.addField(xmlDoc, INDEXING_ERROR_MSG, "GNIDX-XSL||" + e.getMessage(), true, false);
        StringBuilder sb = new StringBuilder();
        this.allText(xml, sb);
        SearchManager.addField(xmlDoc, "any", sb.toString(), false, true);
        return xmlDoc;
    }

    private boolean isInspireEnabled() {
        return ((SettingInfo)ApplicationContextHolder.get().getBean(SettingInfo.class)).getInspireEnabled();
    }

    private void mergeDefaultLang(Element defaultLang, List<Element> otherLanguages) {
        String langCode = defaultLang.getAttribute("locale") == null ? "" : defaultLang.getAttributeValue("locale");
        Element toMerge = null;
        for (Element element : otherLanguages) {
            Assert.isTrue((boolean)element.getName().equals("Document"));
            String clangCode = element.getAttribute("locale") == null ? "" : element.getAttributeValue("locale");
            if (!clangCode.equals(langCode)) continue;
            toMerge = element;
            break;
        }
        TreeSet<Element> toInclude = new TreeSet<Element>(new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                int name = this.compare(o1, o2, "name");
                int string = this.compare(o1, o2, "string");
                int store = this.compare(o1, o2, "store");
                int index = this.compare(o1, o2, "index");
                if (name != 0) {
                    return name;
                }
                if (string != 0) {
                    return string;
                }
                if (store != 0) {
                    return store;
                }
                if (index != 0) {
                    return index;
                }
                return 0;
            }

            private int compare(Element o1, Element o2, String attName) {
                return this.safeGet(o1, attName).compareTo(this.safeGet(o2, attName));
            }

            public String safeGet(Element e, String attName) {
                String att = e.getAttributeValue(attName);
                if (att == null) {
                    return "";
                }
                return att;
            }
        });
        if (toMerge != null) {
            toMerge.detach();
            otherLanguages.remove(toMerge);
            for (Element element : defaultLang.getChildren()) {
                toInclude.add(element);
            }
            for (Element element : toMerge.getChildren()) {
                toInclude.add(element);
            }
            toMerge.removeContent();
            defaultLang.removeContent();
            defaultLang.addContent(toInclude);
        }
    }

    Element transform(String styleSheetName, Element xml) throws Exception {
        try {
            Path styleSheetPath = this._stylesheetsDir.resolve(styleSheetName).toAbsolutePath();
            return Xml.transform((Element)xml, (Path)styleSheetPath);
        }
        catch (Exception e) {
            IE_LOGGER.error("Search stylesheet contains errors : {}", (Object)e.getMessage());
            throw e;
        }
    }

    public IndexAndTaxonomy getIndexReader(String preferredLang, long versionToken) throws IOException {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneIndexLanguageTracker tracker = (LuceneIndexLanguageTracker)applicationContext.getBean(LuceneIndexLanguageTracker.class);
        return tracker.acquire(preferredLang, versionToken);
    }

    public IndexAndTaxonomy getNewIndexReader(String preferredLang) throws IOException, InterruptedException {
        IE_LOGGER.debug("Ask for new reader");
        return this.getIndexReader(preferredLang, -1L);
    }

    public void releaseIndexReader(IndexAndTaxonomy reader) throws InterruptedException, IOException {
        reader.indexReader.releaseToNRTManager();
    }

    private void setupIndex(boolean rebuild) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rebuildIndex(ServiceContext context, boolean xlinks, boolean reset, String bucket) throws Exception {
        DataManager dataMan = context.getBean(DataManager.class);
        LuceneIndexLanguageTracker _tracker = context.getBean(LuceneIndexLanguageTracker.class);
        try {
            LuceneIndexLanguageTracker luceneIndexLanguageTracker;
            if (reset) {
                luceneIndexLanguageTracker = _tracker;
                synchronized (luceneIndexLanguageTracker) {
                    this.setupIndex(false);
                }
            }
            if (StringUtils.isNotBlank((String)bucket)) {
                dataMan.rebuildIndexForSelection(context, bucket, xlinks);
            } else if (xlinks) {
                dataMan.rebuildIndexXLinkedMetadata(context);
            } else {
                luceneIndexLanguageTracker = _tracker;
                synchronized (luceneIndexLanguageTracker) {
                    this.setupIndex(true);
                }
                dataMan.init(context, true);
            }
            return true;
        }
        catch (Exception e) {
            IE_LOGGER.error("Exception while rebuilding lucene index, going to rebuild it: {}", (Object)e.getMessage());
            return false;
        }
    }

    private IndexInformation newDocument(String language, Element xml, Collection<Field> multilingualSortFields) {
        Float f;
        Document doc = new Document();
        HashSet<CategoryPath> categories = new HashSet<CategoryPath>();
        for (Field field : multilingualSortFields) {
            doc.add((IndexableField)field);
        }
        FieldType storeNotTokenizedFieldType = new FieldType();
        storeNotTokenizedFieldType.setIndexed(true);
        storeNotTokenizedFieldType.setTokenized(false);
        storeNotTokenizedFieldType.setStored(true);
        FieldType storeNotIndexedFieldType = new FieldType();
        storeNotIndexedFieldType.setIndexed(true);
        storeNotIndexedFieldType.setTokenized(false);
        storeNotIndexedFieldType.setStored(true);
        float documentBoost = 1.0f;
        if (_documentBoostClass != null && (f = _documentBoostClass.getBoost(xml)) != null) {
            IE_LOGGER.debug("Boosting document with boost factor: {}", (Object)f);
            documentBoost = f.floatValue();
        }
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneConfig luceneConfig = (LuceneConfig)applicationContext.getBean(LuceneConfig.class);
        boolean hasLocaleField = false;
        for (Object o : xml.getChildren()) {
            Field f2;
            ArrayList<Field> fFacets;
            boolean bIndex;
            String string;
            String name;
            block13: {
                Element field = (Element)o;
                name = field.getAttributeValue(LuceneFieldAttribute.NAME.toString());
                string = field.getAttributeValue(LuceneFieldAttribute.STRING.toString());
                if (name.equals("_locale")) {
                    hasLocaleField = true;
                }
                if (string.trim().length() <= 0) continue;
                String sStore = field.getAttributeValue(LuceneFieldAttribute.STORE.toString());
                String sIndex = field.getAttributeValue(LuceneFieldAttribute.INDEX.toString());
                boolean bStore = sStore != null && sStore.equals("true");
                bIndex = sIndex != null && sIndex.equals("true");
                boolean token = luceneConfig.isTokenizedField(name);
                boolean isNumeric = luceneConfig.isNumericField(name);
                FieldType fieldType = new FieldType();
                fieldType.setStored(bStore);
                fieldType.setIndexed(bIndex);
                fieldType.setTokenized(token);
                fFacets = new ArrayList<Field>();
                if (isNumeric) {
                    try {
                        f2 = this.addNumericField(name, string, fieldType);
                        break block13;
                    }
                    catch (Exception e) {
                        String msg = "Invalid value. Field '" + name + "' is not added to the document. Error is: " + e.getMessage();
                        Field idxError = new Field(INDEXING_ERROR_FIELD, "1", storeNotTokenizedFieldType);
                        Field idxMsg = new Field(INDEXING_ERROR_MSG, "GNIDX-BADNUMVALUE|" + name + "|" + e.getMessage(), storeNotIndexedFieldType);
                        doc.add((IndexableField)idxError);
                        doc.add((IndexableField)idxMsg);
                        IE_LOGGER.warn(msg);
                        continue;
                    }
                }
                f2 = new Field(name, string, fieldType);
            }
            fFacets.addAll(this.getFacetFieldsFor(language, name, string));
            if (bIndex && !f2.fieldType().omitNorms()) {
                Float boost = luceneConfig.getFieldBoost(name);
                if (boost != null) {
                    IE_LOGGER.debug("Boosting field: {} with boost factor: {} x {}", new Object[]{name, boost, Float.valueOf(documentBoost)});
                    f2.setBoost(documentBoost * boost.floatValue());
                } else if (documentBoost != 1.0f) {
                    f2.setBoost(documentBoost);
                }
            }
            doc.add((IndexableField)f2);
            for (Field fFacet : fFacets) {
                IE_LOGGER.debug("Facet field: {}", (Object)fFacet.toString());
                doc.add((IndexableField)fFacet);
            }
        }
        if (!hasLocaleField) {
            doc.add((IndexableField)new Field("_locale", "eng", storeNotTokenizedFieldType));
        }
        return new IndexInformation(language, doc, categories);
    }

    private List<Field> getFacetFieldsFor(String locale, String indexKey, String value) {
        ArrayList<Field> result = new ArrayList<Field>();
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneConfig luceneConfig = (LuceneConfig)applicationContext.getBean(LuceneConfig.class);
        for (Dimension dimension : luceneConfig.getDimensionsUsing(indexKey)) {
            result.addAll(this.getFacetFieldsFor(locale, dimension, value));
        }
        return result;
    }

    private List<Field> getFacetFieldsFor(String locale, Dimension dimension, String value) {
        ArrayList<Field> result = new ArrayList<Field>();
        Classifier classifier = dimension.getClassifier();
        for (CategoryPath categoryPath : classifier.classify(value)) {
            result.add((Field)new FacetField(dimension.getName(), categoryPath.components));
            if (!dimension.isLocalized() || !dimension.getLocales().contains(locale)) continue;
            result.add((Field)new FacetField(dimension.getName(locale), categoryPath.components));
        }
        return result;
    }

    private Field addNumericField(String name, String string, FieldType fieldType) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        LuceneConfig luceneConfig = (LuceneConfig)applicationContext.getBean(LuceneConfig.class);
        LuceneConfig.LuceneConfigNumericField fieldConfig = luceneConfig.getNumericField(name);
        IE_LOGGER.debug("Indexing numeric field: {} with value: {}", (Object)name, (Object)string);
        try {
            DoubleField field;
            String paramType = fieldConfig.getType();
            if ("double".equals(paramType)) {
                double d = Double.valueOf(string);
                fieldType.setNumericType(FieldType.NumericType.DOUBLE);
                field = new DoubleField(name, d, fieldType);
            } else if ("float".equals(paramType)) {
                float f = Float.valueOf(string).floatValue();
                fieldType.setNumericType(FieldType.NumericType.FLOAT);
                field = new FloatField(name, f, fieldType);
            } else if ("long".equals(paramType)) {
                long l = Long.parseLong(string);
                fieldType.setNumericType(FieldType.NumericType.LONG);
                field = new LongField(name, l, fieldType);
            } else {
                int i = Integer.parseInt(string);
                fieldType.setNumericType(FieldType.NumericType.INT);
                field = new IntField(name, i, fieldType);
            }
            return field;
        }
        catch (Exception e) {
            IE_LOGGER.warn("Failed to index numeric field: {} with value: {}, error is: {}", new Object[]{name, string, e.getMessage()});
            throw e;
        }
    }

    public Spatial getSpatial() {
        return this._spatial;
    }

    LuceneIndexLanguageTracker getIndexTracker() {
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        return (LuceneIndexLanguageTracker)context.getBean(LuceneIndexLanguageTracker.class);
    }

    public boolean optimizeIndex() {
        try {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            LuceneIndexLanguageTracker tracker = (LuceneIndexLanguageTracker)applicationContext.getBean(LuceneIndexLanguageTracker.class);
            tracker.optimize();
            return true;
        }
        catch (Throwable e) {
            IE_LOGGER.error("Exception while optimizing lucene index: {}", (Object)e.getMessage());
            return false;
        }
    }

    static {
        analyzerMap = new HashMap<String, Analyzer>();
        searchAnalyzerMap = new HashMap<String, Analyzer>();
    }

    public class Spatial {
        private static final long TIME_BETWEEN_SPATIAL_COMMITS_IN_SECONDS = 10L;
        private final DataStore _datastore;
        private final Map<String, Constructor<? extends SpatialFilter>> _types;
        private final Transaction _transaction;
        private final int _maxWritesInTransaction;
        private final Parser[] _gmlParsers;
        private final Lock _lock;
        private SpatialIndexWriter _writer;
        private volatile Committer _committerTask;

        public Spatial(DataStore dataStore, int maxWritesInTransaction) throws Exception {
            HashMap<String, Constructor> types = new HashMap<String, Constructor>();
            try {
                types.put("encloses".toLowerCase(), SearchManager.constructor(ContainsFilter.class));
                types.put("crosses".toLowerCase(), SearchManager.constructor(CrossesFilter.class));
                types.put("fullyOutsideOf".toLowerCase(), SearchManager.constructor(IsFullyOutsideOfFilter.class));
                types.put("equal".toLowerCase(), SearchManager.constructor(EqualsFilter.class));
                types.put("intersection".toLowerCase(), SearchManager.constructor(IntersectionFilter.class));
                types.put("overlaps".toLowerCase(), SearchManager.constructor(OverlapsFilter.class));
                types.put("touches".toLowerCase(), SearchManager.constructor(TouchesFilter.class));
                types.put("within_bbox".toLowerCase(), SearchManager.constructor(WithinBBoxFilter.class));
                types.put("overlaps_bbox".toLowerCase(), SearchManager.constructor(OverlapsBBoxFilter.class));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to create types mapping", e);
            }
            this._types = Collections.unmodifiableMap(types);
            this._gmlParsers = GMLParsers.create();
            this._lock = new ReentrantLock();
            this._datastore = dataStore;
            this._transaction = maxWritesInTransaction > 1 ? new DefaultTransaction("SpatialIndexWriter") : Transaction.AUTO_COMMIT;
            this._maxWritesInTransaction = maxWritesInTransaction;
            boolean rebuildIndex = this.createWriter(this._datastore);
            if (rebuildIndex) {
                SearchManager.this.setupIndex(true);
            } else {
                this._writer.getIndex();
            }
        }

        private boolean createWriter(DataStore datastore) throws IOException {
            boolean rebuildIndex;
            try {
                this._writer = new SpatialIndexWriter(datastore, this._gmlParsers, this._transaction, this._maxWritesInTransaction, this._lock);
                rebuildIndex = this._writer.getFeatureSource().getSchema() == null;
            }
            catch (Throwable e) {
                if (this._writer == null) {
                    throw new RuntimeException(e);
                }
                String exceptionString = Xml.getString((Element)JeevesException.toElement((Throwable)e));
                SP_LOGGER.warn("Failure to make _writer, maybe a problem but might also not be an issue: {}", (Object)exceptionString);
                try {
                    this._writer.reset();
                }
                catch (Exception e1) {
                    SP_LOGGER.error("Unable to call reset on Spatial writer: {}", (Object)e1.getMessage());
                    e1.printStackTrace();
                }
                rebuildIndex = true;
            }
            return rebuildIndex;
        }

        public void end() {
            this._lock.lock();
            try {
                this._writer.close();
            }
            catch (IOException e) {
                SP_LOGGER.error("error closing spatial index: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
            finally {
                this._lock.unlock();
            }
        }

        public Filter filter(Query query, int numHits, Element filterExpr, String filterVersion) throws Exception {
            this._lock.lock();
            try {
                Parser filterParser = this.getFilterParser(filterVersion);
                SpatialIndexAccessor accessor = new SpatialIndexAccessor();
                SpatialFilter spatialFilter = OgcGenericFilters.create(query, numHits, filterExpr, accessor, filterParser);
                return spatialFilter;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error when parsing spatial filter (version: " + filterVersion + "):" + Xml.getString((Element)filterExpr) + ". Error is: " + e.toString());
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpatialFilter filter(Query query, int numHits, Collection<Geometry> geom, Element request) throws Exception {
            this._lock.lock();
            try {
                String relation = Util.getParam((Element)request, (String)"relation", (String)"intersection");
                if (geom.size() == 1) {
                    SpatialFilter spatialFilter = this._types.get(relation.toLowerCase()).newInstance(new Object[]{query, numHits, geom.iterator().next(), new SpatialIndexAccessor()});
                    return spatialFilter;
                }
                ArrayList<SpatialFilter> filters = new ArrayList<SpatialFilter>(geom.size());
                Envelope bounds = null;
                for (Geometry geometry : geom) {
                    if (bounds == null) {
                        bounds = geometry.getEnvelopeInternal();
                    } else {
                        bounds.expandToInclude(geometry.getEnvelopeInternal());
                    }
                    filters.add(this._types.get(relation).newInstance(new Object[]{query, numHits, geometry, new SpatialIndexAccessor()}));
                }
                Object object = new OrSpatialFilter(query, numHits, bounds, new SpatialIndexAccessor(), filters);
                return object;
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpatialIndexWriter writer() throws Exception {
            this._lock.lock();
            try {
                if (this._committerTask != null) {
                    this._committerTask.cancel();
                }
                this._committerTask = new Committer();
                ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
                ScheduledThreadPoolExecutor timer = (ScheduledThreadPoolExecutor)applicationContext.getBean("timerThreadPool", ScheduledThreadPoolExecutor.class);
                timer.schedule(this._committerTask, 10L, TimeUnit.SECONDS);
                SpatialIndexWriter spatialIndexWriter = this.writerNoLocking();
                return spatialIndexWriter;
            }
            finally {
                this._lock.unlock();
            }
        }

        private SpatialIndexWriter writerNoLocking() throws Exception {
            if (this._writer == null) {
                this._writer = new SpatialIndexWriter(this._datastore, this._gmlParsers, this._transaction, this._maxWritesInTransaction, this._lock);
            }
            return this._writer;
        }

        private Parser getFilterParser(String filterVersion) {
            Configuration config;
            if (filterVersion.equals("1.0.0")) {
                config = FILTER_1_0_0;
            } else if (filterVersion.equals("2.0.0")) {
                config = FILTER_2_0_0;
            } else if (filterVersion.equals("1.1.0")) {
                config = FILTER_1_1_0;
            } else {
                throw new IllegalArgumentException("UnsupportFilterVersion: " + filterVersion);
            }
            return new Parser(config);
        }

        private class Committer
        implements Runnable {
            private AtomicBoolean cancelled = new AtomicBoolean(false);

            private Committer() {
            }

            @Override
            public void run() {
                if (this.cancelled.get()) {
                    return;
                }
                Spatial.this._lock.lock();
                try {
                    if (Spatial.this._committerTask == this) {
                        Spatial.this._writer.commit();
                        Spatial.this._committerTask = null;
                    }
                }
                catch (IOException e) {
                    SP_LOGGER.error("error writing spatial index {}", (Object)e.getMessage());
                }
                finally {
                    Spatial.this._lock.unlock();
                }
            }

            public void cancel() {
                this.cancelled.set(true);
            }
        }

        private final class SpatialIndexAccessor
        extends Pair<FeatureSource<SimpleFeatureType, SimpleFeature>, SpatialIndex> {
            private SpatialIndexAccessor() {
            }

            public FeatureSource<SimpleFeatureType, SimpleFeature> one() {
                return Spatial.this._writer.getFeatureSource();
            }

            public SpatialIndex two() {
                try {
                    return Spatial.this._writer.getIndex();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class TermFrequency
    implements Comparable<Object> {
        private String term;
        private int frequency;

        public TermFrequency(String term, int frequency) {
            this.term = term;
            this.frequency = frequency;
        }

        public String getTerm() {
            return this.term;
        }

        public int getFrequency() {
            return this.frequency;
        }

        public void setFrequency(int frequency) {
            this.frequency = frequency;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof TermFrequency) {
                TermFrequency oFreq = (TermFrequency)o;
                return this.term.compareTo(oFreq.term);
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.frequency;
            result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TermFrequency other = (TermFrequency)obj;
            return this.compareTo(other) == 0;
        }

        public void inc(int otherEncounters) {
            this.frequency += otherEncounters;
        }
    }

    public static enum LuceneFieldAttribute {
        NAME{

            public String toString() {
                return "name";
            }
        }
        ,
        STRING{

            public String toString() {
                return "string";
            }
        }
        ,
        STORE{

            public String toString() {
                return "store";
            }
        }
        ,
        INDEX{

            public String toString() {
                return "index";
            }
        };

    }
}

