/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.kernel.search.Translator;
import org.fao.geonet.kernel.search.TranslatorCache;
import org.fao.geonet.utils.Log;
import org.jdom.JDOMException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.repository.JpaRepository;

public class DbDescTranslator
implements Translator {
    private static final long serialVersionUID = 1L;
    private final String _langCode;
    private final String _methodName;
    private final String _parameterType;
    private ConfigurableApplicationContext _applicationContext;
    private Class<? extends JpaRepository> _repositoryClass;
    private String _beanName;

    public DbDescTranslator(ConfigurableApplicationContext applicationContext, String langCode, String param) throws IOException, JDOMException, ClassNotFoundException {
        String[] parts = param.split(":", 3);
        try {
            this._repositoryClass = Class.forName(parts[0]);
        }
        catch (Exception e) {
            this._beanName = parts[0];
        }
        this._methodName = parts.length == 2 ? parts[1] : "findOne";
        this._parameterType = parts.length == 3 ? parts[2] : "String";
        this._applicationContext = applicationContext;
        this._langCode = langCode;
    }

    @Override
    public String translate(String key) {
        try {
            TranslatorCache cache;
            Optional<Localized> entityOptional;
            Localized entity = null;
            if (this._applicationContext == null) {
                this._applicationContext = ApplicationContextHolder.get();
            }
            if ((entityOptional = (cache = (TranslatorCache)this._applicationContext.getBean(TranslatorCache.class)).get(key)) != null) {
                entity = entityOptional.isPresent() ? (Localized)entityOptional.get() : null;
            } else {
                JpaRepository repository = this._repositoryClass != null ? (JpaRepository)this._applicationContext.getBean(this._repositoryClass) : (JpaRepository)this._applicationContext.getBean(this._beanName, JpaRepository.class);
                Class<?> repositoryClass = repository.getClass();
                entity = this.findEntity(key, repository, repositoryClass);
                cache.put(this._applicationContext, key, entity);
            }
            if (entity == null) {
                return key;
            }
            String label = entity.getLabel(this._langCode);
            if (label == null) {
                return key;
            }
            return label;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork", (Object)"Error translating a string", (Throwable)e);
            return key;
        }
    }

    private Localized findEntity(String key, JpaRepository repository, Class<?> repositoryClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method[] methods = repositoryClass.getMethods();
        Localized entity = null;
        for (Method method : methods) {
            if (!method.getName().equals(this._methodName) || method.getParameterTypes().length != 1) continue;
            try {
                entity = this._parameterType.equals("int") ? (Localized)method.invoke((Object)repository, Integer.valueOf(key)) : (this._parameterType.equals("long") ? (Localized)method.invoke((Object)repository, Long.valueOf(key)) : (this._parameterType.equals("double") ? (Localized)method.invoke((Object)repository, Double.valueOf(key)) : (this._parameterType.equals("float") ? (Localized)method.invoke((Object)repository, Float.valueOf(key)) : (this._parameterType.equals("boolean") ? (Localized)method.invoke((Object)repository, Boolean.valueOf(key)) : (this._parameterType.equals("short") ? (Localized)method.invoke((Object)repository, Short.valueOf(key)) : (this._parameterType.equals("char") ? (Localized)method.invoke((Object)repository, Character.valueOf(key.charAt(0))) : (Localized)method.invoke((Object)repository, key)))))));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (entity == null) {
                try {
                    entity = (Localized)method.invoke((Object)repository, key);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (entity != null) break;
        }
        if (entity != null) {
            return entity;
        }
        if (repositoryClass.getSuperclass() != null) {
            entity = this.findEntity(key, repository, repositoryClass.getSuperclass());
        }
        if (entity == null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = repositoryClass.getInterfaces()) {
                entity = this.findEntity(key, repository, anInterface);
                if (entity == null) continue;
                return entity;
            }
        }
        return null;
    }
}

