/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public abstract class XmlSerializer {
    private static InheritableThreadLocal<ThreadLocalConfiguration> configThreadLocal = new InheritableThreadLocal();

    public static ThreadLocalConfiguration getThreadLocal(boolean setIfNotPresent) {
        ThreadLocalConfiguration config = (ThreadLocalConfiguration)configThreadLocal.get();
        if (config == null && setIfNotPresent) {
            config = new ThreadLocalConfiguration();
            configThreadLocal.set(config);
        }
        return config;
    }

    public static void clearThreadLocal() {
        configThreadLocal.set(null);
    }

    public static void removeFilteredElement(Element metadata, Pair<String, Element> xPathAndMarkedElement, List<Namespace> namespaces) throws JDOMException {
        if (xPathAndMarkedElement == null) {
            return;
        }
        String xpath = (String)xPathAndMarkedElement.one();
        Element mark = (Element)xPathAndMarkedElement.two();
        List nodes = Xml.selectNodes((Element)metadata, (String)xpath, namespaces);
        for (Object object : nodes) {
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (mark != null) {
                element.removeContent();
                ArrayList atts = new ArrayList(element.getAttributes());
                for (Attribute attribute : atts) {
                    attribute.detach();
                }
                ArrayList markAtts = new ArrayList(mark.getAttributes());
                for (Attribute attribute : markAtts) {
                    element.setAttribute((Attribute)attribute.clone());
                }
                for (Object o : mark.getChildren()) {
                    if (!(o instanceof Element)) continue;
                    Element e = (Element)o;
                    element.setContent((Content)((Element)e.clone()));
                }
                continue;
            }
            element.detach();
        }
    }

    public boolean resolveXLinks() {
        SettingManager _settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        if (_settingManager == null) {
            Log.error((String)"geonetwork.datamanager", (Object)"No settingManager in XmlSerializer, XLink Resolver disabled.");
            return false;
        }
        String xlR = _settingManager.getValue("system/xlinkResolver/enable");
        if (xlR != null) {
            boolean isEnabled = xlR.equals("true");
            if (isEnabled) {
                Log.debug((String)"geonetwork.datamanager", (Object)"XLink Resolver enabled.");
            } else {
                Log.debug((String)"geonetwork.datamanager", (Object)"XLink Resolver disabled.");
            }
            return isEnabled;
        }
        Log.error((String)"geonetwork.datamanager", (Object)"XLink resolver setting does not exist! XLink Resolver disabled.");
        return false;
    }

    public boolean isLoggingEmptyWithHeld() {
        SettingManager _settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        if (_settingManager == null) {
            return false;
        }
        String enableLogging = _settingManager.getValue("system/hidewithheldelements/enableLogging");
        if (enableLogging != null) {
            return enableLogging.equals("true");
        }
        return false;
    }

    protected Element internalSelect(String id, boolean isIndexingTask, boolean applyOperationsFilters) throws Exception {
        IMetadataUtils _metadataUtils = (IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class);
        AbstractMetadata metadata = _metadataUtils.findOne(Integer.parseInt(id));
        if (metadata == null) {
            return null;
        }
        return this.removeHiddenElements(isIndexingTask, metadata, applyOperationsFilters);
    }

    public Element removeHiddenElements(boolean isIndexingTask, AbstractMetadata metadata, boolean applyOperationsFilters) throws Exception {
        AccessManager accessManager = (AccessManager)ApplicationContextHolder.get().getBean(AccessManager.class);
        DataManager _dataManager = (DataManager)ApplicationContextHolder.get().getBean(DataManager.class);
        String id = String.valueOf(metadata.getId());
        Element metadataXml = metadata.getXmlData(false);
        if (!isIndexingTask && applyOperationsFilters) {
            ServiceContext context = ServiceContext.get();
            MetadataSchema mds = _dataManager.getSchema(metadata.getDataInfo().getSchemaId());
            Pair<String, Element> editXpathFilter = mds.getOperationFilter(ReservedOperation.editing);
            boolean filterEditOperationElements = editXpathFilter != null;
            List<Namespace> namespaces = mds.getNamespaces();
            if (context != null) {
                boolean canDynamic;
                Pair<String, Element> dynamicXpathFilter;
                boolean canDownload;
                Pair<String, Element> downloadXpathFilter;
                boolean canEdit;
                if (editXpathFilter != null && (canEdit = accessManager.canEdit(context, id))) {
                    filterEditOperationElements = false;
                }
                if ((downloadXpathFilter = mds.getOperationFilter(ReservedOperation.download)) != null && !(canDownload = accessManager.canDownload(context, id))) {
                    XmlSerializer.removeFilteredElement(metadataXml, downloadXpathFilter, namespaces);
                }
                if ((dynamicXpathFilter = mds.getOperationFilter(ReservedOperation.dynamic)) != null && !(canDynamic = accessManager.canDynamic(context, id))) {
                    XmlSerializer.removeFilteredElement(metadataXml, dynamicXpathFilter, namespaces);
                }
            }
            if (filterEditOperationElements || XmlSerializer.getThreadLocal(false) != null && XmlSerializer.getThreadLocal(false).forceFilterEditOperation) {
                XmlSerializer.removeFilteredElement(metadataXml, editXpathFilter, namespaces);
            }
        }
        return metadataXml;
    }

    protected AbstractMetadata insertDb(AbstractMetadata newMetadata, Element dataXml, ServiceContext context) throws SQLException {
        if (this.resolveXLinks()) {
            Processor.removeXLink(dataXml);
        }
        newMetadata.setData(Xml.getString((Element)dataXml));
        return context.getBean(IMetadataManager.class).save(newMetadata);
    }

    protected void updateDb(String id, Element xml, String changeDate, String root, boolean updateDateStamp, String uuid) throws SQLException {
        if (this.resolveXLinks()) {
            Processor.removeXLink(xml);
        }
        IMetadataManager _metadataManager = (IMetadataManager)ApplicationContextHolder.get().getBean(IMetadataManager.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class);
        int metadataId = Integer.valueOf(id);
        AbstractMetadata md = metadataUtils.findOne(metadataId);
        md.setDataAndFixCR(xml);
        if (updateDateStamp) {
            if (changeDate == null) {
                md.getDataInfo().setChangeDate(new ISODate());
            } else {
                md.getDataInfo().setChangeDate(new ISODate(changeDate));
            }
        }
        if (uuid != null) {
            md.setUuid(uuid);
        }
        _metadataManager.save(md);
    }

    protected void deleteDb(String id) throws Exception {
        IMetadataManager _metadataManager = (IMetadataManager)ApplicationContextHolder.get().getBean(IMetadataManager.class);
        _metadataManager.delete(Integer.valueOf(id));
    }

    public abstract void delete(String var1, ServiceContext var2) throws Exception;

    public abstract void update(String var1, Element var2, String var3, boolean var4, String var5, ServiceContext var6) throws Exception;

    public abstract AbstractMetadata insert(AbstractMetadata var1, Element var2, ServiceContext var3) throws Exception;

    public abstract Element select(ServiceContext var1, String var2) throws Exception;

    public abstract Element selectNoXLinkResolver(String var1, boolean var2, boolean var3) throws Exception;

    public static class ThreadLocalConfiguration {
        private boolean forceFilterEditOperation = false;

        public boolean isForceFilterEditOperation() {
            return this.forceFilterEditOperation;
        }

        public void setForceFilterEditOperation(boolean forceFilterEditOperation) {
            this.forceFilterEditOperation = forceFilterEditOperation;
        }
    }
}

