/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.utils.Log;
import org.springframework.transaction.TransactionStatus;

public final class IndexMetadataTask
implements Runnable {
    private final ServiceContext _context;
    private final List<?> _metadataIds;
    private final TransactionStatus _transactionStatus;
    private final Set<IndexMetadataTask> _batchIndex;
    private final SearchManager searchManager;
    private final AtomicInteger indexed;
    private User _user;

    public IndexMetadataTask(@Nonnull ServiceContext context, @Nonnull List<?> metadataIds, Set<IndexMetadataTask> batchIndex, @Nullable TransactionStatus transactionStatus, @Nonnull AtomicInteger indexed) {
        this.indexed = indexed;
        this._transactionStatus = transactionStatus;
        this._context = context;
        this._metadataIds = metadataIds;
        this._batchIndex = batchIndex;
        this.searchManager = context.getBean(SearchManager.class);
        batchIndex.add(this);
        if (context.getUserSession() != null) {
            this._user = context.getUserSession().getPrincipal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._context.setAsThreadLocal();
            while (this._transactionStatus != null && !this._transactionStatus.isCompleted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this._batchIndex.remove(this);
                    return;
                }
            }
            while (!this._context.isServletInitialized()) {
                if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                    Log.debug((String)"geonetwork.datamanager", (Object)"Waiting for servlet to finish initializing..");
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            DataManager dataManager = this._context.getBean(DataManager.class);
            for (Object metadataId : this._metadataIds) {
                this.indexed.incrementAndGet();
                if (this.indexed.compareAndSet(500, 0)) {
                    try {
                        this.searchManager.forceIndexChanges();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    dataManager.indexMetadata(metadataId.toString(), false, null);
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.index", (Object)("Error indexing metadata '" + metadataId + "': " + e.getMessage() + "\n" + Util.getStackTrace((Throwable)e)));
                }
            }
            if (this._user != null && this._context.getUserSession().getUserId() == null) {
                this._context.getUserSession().loginAs(this._user);
            }
            this.searchManager.forceIndexChanges();
        }
        catch (IOException e) {
            Log.error((String)"geonetwork.index", (Object)"Error occurred indexing metadata", (Throwable)e);
        }
        finally {
            this._batchIndex.remove(this);
        }
    }
}

