/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.sources.http;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.sources.ServiceRequest;

public class HttpServiceRequest
extends ServiceRequest {
    private HttpServletResponse httpRes;

    public HttpServiceRequest(HttpServletResponse res) {
        this.httpRes = res;
    }

    @Override
    public void beginStream(String contentType, boolean cache) {
        this.beginStream(contentType, -1, null, cache);
    }

    @Override
    public void beginStream(String contentType, int contentLength, String contentDisposition, boolean cache) {
        this.httpRes.setStatus(this.statusCode);
        if (contentType != null) {
            this.httpRes.setContentType(contentType);
        }
        if (contentLength != -1) {
            this.httpRes.setContentLength(contentLength);
        }
        if (contentDisposition != null) {
            this.httpRes.addHeader("Content-disposition", contentDisposition);
        } else if (!cache) {
            this.httpRes.addHeader("Pragma", "no-cache");
            this.httpRes.addHeader("Cache-Control", "no-cache");
            this.httpRes.addHeader("Expires", "-1");
        }
    }

    @Override
    public void endStream() throws IOException {
        this.httpRes.flushBuffer();
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpRes;
    }
}

