/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.overrides;

import java.util.Properties;
import jeeves.server.overrides.Updater;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

abstract class BeanUpdater
implements Updater {
    protected String beanName;

    BeanUpdater() {
    }

    public void setBeanName(Element element) {
        this.beanName = element.getAttributeValue("bean");
    }

    @Override
    public final void update(ConfigurableListableBeanFactory beanFactory, Properties properties) {
        try {
            BeanDefinition bean = beanFactory.getBeanDefinition(this.beanName);
            this.update(beanFactory, properties, bean);
        }
        catch (NoSuchBeanDefinitionException e) {
            Log.warning((String)"jeeves", (Object)("Unable apply override to bean: " + this.beanName + " because bean was not found"));
        }
    }

    @Override
    public boolean runOnFinish() {
        return false;
    }

    protected abstract void update(ConfigurableListableBeanFactory var1, Properties var2, BeanDefinition var3);
}

