/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.util.logging.Logger;

public class GroupShutdownException
extends EnvironmentFailureException {
    private final long shutdownTimeMs;
    private final String masterNodeName;
    private final VLSN shutdownVLSN;
    private String wrapMessage = null;

    public GroupShutdownException(Logger logger, RepNode repNode, long shutdownTimeMs) {
        super((EnvironmentImpl)repNode.getRepImpl(), EnvironmentFailureReason.SHUTDOWN_REQUESTED, (Throwable)null);
        this.shutdownVLSN = repNode.getVLSNIndex().getRange().getLast();
        this.masterNodeName = repNode.getMasterStatus().getNodeMasterNameId().getName();
        this.shutdownTimeMs = shutdownTimeMs;
        LoggerUtils.warning(logger, repNode.getRepImpl(), "Explicit shutdown request from Master:" + this.masterNodeName);
    }

    private GroupShutdownException(String message, GroupShutdownException shutdownException) {
        super(message, shutdownException);
        this.shutdownVLSN = shutdownException.shutdownVLSN;
        this.shutdownTimeMs = shutdownException.shutdownTimeMs;
        this.masterNodeName = shutdownException.masterNodeName;
        this.wrapMessage = message;
    }

    public String getMessage() {
        return this.wrapMessage != null ? this.wrapMessage : String.format("Master:%s, initiated shutdown on %1tc.", this.masterNodeName, this.shutdownTimeMs);
    }

    public GroupShutdownException wrapSelf(String msg) {
        return new GroupShutdownException(msg, this);
    }

    public VLSN getShutdownVLSN() {
        return this.shutdownVLSN;
    }
}

