/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.concurrent.atomic.AtomicLong;

public class NodeSequence {
    public static final int FIRST_LOCAL_NODE_ID = 1;
    public static final int FIRST_REPLICATED_NODE_ID = -10;
    private AtomicLong lastAllocatedLocalNodeId = null;
    private AtomicLong lastAllocatedReplicatedNodeId = null;
    private AtomicLong lastAllocatedTransientNodeId = null;
    public final EnvironmentImpl envImpl;

    public NodeSequence(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
    }

    void initTransientNodeId() {
        this.lastAllocatedTransientNodeId = new AtomicLong(Long.MAX_VALUE);
    }

    void initRealNodeId() {
        this.lastAllocatedLocalNodeId = new AtomicLong(0L);
        this.lastAllocatedReplicatedNodeId = new AtomicLong(-9L);
    }

    public long getLastLocalNodeId() {
        return this.lastAllocatedLocalNodeId.get();
    }

    public long getLastReplicatedNodeId() {
        return this.lastAllocatedReplicatedNodeId.get();
    }

    public long getNextLocalNodeId() {
        return this.lastAllocatedLocalNodeId.incrementAndGet();
    }

    public long getNextReplicatedNodeId() {
        return this.lastAllocatedReplicatedNodeId.decrementAndGet();
    }

    public long getNextTransientNodeId() {
        assert (this.noOverlap()) : "transient=" + this.lastAllocatedTransientNodeId.get();
        return this.lastAllocatedTransientNodeId.decrementAndGet();
    }

    private boolean noOverlap() {
        return this.lastAllocatedLocalNodeId != null ? this.lastAllocatedTransientNodeId.get() - 1L > this.lastAllocatedLocalNodeId.get() : true;
    }

    public void setLastNodeId(long lastReplicatedNodeId, long lastLocalNodeId) {
        this.lastAllocatedReplicatedNodeId.set(lastReplicatedNodeId);
        this.lastAllocatedLocalNodeId.set(lastLocalNodeId);
    }

    public void updateFromReplay(long replayNodeId) {
        assert (!this.envImpl.isMaster());
        if (replayNodeId > 0L && !this.envImpl.isConverted()) {
            throw EnvironmentFailureException.unexpectedState("replay node id is unexpectedly positive " + replayNodeId);
        }
        if (replayNodeId < this.lastAllocatedReplicatedNodeId.get()) {
            this.lastAllocatedReplicatedNodeId.set(replayNodeId);
        }
    }
}

