/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.stats.Snapshot;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsServlet
extends HttpServlet
implements MetricProcessor<Context> {
    public static final String REGISTRY_ATTRIBUTE = MetricsServlet.class.getName() + ".registry";
    public static final String JSON_FACTORY_ATTRIBUTE = JsonFactory.class.getCanonicalName();
    public static final String SHOW_JVM_METRICS = "show-jvm-metrics";
    private static final JsonFactory DEFAULT_JSON_FACTORY = new JsonFactory((ObjectCodec)new ObjectMapper());
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsServlet.class);
    private static final String CONTENT_TYPE = "application/json";
    private final Clock clock;
    private final VirtualMachineMetrics vm;
    private MetricsRegistry registry;
    private JsonFactory factory;
    private boolean showJvmMetrics;

    public MetricsServlet() {
        this(Clock.defaultClock(), VirtualMachineMetrics.getInstance(), Metrics.defaultRegistry(), DEFAULT_JSON_FACTORY, true);
    }

    public MetricsServlet(boolean showJvmMetrics) {
        this(Clock.defaultClock(), VirtualMachineMetrics.getInstance(), Metrics.defaultRegistry(), DEFAULT_JSON_FACTORY, showJvmMetrics);
    }

    public MetricsServlet(Clock clock, VirtualMachineMetrics vm, MetricsRegistry registry, JsonFactory factory, boolean showJvmMetrics) {
        this.clock = clock;
        this.vm = vm;
        this.registry = registry;
        this.factory = factory;
        this.showJvmMetrics = showJvmMetrics;
    }

    public void init(ServletConfig config) throws ServletException {
        String showJvmMetricsParam;
        Object o;
        Object factory = config.getServletContext().getAttribute(JSON_FACTORY_ATTRIBUTE);
        if (factory instanceof JsonFactory) {
            this.factory = (JsonFactory)factory;
        }
        if ((o = config.getServletContext().getAttribute(REGISTRY_ATTRIBUTE)) instanceof MetricsRegistry) {
            this.registry = (MetricsRegistry)o;
        }
        if ((showJvmMetricsParam = config.getInitParameter(SHOW_JVM_METRICS)) != null) {
            this.showJvmMetrics = Boolean.parseBoolean(showJvmMetricsParam);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String classPrefix = req.getParameter("class");
        boolean pretty = Boolean.parseBoolean(req.getParameter("pretty"));
        boolean showFullSamples = Boolean.parseBoolean(req.getParameter("full-samples"));
        resp.setStatus(200);
        resp.setContentType(CONTENT_TYPE);
        ServletOutputStream output = resp.getOutputStream();
        JsonGenerator json = this.factory.createJsonGenerator((OutputStream)output, JsonEncoding.UTF8);
        if (pretty) {
            json.useDefaultPrettyPrinter();
        }
        json.writeStartObject();
        if (this.showJvmMetrics && ("jvm".equals(classPrefix) || classPrefix == null)) {
            this.writeVmMetrics(json);
        }
        this.writeRegularMetrics(json, classPrefix, showFullSamples);
        json.writeEndObject();
        json.close();
    }

    private void writeVmMetrics(JsonGenerator json) throws IOException {
        json.writeFieldName("jvm");
        json.writeStartObject();
        json.writeFieldName("vm");
        json.writeStartObject();
        json.writeStringField("name", this.vm.name());
        json.writeStringField("version", this.vm.version());
        json.writeEndObject();
        json.writeFieldName("memory");
        json.writeStartObject();
        json.writeNumberField("totalInit", this.vm.totalInit());
        json.writeNumberField("totalUsed", this.vm.totalUsed());
        json.writeNumberField("totalMax", this.vm.totalMax());
        json.writeNumberField("totalCommitted", this.vm.totalCommitted());
        json.writeNumberField("heapInit", this.vm.heapInit());
        json.writeNumberField("heapUsed", this.vm.heapUsed());
        json.writeNumberField("heapMax", this.vm.heapMax());
        json.writeNumberField("heapCommitted", this.vm.heapCommitted());
        json.writeNumberField("heap_usage", this.vm.heapUsage());
        json.writeNumberField("non_heap_usage", this.vm.nonHeapUsage());
        json.writeFieldName("memory_pool_usages");
        json.writeStartObject();
        for (Map.Entry pool : this.vm.memoryPoolUsage().entrySet()) {
            json.writeNumberField((String)pool.getKey(), ((Double)pool.getValue()).doubleValue());
        }
        json.writeEndObject();
        json.writeEndObject();
        Map bufferPoolStats = this.vm.getBufferPoolStats();
        if (!bufferPoolStats.isEmpty()) {
            json.writeFieldName("buffers");
            json.writeStartObject();
            json.writeFieldName("direct");
            json.writeStartObject();
            json.writeNumberField("count", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("direct")).getCount());
            json.writeNumberField("memoryUsed", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("direct")).getMemoryUsed());
            json.writeNumberField("totalCapacity", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("direct")).getTotalCapacity());
            json.writeEndObject();
            json.writeFieldName("mapped");
            json.writeStartObject();
            json.writeNumberField("count", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("mapped")).getCount());
            json.writeNumberField("memoryUsed", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("mapped")).getMemoryUsed());
            json.writeNumberField("totalCapacity", ((VirtualMachineMetrics.BufferPoolStats)bufferPoolStats.get("mapped")).getTotalCapacity());
            json.writeEndObject();
            json.writeEndObject();
        }
        json.writeNumberField("daemon_thread_count", this.vm.daemonThreadCount());
        json.writeNumberField("thread_count", this.vm.threadCount());
        json.writeNumberField("current_time", this.clock.time());
        json.writeNumberField("uptime", this.vm.uptime());
        json.writeNumberField("fd_usage", this.vm.fileDescriptorUsage());
        json.writeFieldName("thread-states");
        json.writeStartObject();
        for (Map.Entry entry : this.vm.threadStatePercentages().entrySet()) {
            json.writeNumberField(((Thread.State)((Object)entry.getKey())).toString().toLowerCase(), ((Double)entry.getValue()).doubleValue());
        }
        json.writeEndObject();
        json.writeFieldName("garbage-collectors");
        json.writeStartObject();
        for (Map.Entry entry : this.vm.garbageCollectors().entrySet()) {
            json.writeFieldName((String)entry.getKey());
            json.writeStartObject();
            VirtualMachineMetrics.GarbageCollectorStats gc = (VirtualMachineMetrics.GarbageCollectorStats)entry.getValue();
            json.writeNumberField("runs", gc.getRuns());
            json.writeNumberField("time", gc.getTime(TimeUnit.MILLISECONDS));
            json.writeEndObject();
        }
        json.writeEndObject();
        json.writeEndObject();
    }

    public void writeRegularMetrics(JsonGenerator json, String classPrefix, boolean showFullSamples) throws IOException {
        for (Map.Entry entry : this.registry.groupedMetrics().entrySet()) {
            if (classPrefix != null && !((String)entry.getKey()).startsWith(classPrefix)) continue;
            json.writeFieldName((String)entry.getKey());
            json.writeStartObject();
            for (Map.Entry subEntry : ((SortedMap)entry.getValue()).entrySet()) {
                json.writeFieldName(((MetricName)subEntry.getKey()).getName());
                try {
                    ((Metric)subEntry.getValue()).processWith((MetricProcessor)this, (MetricName)subEntry.getKey(), (Object)new Context(json, showFullSamples));
                }
                catch (Exception e) {
                    LOGGER.warn("Error writing out {}", subEntry.getKey(), (Object)e);
                }
            }
            json.writeEndObject();
        }
    }

    public void processHistogram(MetricName name, Histogram histogram, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "histogram");
        json.writeNumberField("count", histogram.count());
        MetricsServlet.writeSummarizable((Summarizable)histogram, json);
        MetricsServlet.writeSampling((Sampling)histogram, json);
        if (context.showFullSamples) {
            json.writeObjectField("values", (Object)histogram.getSnapshot().getValues());
        }
        json.writeEndObject();
    }

    public void processCounter(MetricName name, Counter counter, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "counter");
        json.writeNumberField("count", counter.count());
        json.writeEndObject();
    }

    public void processGauge(MetricName name, Gauge<?> gauge, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "gauge");
        json.writeObjectField("value", MetricsServlet.evaluateGauge(gauge));
        json.writeEndObject();
    }

    public void processMeter(MetricName name, Metered meter, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "meter");
        json.writeStringField("event_type", meter.eventType());
        MetricsServlet.writeMeteredFields(meter, json);
        json.writeEndObject();
    }

    public void processTimer(MetricName name, Timer timer, Context context) throws Exception {
        JsonGenerator json = context.json;
        json.writeStartObject();
        json.writeStringField("type", "timer");
        json.writeFieldName("duration");
        json.writeStartObject();
        json.writeStringField("unit", timer.durationUnit().toString().toLowerCase());
        MetricsServlet.writeSummarizable((Summarizable)timer, json);
        MetricsServlet.writeSampling((Sampling)timer, json);
        if (context.showFullSamples) {
            json.writeObjectField("values", (Object)timer.getSnapshot().getValues());
        }
        json.writeEndObject();
        json.writeFieldName("rate");
        json.writeStartObject();
        MetricsServlet.writeMeteredFields((Metered)timer, json);
        json.writeEndObject();
        json.writeEndObject();
    }

    private static Object evaluateGauge(Gauge<?> gauge) {
        try {
            return gauge.value();
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error evaluating gauge", (Throwable)e);
            return "error reading gauge: " + e.getMessage();
        }
    }

    private static void writeSummarizable(Summarizable metric, JsonGenerator json) throws IOException {
        json.writeNumberField("min", metric.min());
        json.writeNumberField("max", metric.max());
        json.writeNumberField("mean", metric.mean());
        json.writeNumberField("std_dev", metric.stdDev());
    }

    private static void writeSampling(Sampling metric, JsonGenerator json) throws IOException {
        Snapshot snapshot = metric.getSnapshot();
        json.writeNumberField("median", snapshot.getMedian());
        json.writeNumberField("p75", snapshot.get75thPercentile());
        json.writeNumberField("p95", snapshot.get95thPercentile());
        json.writeNumberField("p98", snapshot.get98thPercentile());
        json.writeNumberField("p99", snapshot.get99thPercentile());
        json.writeNumberField("p999", snapshot.get999thPercentile());
    }

    private static void writeMeteredFields(Metered metered, JsonGenerator json) throws IOException {
        json.writeStringField("unit", metered.rateUnit().toString().toLowerCase());
        json.writeNumberField("count", metered.count());
        json.writeNumberField("mean", metered.meanRate());
        json.writeNumberField("m1", metered.oneMinuteRate());
        json.writeNumberField("m5", metered.fiveMinuteRate());
        json.writeNumberField("m15", metered.fifteenMinuteRate());
    }

    static final class Context {
        final boolean showFullSamples;
        final JsonGenerator json;

        Context(JsonGenerator json, boolean showFullSamples) {
            this.json = json;
            this.showFullSamples = showFullSamples;
        }
    }
}

