/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.ServiceInfo;

public class DefaultServiceInfo
implements ServiceInfo,
Serializable {
    private static final long serialVersionUID = 7975308744804800859L;
    protected String description;
    protected Set<String> keywords;
    protected URI publisher;
    protected URI schema;
    protected String title;
    private URI source;

    public DefaultServiceInfo() {
    }

    public DefaultServiceInfo(ServiceInfo copy) {
        this.description = copy.getDescription();
        this.keywords = new HashSet<String>();
        if (copy.getKeywords() != null) {
            this.keywords.addAll(copy.getKeywords());
        }
        this.publisher = copy.getPublisher();
        this.schema = copy.getSchema();
        this.title = copy.getTitle();
        this.source = copy.getSource();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Set<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    @Override
    public URI getPublisher() {
        return this.publisher;
    }

    public void setPublisher(URI publisher) {
        this.publisher = publisher;
    }

    @Override
    public URI getSchema() {
        return this.schema;
    }

    public void setSchema(URI schema) {
        this.schema = schema;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ServiceInfo ");
        if (this.source != null) {
            buf.append(this.source);
        }
        if (this.title != null) {
            buf.append("\n title=");
            buf.append(this.title);
        }
        if (this.publisher != null) {
            buf.append("\n publisher=");
            buf.append(this.publisher);
        }
        if (this.publisher != null) {
            buf.append("\n schema=");
            buf.append(this.schema);
        }
        if (this.keywords != null) {
            buf.append("\n keywords=");
            buf.append(this.keywords);
        }
        if (this.description != null) {
            buf.append("\n description=");
            buf.append(this.description);
        }
        return buf.toString();
    }
}

