/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui.treeview;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.dlib.gui.CustomLook;
import org.dlib.gui.treeview.IntCellRenderer;
import org.dlib.gui.treeview.PopupGenerator;
import org.dlib.gui.treeview.TreeViewDndHandler;
import org.dlib.gui.treeview.TreeViewNode;
import org.dlib.gui.treeview.TreeViewSelEvent;
import org.dlib.gui.treeview.TreeViewSelListener;

public class TreeView
extends JScrollPane
implements MouseListener,
MouseMotionListener,
TreeSelectionListener,
TreeModelListener,
TreeWillExpandListener {
    private boolean bEditable = true;
    private PopupGenerator popupGen;
    private TreeViewDndHandler dndHandler;
    private boolean bDnDDragging;
    private TreeViewNode currDnDNode;
    private TreeViewNode selDnDNode;
    private int currResp;
    private static Cursor defCursor = Cursor.getDefaultCursor();
    private EventListenerList listList = new EventListenerList();
    private IntCellRenderer intCellRend = new IntCellRenderer(this);
    JTree jTree;
    DefaultTreeModel defTreeMod;
    static /* synthetic */ Class class$org$dlib$gui$treeview$TreeViewSelListener;

    public TreeView() {
        this(true);
    }

    public TreeView(boolean bl) {
        TreeViewNode treeViewNode = new TreeViewNode();
        this.defTreeMod = new DefaultTreeModel(treeViewNode);
        this.defTreeMod.addTreeModelListener(this);
        this.jTree = new JTree(treeViewNode){

            public void paintComponent(Graphics graphics) {
                CustomLook.setup(graphics);
                super.paintComponent(graphics);
            }
        };
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeSelectionListener(this);
        this.jTree.addMouseListener(this);
        this.jTree.addMouseMotionListener(this);
        this.jTree.addTreeWillExpandListener(this);
        this.jTree.setShowsRootHandles(true);
        this.jTree.setRootVisible(false);
        this.jTree.setEditable(false);
        this.jTree.setModel(this.defTreeMod);
        this.jTree.putClientProperty("JTree.lineStyle", "Angled");
        this.jTree.setCellRenderer(this.intCellRend);
        this.jTree.setCellEditor(new DefaultTreeCellEditor(this.jTree, this.intCellRend));
        this.jTree.setToggleClickCount(0);
        this.jTree.setInvokesStopCellEditing(true);
        this.setViewportView(this.jTree);
        ToolTipManager.sharedInstance().registerComponent(this.jTree);
        this.setEditable(bl);
        InputMap inputMap = new InputMap();
        inputMap.setParent(this.jTree.getInputMap());
        this.jTree.setInputMap(0, inputMap);
        ActionMap actionMap = new ActionMap();
        actionMap.setParent(this.jTree.getActionMap());
        this.jTree.setActionMap(actionMap);
    }

    public void addKeyBinding(KeyStroke keyStroke, Action action) {
        this.jTree.getInputMap().put(keyStroke, action);
        this.jTree.getActionMap().put(action, action);
    }

    public void setRootNode(TreeViewNode treeViewNode) {
        TreeViewNode treeViewNode2 = this.getRootNode();
        if (treeViewNode2 != null) {
            treeViewNode2.setTree(null);
        }
        treeViewNode.setTree(this.jTree);
        this.defTreeMod.setRoot(treeViewNode);
    }

    public void setShowRootHandles(boolean bl) {
        this.jTree.setShowsRootHandles(bl);
    }

    public TreeViewNode getRootNode() {
        return (TreeViewNode)this.defTreeMod.getRoot();
    }

    public void setRootVisible(boolean bl) {
        this.jTree.setRootVisible(bl);
    }

    public TreeViewNode getSelectedNode() {
        return (TreeViewNode)this.jTree.getLastSelectedPathComponent();
    }

    public void clearSelection() {
        this.jTree.clearSelection();
    }

    public void addSelectionListener(TreeViewSelListener treeViewSelListener) {
        this.listList.add(class$org$dlib$gui$treeview$TreeViewSelListener == null ? (class$org$dlib$gui$treeview$TreeViewSelListener = TreeView.class$("org.dlib.gui.treeview.TreeViewSelListener")) : class$org$dlib$gui$treeview$TreeViewSelListener, treeViewSelListener);
    }

    public void removeSelectionListener(TreeViewSelListener treeViewSelListener) {
        this.listList.remove(class$org$dlib$gui$treeview$TreeViewSelListener == null ? (class$org$dlib$gui$treeview$TreeViewSelListener = TreeView.class$("org.dlib.gui.treeview.TreeViewSelListener")) : class$org$dlib$gui$treeview$TreeViewSelListener, treeViewSelListener);
    }

    public void fireNodeSelected(TreeViewNode treeViewNode, boolean bl) {
        Object[] objectArray = this.listList.getListenerList();
        TreeViewSelEvent treeViewSelEvent = new TreeViewSelEvent(this, treeViewNode, bl);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$dlib$gui$treeview$TreeViewSelListener == null ? TreeView.class$("org.dlib.gui.treeview.TreeViewSelListener") : class$org$dlib$gui$treeview$TreeViewSelListener)) continue;
            ((TreeViewSelListener)objectArray[i + 1]).nodeSelected(treeViewSelEvent);
        }
    }

    public void setPopupGen(PopupGenerator popupGenerator) {
        this.popupGen = popupGenerator;
    }

    public PopupGenerator getPopupGen() {
        return this.popupGen;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.intCellRend.setRenderer(treeCellRenderer);
    }

    public void updateTree() {
        this.defTreeMod.reload();
    }

    public void setEditable(boolean bl) {
        this.bEditable = bl;
    }

    public void setDndHandler(TreeViewDndHandler treeViewDndHandler) {
        this.dndHandler = treeViewDndHandler;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            TreePath treePath = this.jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreeViewNode treeViewNode = null;
            if (treePath != null) {
                treeViewNode = (TreeViewNode)treePath.getLastPathComponent();
                this.jTree.setSelectionPath(treePath);
            } else {
                this.jTree.clearSelection();
            }
            if (this.popupGen == null) {
                return;
            }
            JPopupMenu jPopupMenu = this.popupGen.generate(treeViewNode);
            if (jPopupMenu == null) {
                return;
            }
            if (jPopupMenu.getComponentCount() != 0) {
                jPopupMenu.show(this.jTree, mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            this.jTree.setEditable(false);
            this.selDnDNode = this.getSelectedNode();
            if (this.selDnDNode == null) {
                return;
            }
            if (mouseEvent.getClickCount() == 2 && this.bEditable && this.selDnDNode.isEditable()) {
                this.jTree.setEditable(true);
                this.jTree.startEditingAtPath(new TreePath(this.selDnDNode.getPath()));
            } else if (mouseEvent.getClickCount() == 2 && !this.bEditable) {
                this.fireNodeSelected(this.selDnDNode, true);
            } else {
                if (this.dndHandler == null) {
                    return;
                }
                this.bDnDDragging = true;
                this.currDnDNode = null;
                this.currResp = 0;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.bDnDDragging) {
            return;
        }
        this.bDnDDragging = false;
        this.jTree.setCursor(Cursor.getDefaultCursor());
        if (this.currDnDNode != null) {
            this.currDnDNode.setDnDSelection(false);
            this.currDnDNode.refresh();
            if (this.currResp != 0) {
                this.dndHandler.handleDrop(this.selDnDNode, this.currDnDNode);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.bDnDDragging) {
            return;
        }
        TreePath treePath = this.jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            TreeViewNode treeViewNode = (TreeViewNode)treePath.getLastPathComponent();
            if (treeViewNode == this.selDnDNode) {
                this.deselectDrop();
            } else {
                if (this.currDnDNode != null && this.currDnDNode != treeViewNode) {
                    this.currDnDNode.setDnDSelection(false);
                    this.currDnDNode.refresh();
                }
                this.currResp = this.dndHandler.acceptDrop(this.selDnDNode, treeViewNode);
                if (this.currResp == 0) {
                    this.jTree.setCursor(this.dndHandler.getNoDropCursor());
                } else {
                    this.jTree.setCursor(defCursor);
                }
                switch (this.currResp) {
                    case 0: {
                        this.intCellRend.setBorderType(0);
                        break;
                    }
                    case 2: {
                        this.intCellRend.setBorderType(1);
                        break;
                    }
                    case 3: {
                        this.intCellRend.setBorderType(2);
                        break;
                    }
                    case 1: {
                        this.intCellRend.setBorderType(3);
                    }
                }
                treeViewNode.setDnDSelection(true);
                treeViewNode.refresh();
                this.currDnDNode = treeViewNode;
            }
        } else {
            this.deselectDrop();
        }
    }

    private void deselectDrop() {
        this.jTree.setCursor(this.dndHandler.getNoDropCursor());
        if (this.currDnDNode != null) {
            this.currDnDNode.setDnDSelection(false);
            this.currDnDNode.refresh();
            this.currDnDNode = null;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeViewNode treeViewNode = (TreeViewNode)this.jTree.getLastSelectedPathComponent();
        this.fireNodeSelected(treeViewNode, false);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        TreeViewNode treeViewNode = (TreeViewNode)treeModelEvent.getTreePath().getLastPathComponent();
        int[] nArray = treeModelEvent.getChildIndices();
        if (nArray != null) {
            treeViewNode = treeViewNode.getChild(nArray[0]);
        }
        treeViewNode.textChanged();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreeViewNode treeViewNode = (TreeViewNode)treeExpansionEvent.getPath().getLastPathComponent();
        treeViewNode.nodeWillExpand(treeExpansionEvent);
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreeViewNode treeViewNode = (TreeViewNode)treeExpansionEvent.getPath().getLastPathComponent();
        treeViewNode.nodeWillCollapse(treeExpansionEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

