/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgis.Version;
import org.postgresql.Driver;

public class VersionPrinter {
    public static String[] GISVERSIONS = new String[]{"postgis_version", "postgis_proj_version", "postgis_scripts_installed", "postgis_lib_version", "postgis_scripts_released", "postgis_uses_stats", "postgis_geos_version", "postgis_scripts_build_date", "postgis_lib_build_date", "postgis_full_version"};
    public static boolean makeemptyline = false;

    public static void main(String[] args) {
        Driver d;
        Statement stat = null;
        VersionPrinter.printHeading("PostGIS jdbc client code");
        VersionPrinter.printVersionString("getFullVersion", Version.getFullVersion());
        VersionPrinter.printHeading("PGJDBC Driver");
        VersionPrinter.printVersionString("getVersion", Driver.getVersion());
        try {
            d = new Driver();
        }
        catch (Exception e) {
            System.err.println("Cannot create Driver instance: " + e.getMessage());
            System.exit(1);
            return;
        }
        VersionPrinter.printVersionString("getMajorVersion", d.getMajorVersion());
        VersionPrinter.printVersionString("getMinorVersion", d.getMinorVersion());
        if (args.length == 3) {
            Connection conn = null;
            try {
                conn = DriverManager.getConnection(args[0], args[1], args[2]);
                stat = conn.createStatement();
            }
            catch (SQLException e) {
                System.err.println("Connection to database failed, aborting.");
                System.err.println(e.getMessage());
                System.exit(1);
            }
        } else if (args.length != 0) {
            System.err.println("Usage: java examples/VersionPrinter dburl user pass");
            System.exit(1);
            return;
        }
        if (stat == null) {
            System.out.println("No online version available.");
        }
        VersionPrinter.printHeading("PostgreSQL Server");
        VersionPrinter.printVersionString("version", stat);
        VersionPrinter.printHeading("PostGIS Server");
        for (int i = 0; i < GISVERSIONS.length; ++i) {
            VersionPrinter.printVersionString(GISVERSIONS[i], stat);
        }
    }

    private static void printHeading(String heading) {
        if (makeemptyline) {
            System.out.println();
        }
        System.out.println("** " + heading + " **");
        makeemptyline = true;
    }

    public static void printVersionString(String function, int value) {
        VersionPrinter.printVersionString(function, Integer.toString(value));
    }

    public static void printVersionString(String function, String value) {
        System.out.println("\t" + function + ": " + value);
    }

    public static void printVersionString(String function, Statement stat) {
        VersionPrinter.printVersionString(function, VersionPrinter.getVersionString(function, stat));
    }

    public static String getVersionString(String function, Statement stat) {
        try {
            ResultSet rs = stat.executeQuery("SELECT " + function + "()");
            if (!rs.next()) {
                return "-- no result --";
            }
            String version = rs.getString(1);
            if (version == null) {
                return "-- null result --";
            }
            return version.trim();
        }
        catch (SQLException e) {
            return "-- unavailable -- ";
        }
    }
}

