/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.fao.geonet.Constants;
import org.jdom.Element;

public final class BLOB {
    private static final int BUF_SIZE = 8192;

    private BLOB() {
    }

    public static Element encode(int responseCode, byte[] blob, String contentType, String filename) {
        Element response = new Element("response");
        response.setAttribute("responseCode", responseCode + "");
        response.setAttribute("contentType", contentType);
        response.setAttribute("contentLength", blob.length + "");
        if (filename != null) {
            response.setAttribute("contentDisposition", "attachment;filename=" + filename);
        }
        String data = new String(new Base64().encode(blob), Charset.forName(Constants.ENCODING));
        response.setText(data);
        return response;
    }

    public static String getContentType(Element response) {
        return response.getAttributeValue("contentType");
    }

    public static String getContentLength(Element response) {
        return response.getAttributeValue("contentLength");
    }

    public static String getContentDisposition(Element response) {
        return response.getAttributeValue("contentDisposition");
    }

    public static int getResponseCode(Element response) {
        return Integer.parseInt(response.getAttributeValue("responseCode"));
    }

    public static void write(Element response, OutputStream output) throws IOException {
        String data = response.getText();
        byte[] blob = new Base64().decode(data.getBytes(Charset.forName(Constants.ENCODING)));
        ByteArrayInputStream input = new ByteArrayInputStream(blob);
        BLOB.copy(input, output);
    }

    private static void copy(InputStream in, OutputStream output) throws IOException {
        BufferedInputStream input = new BufferedInputStream(in);
        try {
            int nRead;
            byte[] buffer = new byte[8192];
            do {
                nRead = input.read(buffer, 0, 8192);
                output.write(buffer, 0, nRead);
            } while (nRead == 8192);
            input.close();
        }
        catch (IOException e) {
            input.close();
            throw e;
        }
    }
}

