/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.ModifierResolver;
import net.bytebuddy.dynamic.scaffold.BridgeMethodResolver;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodLookupEngine;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.RandomString;

public interface Implementation {
    public InstrumentedType prepare(InstrumentedType var1);

    public ByteCodeAppender appender(Target var1);

    public static class Simple
    implements Implementation {
        private final ByteCodeAppender byteCodeAppender;

        public Simple(ByteCodeAppender ... byteCodeAppender) {
            this.byteCodeAppender = new ByteCodeAppender.Compound(byteCodeAppender);
        }

        public Simple(StackManipulation ... stackManipulation) {
            this.byteCodeAppender = new ByteCodeAppender.Simple(stackManipulation);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Target implementationTarget) {
            return this.byteCodeAppender;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.byteCodeAppender.equals(((Simple)other).byteCodeAppender);
        }

        public int hashCode() {
            return this.byteCodeAppender.hashCode();
        }

        public String toString() {
            return "Implementation.Simple{byteCodeAppender=" + this.byteCodeAppender + '}';
        }
    }

    public static class Compound
    implements Implementation {
        private final Implementation[] implementation;

        public Compound(Implementation ... implementation) {
            this.implementation = implementation;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            for (Implementation implementation : this.implementation) {
                instrumentedType = implementation.prepare(instrumentedType);
            }
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Target implementationTarget) {
            ByteCodeAppender[] byteCodeAppender = new ByteCodeAppender[this.implementation.length];
            int index = 0;
            for (Implementation implementation : this.implementation) {
                byteCodeAppender[index++] = implementation.appender(implementationTarget);
            }
            return new ByteCodeAppender.Compound(byteCodeAppender);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.implementation, ((Compound)o).implementation);
        }

        public int hashCode() {
            return Arrays.hashCode(this.implementation);
        }

        public String toString() {
            return "Implementation.Compound{implementation=" + Arrays.toString(this.implementation) + '}';
        }
    }

    public static interface Context {
        public TypeDescription register(AuxiliaryType var1);

        public FieldDescription cache(StackManipulation var1, TypeDescription var2);

        public static class Default
        implements ExtractableView,
        AuxiliaryType.MethodAccessorFactory {
            public static final String ACCESSOR_METHOD_SUFFIX = "accessor";
            public static final String FIELD_CACHE_PREFIX = "cachedValue";
            private static final Object NO_DEFAULT_VALUE = null;
            private final TypeDescription instrumentedType;
            private final InstrumentedType.TypeInitializer typeInitializer;
            private final ClassFileVersion classFileVersion;
            private final AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy;
            private final Map<SpecialMethodInvocation, MethodDescription> registeredAccessorMethods;
            private final Map<FieldDescription, MethodDescription> registeredGetters;
            private final Map<FieldDescription, MethodDescription> registeredSetters;
            private final Map<MethodDescription, TypeWriter.MethodPool.Entry> accessorMethodEntries;
            private final Map<AuxiliaryType, DynamicType> auxiliaryTypes;
            private final Map<FieldCacheEntry, FieldDescription> registeredFieldCacheEntries;
            private final RandomString randomString;
            private boolean canRegisterFieldCache;

            public Default(TypeDescription instrumentedType, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, InstrumentedType.TypeInitializer typeInitializer, ClassFileVersion classFileVersion) {
                this.instrumentedType = instrumentedType;
                this.auxiliaryTypeNamingStrategy = auxiliaryTypeNamingStrategy;
                this.typeInitializer = typeInitializer;
                this.classFileVersion = classFileVersion;
                this.registeredAccessorMethods = new HashMap<SpecialMethodInvocation, MethodDescription>();
                this.registeredGetters = new HashMap<FieldDescription, MethodDescription>();
                this.registeredSetters = new HashMap<FieldDescription, MethodDescription>();
                this.accessorMethodEntries = new HashMap<MethodDescription, TypeWriter.MethodPool.Entry>();
                this.auxiliaryTypes = new HashMap<AuxiliaryType, DynamicType>();
                this.registeredFieldCacheEntries = new HashMap<FieldCacheEntry, FieldDescription>();
                this.randomString = new RandomString();
                this.canRegisterFieldCache = true;
            }

            @Override
            public MethodDescription registerAccessorFor(SpecialMethodInvocation specialMethodInvocation) {
                MethodDescription accessorMethod = this.registeredAccessorMethods.get(specialMethodInvocation);
                if (accessorMethod == null) {
                    String name = String.format("%s$%s$%s", specialMethodInvocation.getMethodDescription().getInternalName(), ACCESSOR_METHOD_SUFFIX, this.randomString.nextString());
                    accessorMethod = new MethodDescription.Latent(name, this.instrumentedType, specialMethodInvocation.getMethodDescription().getReturnType(), specialMethodInvocation.getMethodDescription().getParameters().asTypeList(), this.resolveModifier(specialMethodInvocation.getMethodDescription().isStatic()), specialMethodInvocation.getMethodDescription().getExceptionTypes());
                    this.registerAccessor(specialMethodInvocation, accessorMethod);
                }
                return accessorMethod;
            }

            private int resolveModifier(boolean isStatic) {
                return 0x1010 | (isStatic ? 8 : 0);
            }

            private void registerAccessor(SpecialMethodInvocation specialMethodInvocation, MethodDescription accessorMethod) {
                this.registeredAccessorMethods.put(specialMethodInvocation, accessorMethod);
                this.accessorMethodEntries.put(accessorMethod, new AccessorMethodDelegation(specialMethodInvocation));
            }

            @Override
            public MethodDescription registerGetterFor(FieldDescription fieldDescription) {
                MethodDescription accessorMethod = this.registeredGetters.get(fieldDescription);
                if (accessorMethod == null) {
                    String name = String.format("%s$%s$%s", fieldDescription.getName(), ACCESSOR_METHOD_SUFFIX, this.randomString.nextString());
                    accessorMethod = new MethodDescription.Latent(name, this.instrumentedType, fieldDescription.getFieldType(), Collections.emptyList(), this.resolveModifier(fieldDescription.isStatic()), Collections.emptyList());
                    this.registerGetter(fieldDescription, accessorMethod);
                }
                return accessorMethod;
            }

            private void registerGetter(FieldDescription fieldDescription, MethodDescription accessorMethod) {
                this.registeredGetters.put(fieldDescription, accessorMethod);
                this.accessorMethodEntries.put(accessorMethod, new FieldGetter(fieldDescription));
            }

            @Override
            public MethodDescription registerSetterFor(FieldDescription fieldDescription) {
                MethodDescription accessorMethod = this.registeredSetters.get(fieldDescription);
                if (accessorMethod == null) {
                    String name = String.format("%s$%s$%s", fieldDescription.getName(), ACCESSOR_METHOD_SUFFIX, this.randomString.nextString());
                    accessorMethod = new MethodDescription.Latent(name, this.instrumentedType, TypeDescription.VOID, Collections.singletonList(fieldDescription.getFieldType()), this.resolveModifier(fieldDescription.isStatic()), Collections.emptyList());
                    this.registerSetter(fieldDescription, accessorMethod);
                }
                return accessorMethod;
            }

            private void registerSetter(FieldDescription fieldDescription, MethodDescription accessorMethod) {
                this.registeredSetters.put(fieldDescription, accessorMethod);
                this.accessorMethodEntries.put(accessorMethod, new FieldSetter(fieldDescription));
            }

            @Override
            public TypeDescription register(AuxiliaryType auxiliaryType) {
                DynamicType dynamicType = this.auxiliaryTypes.get(auxiliaryType);
                if (dynamicType == null) {
                    dynamicType = auxiliaryType.make(this.auxiliaryTypeNamingStrategy.name(auxiliaryType, this.instrumentedType), this.classFileVersion, this);
                    this.auxiliaryTypes.put(auxiliaryType, dynamicType);
                }
                return dynamicType.getTypeDescription();
            }

            @Override
            public List<DynamicType> getRegisteredAuxiliaryTypes() {
                return new ArrayList<DynamicType>(this.auxiliaryTypes.values());
            }

            @Override
            public FieldDescription cache(StackManipulation fieldValue, TypeDescription fieldType) {
                FieldCacheEntry fieldCacheEntry = new FieldCacheEntry(fieldValue, fieldType);
                FieldDescription fieldCache = this.registeredFieldCacheEntries.get(fieldCacheEntry);
                if (fieldCache != null) {
                    return fieldCache;
                }
                this.validateFieldCacheAccessibility();
                fieldCache = new FieldDescription.Latent(String.format("%s$%s", FIELD_CACHE_PREFIX, this.randomString.nextString()), this.instrumentedType, fieldType, 4120);
                this.registeredFieldCacheEntries.put(fieldCacheEntry, fieldCache);
                return fieldCache;
            }

            private void validateFieldCacheAccessibility() {
                if (!this.canRegisterFieldCache) {
                    throw new IllegalStateException("A field cache cannot be registered during or after the creation of a type initializer - instead, the field cache should be registered in the method that requires the cached value");
                }
            }

            @Override
            public void drain(ClassVisitor classVisitor, TypeWriter.MethodPool methodPool, ExtractableView.InjectedCode injectedCode) {
                MethodDescription typeInitializerMethod;
                TypeWriter.MethodPool.Entry initializerEntry;
                this.canRegisterFieldCache = false;
                InstrumentedType.TypeInitializer typeInitializer = this.typeInitializer;
                for (Map.Entry<FieldCacheEntry, FieldDescription> entry : this.registeredFieldCacheEntries.entrySet()) {
                    classVisitor.visitField(entry.getValue().getModifiers(), entry.getValue().getInternalName(), entry.getValue().getDescriptor(), entry.getValue().getGenericSignature(), NO_DEFAULT_VALUE).visitEnd();
                    typeInitializer = typeInitializer.expandWith(new ByteCodeAppender.Simple(entry.getKey().storeIn(entry.getValue())));
                }
                if (injectedCode.isDefined()) {
                    typeInitializer = typeInitializer.expandWith(injectedCode.getByteCodeAppender());
                }
                if ((initializerEntry = methodPool.target(typeInitializerMethod = MethodDescription.Latent.typeInitializerOf(this.instrumentedType))).getSort().isImplemented() && typeInitializer.isDefined()) {
                    initializerEntry = initializerEntry.prepend(typeInitializer);
                } else if (typeInitializer.isDefined()) {
                    initializerEntry = new TypeWriter.MethodPool.Entry.ForImplementation(typeInitializer.withReturn());
                }
                initializerEntry.apply(classVisitor, this, typeInitializerMethod);
                for (Map.Entry<MethodDescription, TypeWriter.MethodPool.Entry> entry : this.accessorMethodEntries.entrySet()) {
                    entry.getValue().apply(classVisitor, this, entry.getKey());
                }
            }

            public String toString() {
                return "Implementation.Context.Default{instrumentedType=" + this.instrumentedType + ", typeInitializer=" + this.typeInitializer + ", classFileVersion=" + this.classFileVersion + ", auxiliaryTypeNamingStrategy=" + this.auxiliaryTypeNamingStrategy + ", registeredAccessorMethods=" + this.registeredAccessorMethods + ", registeredGetters=" + this.registeredGetters + ", registeredSetters=" + this.registeredSetters + ", accessorMethodEntries=" + this.accessorMethodEntries + ", auxiliaryTypes=" + this.auxiliaryTypes + ", registeredFieldCacheEntries=" + this.registeredFieldCacheEntries + ", randomString=" + this.randomString + ", canRegisterFieldCache=" + this.canRegisterFieldCache + '}';
            }

            protected static class FieldSetter
            extends AbstractDelegationEntry {
                private final FieldDescription fieldDescription;

                protected FieldSetter(FieldDescription fieldDescription) {
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context implementationContext, MethodDescription instrumentedMethod) {
                    StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThisReferenceAndArguments(instrumentedMethod), FieldAccess.forField(this.fieldDescription).putter(), MethodReturn.VOID).apply(methodVisitor, implementationContext);
                    return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldDescription.equals(((FieldSetter)other).fieldDescription);
                }

                public int hashCode() {
                    return this.fieldDescription.hashCode();
                }

                public String toString() {
                    return "Implementation.Context.Default.FieldSetter{fieldDescription=" + this.fieldDescription + '}';
                }
            }

            protected static class FieldGetter
            extends AbstractDelegationEntry {
                private final FieldDescription fieldDescription;

                protected FieldGetter(FieldDescription fieldDescription) {
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context implementationContext, MethodDescription instrumentedMethod) {
                    StackManipulation.Size stackSize = new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.LegalTrivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField(this.fieldDescription).getter(), MethodReturn.returning(this.fieldDescription.getFieldType())).apply(methodVisitor, implementationContext);
                    return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldDescription.equals(((FieldGetter)other).fieldDescription);
                }

                public int hashCode() {
                    return this.fieldDescription.hashCode();
                }

                public String toString() {
                    return "Implementation.Context.Default.FieldGetter{fieldDescription=" + this.fieldDescription + '}';
                }
            }

            protected static class AccessorMethodDelegation
            extends AbstractDelegationEntry {
                private final StackManipulation accessorMethodInvocation;

                protected AccessorMethodDelegation(StackManipulation accessorMethodInvocation) {
                    this.accessorMethodInvocation = accessorMethodInvocation;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context implementationContext, MethodDescription instrumentedMethod) {
                    StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThisReferenceAndArguments(instrumentedMethod), this.accessorMethodInvocation, MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, implementationContext);
                    return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.accessorMethodInvocation.equals(((AccessorMethodDelegation)other).accessorMethodInvocation);
                }

                public int hashCode() {
                    return this.accessorMethodInvocation.hashCode();
                }

                public String toString() {
                    return "Implementation.Context.Default.AccessorMethodDelegation{accessorMethodInvocation=" + this.accessorMethodInvocation + '}';
                }
            }

            protected static abstract class AbstractDelegationEntry
            extends TypeWriter.MethodPool.Entry.AbstractDefiningEntry
            implements ByteCodeAppender {
                protected AbstractDelegationEntry() {
                }

                @Override
                public TypeWriter.MethodPool.Entry.Sort getSort() {
                    return TypeWriter.MethodPool.Entry.Sort.IMPLEMENT;
                }

                @Override
                public ModifierResolver getModifierResolver() {
                    return ModifierResolver.Simple.INSTANCE;
                }

                @Override
                public void applyHead(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                }

                @Override
                public void applyBody(MethodVisitor methodVisitor, Context implementationContext, MethodDescription methodDescription) {
                    methodVisitor.visitCode();
                    ByteCodeAppender.Size size = this.apply(methodVisitor, implementationContext, methodDescription);
                    methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                }

                @Override
                public TypeWriter.MethodPool.Entry prepend(ByteCodeAppender byteCodeAppender) {
                    throw new UnsupportedOperationException("Cannot prepend code to a delegator");
                }
            }

            protected static class FieldCacheEntry
            implements StackManipulation {
                private final StackManipulation fieldValue;
                private final TypeDescription fieldType;

                protected FieldCacheEntry(StackManipulation fieldValue, TypeDescription fieldType) {
                    this.fieldValue = fieldValue;
                    this.fieldType = fieldType;
                }

                public StackManipulation storeIn(FieldDescription fieldDescription) {
                    return new StackManipulation.Compound(this, FieldAccess.forField(fieldDescription).putter());
                }

                public TypeDescription getFieldType() {
                    return this.fieldType;
                }

                @Override
                public boolean isValid() {
                    return this.fieldValue.isValid();
                }

                @Override
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Context implementationContext) {
                    return this.fieldValue.apply(methodVisitor, implementationContext);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldType.equals(((FieldCacheEntry)other).fieldType) && this.fieldValue.equals(((FieldCacheEntry)other).fieldValue);
                }

                public int hashCode() {
                    return 31 * this.fieldValue.hashCode() + this.fieldType.hashCode();
                }

                public String toString() {
                    return "Implementation.Context.Default.FieldCacheEntry{fieldValue=" + this.fieldValue + ", fieldType=" + this.fieldType + '}';
                }
            }
        }

        public static interface ExtractableView
        extends Context {
            public static final int FIELD_CACHE_MODIFIER = 4120;

            public List<DynamicType> getRegisteredAuxiliaryTypes();

            public void drain(ClassVisitor var1, TypeWriter.MethodPool var2, InjectedCode var3);

            public static interface InjectedCode {
                public ByteCodeAppender getByteCodeAppender();

                public boolean isDefined();

                public static enum None implements InjectedCode
                {
                    INSTANCE;


                    @Override
                    public ByteCodeAppender getByteCodeAppender() {
                        throw new IllegalStateException();
                    }

                    @Override
                    public boolean isDefined() {
                        return false;
                    }

                    public String toString() {
                        return "Implementation.Context.ExtractableView.InjectedCode.None." + this.name();
                    }
                }
            }
        }
    }

    public static interface Target {
        public TypeDescription getTypeDescription();

        public TypeDescription getOriginType();

        public SpecialMethodInvocation invokeSuper(MethodDescription var1, MethodLookup var2);

        public SpecialMethodInvocation invokeDefault(TypeDescription var1, String var2);

        public static abstract class AbstractBase
        implements Target {
            protected final TypeDescription typeDescription;
            protected final Map<String, MethodDescription> invokableMethods;
            protected final Map<TypeDescription, Map<String, MethodDescription>> defaultMethods;
            protected final BridgeMethodResolver bridgeMethodResolver;

            protected AbstractBase(MethodLookupEngine.Finding finding, BridgeMethodResolver.Factory bridgeMethodResolverFactory) {
                this.bridgeMethodResolver = bridgeMethodResolverFactory.make(finding.getInvokableMethods());
                this.typeDescription = finding.getTypeDescription();
                this.invokableMethods = new HashMap<String, MethodDescription>(finding.getInvokableMethods().size());
                for (MethodDescription methodDescription : finding.getInvokableMethods()) {
                    this.invokableMethods.put(methodDescription.getUniqueSignature(), methodDescription);
                }
                this.defaultMethods = new HashMap<TypeDescription, Map<String, MethodDescription>>(finding.getInvokableDefaultMethods().size());
                for (Map.Entry entry : finding.getInvokableDefaultMethods().entrySet()) {
                    HashMap<String, MethodDescription> defaultMethods = new HashMap<String, MethodDescription>(((Set)entry.getValue()).size());
                    for (MethodDescription methodDescription : (Set)entry.getValue()) {
                        defaultMethods.put(methodDescription.getUniqueSignature(), methodDescription);
                    }
                    this.defaultMethods.put((TypeDescription)entry.getKey(), (Map<String, MethodDescription>)defaultMethods);
                }
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            @Override
            public SpecialMethodInvocation invokeSuper(MethodDescription methodDescription, MethodLookup methodLookup) {
                return this.invokeSuper(methodLookup.resolve(methodDescription, this.invokableMethods, this.bridgeMethodResolver));
            }

            protected abstract SpecialMethodInvocation invokeSuper(MethodDescription var1);

            @Override
            public SpecialMethodInvocation invokeDefault(TypeDescription targetType, String uniqueMethodSignature) {
                MethodDescription defaultMethod;
                Map<String, MethodDescription> defaultMethods = this.defaultMethods.get(targetType);
                if (defaultMethods != null && (defaultMethod = defaultMethods.get(uniqueMethodSignature)) != null) {
                    return SpecialMethodInvocation.Simple.of(defaultMethod, targetType);
                }
                return SpecialMethodInvocation.Illegal.INSTANCE;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                AbstractBase that = (AbstractBase)other;
                return this.bridgeMethodResolver.equals(that.bridgeMethodResolver) && this.defaultMethods.equals(that.defaultMethods) && this.typeDescription.equals(that.typeDescription);
            }

            public int hashCode() {
                int result = this.typeDescription.hashCode();
                result = 31 * result + this.defaultMethods.hashCode();
                result = 31 * result + this.bridgeMethodResolver.hashCode();
                return result;
            }
        }

        public static interface Factory {
            public Target make(MethodLookupEngine.Finding var1, List<? extends MethodDescription> var2);
        }

        public static interface MethodLookup {
            public MethodDescription resolve(MethodDescription var1, Map<String, MethodDescription> var2, BridgeMethodResolver var3);

            public static enum Default implements MethodLookup
            {
                EXACT{

                    @Override
                    public MethodDescription resolve(MethodDescription methodDescription, Map<String, MethodDescription> invokableMethods, BridgeMethodResolver bridgeMethodResolver) {
                        return methodDescription;
                    }
                }
                ,
                MOST_SPECIFIC{

                    @Override
                    public MethodDescription resolve(MethodDescription methodDescription, Map<String, MethodDescription> invokableMethods, BridgeMethodResolver bridgeMethodResolver) {
                        return bridgeMethodResolver.resolve(invokableMethods.get(methodDescription.getUniqueSignature()));
                    }
                };


                public String toString() {
                    return "Implementation.Target.MethodLookup.Default." + this.name();
                }
            }
        }
    }

    public static interface SpecialMethodInvocation
    extends StackManipulation {
        public MethodDescription getMethodDescription();

        public TypeDescription getTypeDescription();

        public static class Simple
        implements SpecialMethodInvocation {
            private final MethodDescription methodDescription;
            private final TypeDescription typeDescription;
            private final StackManipulation stackManipulation;

            protected Simple(MethodDescription methodDescription, TypeDescription typeDescription, StackManipulation stackManipulation) {
                this.methodDescription = methodDescription;
                this.typeDescription = typeDescription;
                this.stackManipulation = stackManipulation;
            }

            public static SpecialMethodInvocation of(MethodDescription methodDescription, TypeDescription typeDescription) {
                StackManipulation stackManipulation = MethodInvocation.invoke(methodDescription).special(typeDescription);
                return stackManipulation.isValid() && !methodDescription.isAbstract() ? new Simple(methodDescription, typeDescription, stackManipulation) : Illegal.INSTANCE;
            }

            @Override
            public MethodDescription getMethodDescription() {
                return this.methodDescription;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            @Override
            public boolean isValid() {
                return this.stackManipulation.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Context implementationContext) {
                return this.stackManipulation.apply(methodVisitor, implementationContext);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SpecialMethodInvocation)) {
                    return false;
                }
                SpecialMethodInvocation specialMethodInvocation = (SpecialMethodInvocation)other;
                return this.isValid() == specialMethodInvocation.isValid() && this.typeDescription.equals(specialMethodInvocation.getTypeDescription()) && this.methodDescription.getInternalName().equals(specialMethodInvocation.getMethodDescription().getInternalName()) && this.methodDescription.getParameters().asTypeList().equals(specialMethodInvocation.getMethodDescription().getParameters().asTypeList()) && this.methodDescription.getReturnType().equals(specialMethodInvocation.getMethodDescription().getReturnType());
            }

            public int hashCode() {
                int result = this.methodDescription.getInternalName().hashCode();
                result = 31 * result + this.methodDescription.getParameters().asTypeList().hashCode();
                result = 31 * result + this.methodDescription.getReturnType().hashCode();
                result = 31 * result + this.typeDescription.hashCode();
                return result;
            }

            public String toString() {
                return "Instrumentation.SpecialMethodInvocation.Simple{typeDescription=" + this.typeDescription + ", methodDescription=" + this.methodDescription + '}';
            }
        }

        public static enum Illegal implements SpecialMethodInvocation
        {
            INSTANCE;


            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Context implementationContext) {
                throw new IllegalStateException("Cannot implement an undefined method");
            }

            @Override
            public MethodDescription getMethodDescription() {
                throw new IllegalStateException("An illegal special method invocation must not be applied");
            }

            @Override
            public TypeDescription getTypeDescription() {
                throw new IllegalStateException("An illegal special method invocation must not be applied");
            }

            public String toString() {
                return "Implementation.SpecialMethodInvocation.Illegal." + this.name();
            }
        }
    }
}

