/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.impl;

import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.ServiceDirectory.CollectionDescriptionDBO;
import org.jzkit.ServiceDirectory.CollectionInfoTypeDBO;
import org.jzkit.ServiceDirectory.SearchServiceDescriptionDBO;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.search.DeduplicationModel;
import org.jzkit.search.LandscapeSpecification;
import org.jzkit.search.SearchSession;
import org.jzkit.search.SortModel;
import org.jzkit.search.landscape.InfoTypeSpecification;
import org.jzkit.search.landscape.MixedSpecification;
import org.jzkit.search.landscape.SimpleLandscapeSpecification;
import org.jzkit.search.provider.iface.IRQuery;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.provider.iface.Searchable;
import org.jzkit.search.util.Profile.ProfileService;
import org.jzkit.search.util.Profile.ProfileServiceException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.search.util.RecordBuilder.RecordBuilderService;
import org.jzkit.search.util.RecordConversion.FragmentTransformerService;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.IRResultSet;
import org.jzkit.search.util.ResultSet.SimpleAggregatingResultSet;
import org.jzkit.search.util.ResultSet.TransformingIRResultSet;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SearchSessionImpl
implements SearchSession,
ApplicationContextAware {
    private static String UNKNOWN = "UNKNOWN";
    private String session_type = UNKNOWN;
    private String principal = null;
    private String session_id;
    private static Log log = LogFactory.getLog(SearchSessionImpl.class);
    private Map all_active_searchable_objects = new HashMap();
    private static ProfileService profile_service = null;
    private FragmentTransformerService fts;
    private RecordBuilderService rbs = null;
    private ApplicationContext ctx;
    private static int inst_count = 0;

    private SearchSessionImpl() {
        this.session_id = new VMID().toString();
        log.info((Object)("new SearchSessionImpl count=" + ++inst_count + ", hc=" + this.hashCode() + ", id=" + this.session_id));
    }

    protected void finalize() {
        log.info((Object)("finalize SearchSessionImpl(" + --inst_count + ")"));
    }

    protected SearchSessionImpl(ProfileService profile_service, FragmentTransformerService fts, RecordBuilderService rbs) throws SearchException {
        this();
        SearchSessionImpl.profile_service = profile_service;
        this.fts = fts;
        this.rbs = rbs;
    }

    public void setType(String session_type) {
        this.session_type = session_type;
    }

    public String getType() {
        return this.session_type;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setSessionId(String session_id) {
        this.session_id = session_id;
    }

    public String getSessionId() {
        return this.session_id;
    }

    public String toString() {
        return "SearchService. id:" + this.session_id + " (" + this.session_type + ")";
    }

    public void close() {
        log.info((Object)"close. Releasing all session resources");
        for (Searchable s : this.all_active_searchable_objects.values()) {
            log.debug((Object)"Calling close on searchable");
            s.close();
            log.debug((Object)"Done");
        }
        this.all_active_searchable_objects.clear();
    }

    public TransformingIRResultSet search(LandscapeSpecification landscape, QueryModel model, DeduplicationModel deduplication_model, SortModel sort_model, RecordFormatSpecification rfs) throws SearchException {
        log.info((Object)"SearchSessionImpl::search");
        SimpleAggregatingResultSet result = null;
        Configuration jzkit_conf = (Configuration)this.ctx.getBean("JZKitConfig");
        log.info((Object)("search " + landscape.getClass().getName() + "," + model.getClass().getName()));
        Collection collection_ids = null;
        try {
            SimpleAggregatingResultSet internal_result_set;
            collection_ids = this.evaluateLandscape(landscape, jzkit_conf);
            if (collection_ids == null && collection_ids.size() == 0) {
                throw new SearchException("Landscape Specification does not identify any collections");
            }
            result = internal_result_set = new SimpleAggregatingResultSet(this.fts, this.rbs, rfs);
            log.info((Object)("plan: " + model + " collections:" + collection_ids));
            if (collection_ids == null || collection_ids.size() == 0 || model == null) {
                throw new SearchException("Invalid parameters for search - No collections or no query model " + landscape);
            }
            HashMap<String, IRQuery> queries_by_repository = new HashMap<String, IRQuery>();
            for (String collection_dn : collection_ids) {
                log.debug((Object)("Looking up collection " + collection_dn));
                CollectionDescriptionDBO ci = jzkit_conf.lookupCollectionDescription(collection_dn);
                if (ci != null) {
                    String search_service = null;
                    String profile = null;
                    String service_id = null;
                    SearchServiceDescriptionDBO ssd = ci.getSearchServiceDescription();
                    if (ssd == null) {
                        throw new RuntimeException("No SearchServiceDescription available for collection " + collection_dn);
                    }
                    search_service = ssd.getCode();
                    profile = ci.getProfile();
                    service_id = search_service + ":" + profile;
                    if (search_service != null) {
                        log.debug((Object)("Lookup or Create searchable for " + service_id));
                        Searchable s = (Searchable)this.all_active_searchable_objects.get(service_id);
                        if (s == null) {
                            try {
                                log.debug((Object)"new searchable required");
                                s = ssd.newSearchable();
                                s.setApplicationContext(this.ctx);
                                this.all_active_searchable_objects.put(service_id, s);
                            }
                            catch (SearchException se) {
                                se.printStackTrace();
                            }
                        }
                        IRQuery subq = (IRQuery)queries_by_repository.get(service_id);
                        try {
                            if (subq == null) {
                                String profile_name = service_id.substring(service_id.lastIndexOf(58) + 1, service_id.length());
                                QueryModel adapted_query_model = null;
                                if (profile_name != null && !profile_name.equals("null") && profile_name.length() > 0) {
                                    log.debug((Object)("Processing profile " + profile_name));
                                    adapted_query_model = profile_service.makeConformant(model, ssd.getValidAttrs(), ssd.getServiceSpecificTranslations(), profile_name);
                                    log.debug((Object)("Adapted query : " + adapted_query_model));
                                } else {
                                    log.debug((Object)"Not adapting query");
                                    adapted_query_model = model;
                                }
                                log.info((Object)("Query for repository " + service_id + " will be " + adapted_query_model));
                                subq = new IRQuery();
                                subq.query = adapted_query_model;
                                queries_by_repository.put(service_id, subq);
                            }
                        }
                        catch (ProfileServiceException pse) {
                            log.warn((Object)"Profile Service Exception", (Throwable)pse);
                            throw new SearchException(pse.getMessage(), (Throwable)pse, pse.getErrorCode());
                        }
                        log.debug((Object)("Adding " + ci.getLocalId() + " to collection names to search at " + service_id));
                        subq.collections.add(ci.getLocalId());
                        continue;
                    }
                    log.error((Object)("Unable to lookup repository for collection " + collection_dn + "... Skipping..."));
                    throw new SearchException("Internal Error " + collection_dn, 1);
                }
                log.error((Object)("Unable to locate collection information for name " + collection_dn + "... skipping..."));
                throw new SearchException("Unknown Collection " + collection_dn, 2);
            }
            log.debug((Object)("HSS Task contains " + queries_by_repository.size() + " child tasks"));
            for (String repos : queries_by_repository.keySet()) {
                IRQuery query_to_send_to_this_repository = (IRQuery)queries_by_repository.get(repos);
                Searchable s = (Searchable)this.all_active_searchable_objects.get(repos);
                IRResultSet subtask = s.evaluate(query_to_send_to_this_repository, null, null);
                subtask.setResultSetName(repos);
                internal_result_set.addSource(subtask);
            }
        }
        catch (ConfigurationException ce) {
            throw new SearchException(ce.toString());
        }
        finally {
            log.info((Object)"Removed call to jzkit_conf.close()");
        }
        return result;
    }

    private Collection evaluateLandscape(LandscapeSpecification landscape, Configuration jzkit_conf) throws ConfigurationException {
        log.info((Object)("processing landscape: " + landscape.getClass().getName()));
        Collection result = this.processEvaluateLandscape(landscape, jzkit_conf);
        log.debug((Object)("Result of evaluateLandscape = " + result));
        return result;
    }

    private Collection processEvaluateLandscape(LandscapeSpecification landscape, Configuration jzkit_conf) throws ConfigurationException {
        ArrayList<String> result;
        block3: {
            block4: {
                block2: {
                    result = null;
                    if (!(landscape instanceof SimpleLandscapeSpecification)) break block2;
                    result = ((SimpleLandscapeSpecification)landscape).toCollectionList();
                    break block3;
                }
                if (!(landscape instanceof InfoTypeSpecification)) break block4;
                String namespace = ((InfoTypeSpecification)landscape).getNamespace();
                String code = ((InfoTypeSpecification)landscape).getCode();
                log.debug((Object)("Looking for collections who's where the namespace (" + namespace + ") matches " + code));
                CollectionInfoTypeDBO it = jzkit_conf.lookupOrCreateCollectionInfoType(namespace, code);
                result = new ArrayList();
                for (CollectionDescriptionDBO c : it.getCollections()) {
                    result.add(c.getCode());
                }
                break block3;
            }
            if (!(landscape instanceof MixedSpecification)) break block3;
            MixedSpecification ms = (MixedSpecification)landscape;
            result = new ArrayList<String>();
            for (LandscapeSpecification component : ms.getSpecList()) {
                Collection c2 = this.evaluateLandscape(component, jzkit_conf);
                result.addAll(c2);
            }
        }
        return result;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }
}

