/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.ServiceDirectory;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;
import org.jzkit.ServiceDirectory.AttributeSetDBO;
import org.jzkit.ServiceDirectory.CollectionDescriptionDBO;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.provider.iface.Searchable;
import org.jzkit.search.provider.iface.ServiceUserInformation;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="JZ_SEARCH_SERVICE_DESCRIPTION")
public class SearchServiceDescriptionDBO {
    private Long id;
    private String code;
    private Map preferences = new HashMap();
    private Map record_syntax_archetypes = new HashMap();
    private String service_name;
    private String service_short_name;
    private String class_name;
    private Set collection_info = new HashSet();
    private Map<String, AttributeSetDBO> valid_attributes = new HashMap<String, AttributeSetDBO>();
    private Map<String, AttrValue> service_specific_translations = new HashMap<String, AttrValue>();
    private ApplicationContext ctx;
    protected transient Log log = LogFactory.getLog(SearchServiceDescriptionDBO.class);

    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="CODE", length=50)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="JZ_SSD_PROPS", joinColumns={@JoinColumn(name="SEARCH_SERVICE_ID")})
    @MapKey(columns={@Column(name="PROP_NAME", length=128)})
    @Column(name="PROP_VALUE", length=128)
    public Map<String, String> getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Map<String, String> preferences) {
        this.preferences = preferences;
    }

    public void setPreference(String name, Object value) {
        this.preferences.put(name, value);
    }

    public Object getPreference(String name, Object default_value) {
        Object result = this.preferences.get(name);
        if (result == null) {
            return default_value;
        }
        return result;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="JZ_SSD_RECORD_ARCHETYPES", joinColumns={@JoinColumn(name="SEARCH_SERVICE_ID")})
    @MapKey(columns={@Column(name="ARCHETYPE", length=64)})
    @Column(name="SPEC", length=64)
    public Map<String, String> getRecordArchetypes() {
        return this.record_syntax_archetypes;
    }

    public void setRecordArchetypes(Map<String, String> record_syntax_archetypes) {
        this.record_syntax_archetypes = record_syntax_archetypes;
    }

    public void setRecordArchetype(String name, Object value) {
        this.record_syntax_archetypes.put(name, value);
    }

    public Object getRecordArchetype(String name, Object default_value) {
        Object result = this.record_syntax_archetypes.get(name);
        if (result == null) {
            return default_value;
        }
        return result;
    }

    @Column(name="SERVICE_NAME", length=40)
    public String getServiceName() {
        return this.service_name;
    }

    public void setServiceName(String service_name) {
        this.service_name = service_name;
    }

    @Column(name="SERVICE_SHORT_NAME", length=40)
    public String getServiceShortName() {
        return this.service_short_name;
    }

    public void setServiceShortName(String service_short_name) {
        this.service_short_name = service_short_name;
    }

    @Column(name="CLASS_NAME", length=256)
    public String getClassName() {
        return this.class_name;
    }

    public void setClassName(String class_name) {
        this.class_name = class_name;
    }

    @OneToMany(mappedBy="searchServiceDescription")
    public Set<CollectionDescriptionDBO> getCollections() {
        return this.collection_info;
    }

    public void setCollections(Set<CollectionDescriptionDBO> collection_info) {
        this.collection_info = collection_info;
    }

    public void addCollection(CollectionDescriptionDBO coll) {
        this.log.debug((Object)("add collection " + coll.getCode()));
        this.collection_info.add(coll);
    }

    public void addCollection(String code, String collection_name, String local_id, String profile) {
        this.addCollection(new CollectionDescriptionDBO(code, collection_name, local_id, profile));
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.DELETE_ORPHAN})
    @JoinTable(name="JZ_SSD_VALID_ATTR_SET", joinColumns={@JoinColumn(name="DESCRIPTOR_ID")})
    public Map<String, AttributeSetDBO> getValidAttrs() {
        return this.valid_attributes;
    }

    public void setValidAttrs(Map<String, AttributeSetDBO> valid_attributes) {
        this.valid_attributes = valid_attributes;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="JZ_SSD_TRANS", joinColumns={@JoinColumn(name="DESCRIPTOR_ID")})
    @MapKey(columns={@Column(name="FROM_ATTR_STR", length=128)})
    public Map<String, AttrValue> getServiceSpecificTranslations() {
        return this.service_specific_translations;
    }

    public void setServiceSpecificTranslations(Map<String, AttrValue> service_specific_translations) {
        this.service_specific_translations = service_specific_translations;
    }

    public void registerValidIndex(String type, String namespace, String index_name) {
        this.log.debug((Object)("registerValidIndex " + type + ", " + namespace + ":" + index_name));
        AttributeSetDBO attr_set = this.valid_attributes.get(type);
        if (attr_set == null) {
            attr_set = new AttributeSetDBO();
            this.valid_attributes.put(type, attr_set);
        }
        attr_set.getAttrs().add(new AttrValue(namespace, index_name));
    }

    public void registerTranslation(String from, String target_namespace, String target_index_name) {
        this.log.debug((Object)("registerTranslation " + from + " -> " + target_namespace + ":" + target_index_name));
        this.service_specific_translations.put(from, new AttrValue(target_namespace, target_index_name));
    }

    public String toString() {
        return this.code + " - " + this.service_name;
    }

    public synchronized Searchable getInstance(ServiceUserInformation user_info) throws SearchException {
        Searchable result = null;
        try {
            Class<?> searchable_class = Class.forName(this.class_name);
            result = (Searchable)searchable_class.newInstance();
            for (String property_name : this.preferences.keySet()) {
                Object property_value = this.preferences.get(property_name);
                BeanUtils.setProperty((Object)result, (String)property_name, property_value);
            }
            result.setRecordArchetypes(this.record_syntax_archetypes);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SearchException("Unable to locate searchable class: " + this.class_name, (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new SearchException("Probem creating new SearchServiceFactory - " + this.class_name + " ie", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new SearchException("Probem creating new SearchServiceFactory", (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new SearchException("Probem creating new SearchServiceFactory", (Throwable)ite);
        }
        return result;
    }

    public Searchable newSearchable(ServiceUserInformation user_info) throws SearchException {
        return this.getInstance(user_info);
    }

    public Searchable newSearchable() throws SearchException {
        return this.getInstance(null);
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }
}

