/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.LongCollection;
import bak.pcj.LongIterator;
import bak.pcj.set.AbstractLongSet;
import bak.pcj.set.LongRange;
import bak.pcj.set.LongSortedSet;
import bak.pcj.util.Exceptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;

public class LongRangeSet
extends AbstractLongSet
implements LongSortedSet,
Cloneable,
Serializable {
    private ArrayList ranges = new ArrayList();
    private int size = 0;

    public LongRangeSet() {
    }

    public LongRangeSet(long[] a) {
        this();
        this.addAll(a);
    }

    public LongRangeSet(LongCollection c) {
        this();
        this.addAll(c);
    }

    private LongRange range(int index) {
        return (LongRange)this.ranges.get(index);
    }

    private LongRange getRangeOf(long v) {
        int index = this.getRangeIndexOf(v);
        return index >= 0 ? this.range(index) : null;
    }

    private int getRangeIndexOf(long v) {
        if (this.size == 0) {
            return -1;
        }
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            LongRange r = (LongRange)this.ranges.get(mid);
            if (r.contains(v)) {
                return mid;
            }
            if (v < r.first()) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -(lo + 1);
    }

    private int insertRange(LongRange range) {
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            LongRange r = this.range(mid);
            int compare = range.compareTo(r);
            if (compare == 0) {
                return -1;
            }
            if (compare < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        this.ranges.add(lo, range);
        return lo;
    }

    private void normalize(int index) {
        while (index < this.ranges.size() - 1) {
            LongRange r2;
            LongRange r1 = this.range(index);
            LongRange r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 == null) break;
            this.ranges.set(index, r3);
            this.ranges.remove(index + 1);
            this.size -= r1.intersectionLength(r2);
        }
    }

    private void normalize() {
        LongRange r3;
        int index = 0;
        this.size = 0;
        while (index < this.ranges.size() - 1) {
            LongRange r2;
            LongRange r1 = this.range(index);
            r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 != null) {
                this.ranges.set(index, r3);
                this.ranges.remove(index + 1);
                continue;
            }
            this.size += r1.length();
            ++index;
        }
        r3 = this.range(this.ranges.size() - 1);
        this.size += r3.length();
    }

    public boolean add(long v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return false;
        }
        int insertionIndex = -index - 1;
        this.ranges.add(insertionIndex, new LongRange(v, v));
        if (insertionIndex > 0) {
            --insertionIndex;
        }
        ++this.size;
        this.normalize(insertionIndex);
        return true;
    }

    public LongIterator iterator() {
        return new LongIterator(){
            int nextIndex = 0;
            int lastIndex = -1;
            int currRange = 0;
            int currOffset = 0;
            long lastValue;

            public boolean hasNext() {
                return this.nextIndex < LongRangeSet.this.size;
            }

            public long next() {
                if (this.nextIndex >= LongRangeSet.this.size) {
                    Exceptions.endOfIterator();
                }
                this.lastIndex = this.nextIndex++;
                this.lastValue = this.curr();
                if (this.nextIndex < LongRangeSet.this.size) {
                    if (this.currOffset == LongRangeSet.this.range(this.currRange).length() - 1) {
                        ++this.currRange;
                        this.currOffset = 0;
                    } else {
                        ++this.currOffset;
                    }
                }
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                LongRangeSet.this.remove(this.lastValue);
                --this.nextIndex;
                if (this.nextIndex < LongRangeSet.this.size) {
                    this.recalc();
                }
                this.lastIndex = -1;
            }

            private long curr() {
                return LongRangeSet.this.range(this.currRange).first() + (long)this.currOffset;
            }

            private void recalc() {
                int rs;
                this.currRange = 0;
                this.currOffset = this.nextIndex;
                while (this.currOffset >= (rs = LongRangeSet.this.range(this.currRange).length())) {
                    this.currOffset -= rs;
                    ++this.currRange;
                }
            }
        };
    }

    public long first() {
        if (this.size == 0) {
            Exceptions.setNoFirst();
        }
        return this.range(0).first();
    }

    private long firstFrom(long v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        if ((index = -index - 1) >= this.ranges.size()) {
            Exceptions.setNoFirst();
        }
        return this.range(index).first();
    }

    public long last() {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        return this.range(this.ranges.size() - 1).last();
    }

    private long lastFrom(long v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        index = -index - 1;
        if (--index < 0 || index >= this.ranges.size()) {
            Exceptions.setNoLast();
        }
        return this.range(index).last();
    }

    public LongSortedSet headSet(long to) {
        return new SubSet(false, 0L, true, to);
    }

    public LongSortedSet tailSet(long from) {
        return new SubSet(true, from, false, 0L);
    }

    public LongSortedSet subSet(long from, long to) {
        return new SubSet(true, from, true, to);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        int i = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            if (i > 0) {
                s.append(',');
            }
            s.append(this.range(i));
            ++i;
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public Object clone() {
        try {
            LongRangeSet c = (LongRangeSet)super.clone();
            c.ranges = (ArrayList)this.ranges.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public void clear() {
        this.ranges.clear();
        this.size = 0;
    }

    public boolean contains(long v) {
        return this.getRangeIndexOf(v) >= 0;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        boolean index = false;
        int rsize = this.ranges.size();
        while (i < rsize) {
            LongRange r = this.range(i);
            long c = r.first();
            long last = r.last();
            while (c <= last) {
                h = (int)((long)h + c);
                ++c;
            }
            ++i;
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(long v) {
        int index = this.getRangeIndexOf(v);
        if (index < 0) {
            return false;
        }
        LongRange r = this.range(index);
        if (v == r.first()) {
            if (r.length() == 1) {
                this.ranges.remove(index);
            } else {
                this.ranges.set(index, new LongRange(r.first() + 1L, r.last()));
            }
        } else if (v == r.last()) {
            this.ranges.set(index, new LongRange(r.first(), r.last() - 1L));
        } else {
            LongRange r1 = new LongRange(r.first(), v - 1L);
            LongRange r2 = new LongRange(v + 1L, r.last());
            this.ranges.set(index, r1);
            this.ranges.add(index + 1, r2);
        }
        --this.size;
        return true;
    }

    public long[] toArray(long[] a) {
        if (a == null || a.length < this.size) {
            a = new long[this.size];
        }
        int i = 0;
        int index = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            LongRange r = this.range(i);
            long c = r.first();
            long last = r.last();
            while (c <= last) {
                a[index++] = c++;
            }
            ++i;
        }
        return a;
    }

    public boolean containsAll(LongRange range) {
        LongRange r = this.getRangeOf(range.first());
        return r != null ? r.contains(range.last()) : false;
    }

    public boolean addAll(LongRangeSet c) {
        int oldSize = this.size;
        int i = 0;
        int rsize = c.ranges.size();
        while (i < rsize) {
            this.addAll(c.range(i));
            ++i;
        }
        return this.size != oldSize;
    }

    public boolean addAll(LongRange range) {
        int oldSize = this.size;
        int index = this.insertRange(range);
        if (index != -1) {
            int nindex = index;
            if (nindex > 0) {
                --nindex;
            }
            this.size += range.length();
            this.normalize(nindex);
        }
        return this.size != oldSize;
    }

    public boolean addAll(long first, long last) {
        return this.addAll(new LongRange(first, last));
    }

    public boolean addAll(long[] a) {
        long[] sa;
        if (a.length == 0) {
            return false;
        }
        int oldSize = this.size;
        if (!this.isSorted(a)) {
            sa = (long[])a.clone();
            Arrays.sort(sa);
        } else {
            sa = a;
        }
        int index = 0;
        while (index < sa.length) {
            long c0 = sa[index];
            index = this.range(sa, index);
            long c1 = sa[index];
            this.ranges.add(new LongRange(c0, c1));
            ++index;
        }
        Collections.sort(this.ranges);
        this.normalize();
        return this.size != oldSize;
    }

    private int range(long[] a, int index) {
        long c0 = a[index++];
        while (index < a.length && a[index] == c0) {
            ++index;
        }
        while (index < a.length && a[index] == c0 + 1L) {
            c0 = a[index++];
            while (index < a.length && a[index] == c0) {
                ++index;
            }
        }
        return index - 1;
    }

    private boolean isSorted(long[] a) {
        int i = 1;
        while (i < a.length) {
            if (a[i] < a[i - 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public LongRange[] ranges() {
        LongRange[] a = new LongRange[this.ranges.size()];
        this.ranges.toArray(a);
        return a;
    }

    private class SubSet
    extends AbstractLongSet
    implements LongSortedSet,
    Serializable {
        private boolean hasLowerBound;
        private boolean hasUpperBound;
        private long lowerBound;
        private long upperBound;

        SubSet(boolean hasLowerBound, long lowerBound, boolean hasUpperBound, long upperBound) {
            if (hasLowerBound) {
                if (lowerBound < 0L) {
                    Exceptions.negativeArgument("lower bound", String.valueOf(lowerBound));
                }
                if (hasUpperBound && upperBound < lowerBound) {
                    Exceptions.invalidSetBounds(String.valueOf(lowerBound), String.valueOf(upperBound));
                }
            }
            this.hasLowerBound = hasLowerBound;
            this.lowerBound = lowerBound;
            this.hasUpperBound = hasUpperBound;
            this.upperBound = upperBound;
        }

        public boolean add(long v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return LongRangeSet.this.add(v);
        }

        public boolean remove(long v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return LongRangeSet.this.remove(v);
        }

        public boolean contains(long v) {
            return this.inSubRange(v) && LongRangeSet.this.contains(v);
        }

        public LongIterator iterator() {
            long first;
            try {
                first = this.first();
            }
            catch (NoSuchElementException e) {
                return new EmptySubSetIterator();
            }
            long last = this.last();
            int rangeIndexLow = LongRangeSet.this.getRangeIndexOf(first);
            int rangeIndexHigh = LongRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                return new SimpleSubSetIterator(first, last);
            }
            return new NonEmptySubSetIterator(first, last, rangeIndexLow, rangeIndexHigh);
        }

        public int size() {
            int size;
            int rangeIndexLow;
            long first;
            if (LongRangeSet.this.size() == 0) {
                return 0;
            }
            try {
                first = this.first();
                rangeIndexLow = LongRangeSet.this.getRangeIndexOf(first);
            }
            catch (NoSuchElementException e) {
                return 0;
            }
            long last = this.last();
            int rangeIndexHigh = LongRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                size = (int)(last - first + 1L);
            } else {
                LongRange rangeLow = LongRangeSet.this.range(rangeIndexLow);
                LongRange rangeHigh = LongRangeSet.this.range(rangeIndexHigh);
                int sizeLow = (int)(rangeLow.last() - first + 1L);
                int sizeHigh = (int)(last - rangeHigh.first() + 1L);
                size = sizeLow + sizeHigh;
                int i = rangeIndexLow + 1;
                while (i < rangeIndexHigh) {
                    size += LongRangeSet.this.range(i).length();
                    ++i;
                }
            }
            return size;
        }

        public long first() {
            long first = LongRangeSet.this.firstFrom(this.hasLowerBound ? this.lowerBound : 0L);
            if (this.hasUpperBound && first >= this.upperBound) {
                Exceptions.setNoFirst();
            }
            return first;
        }

        public long last() {
            long last = LongRangeSet.this.lastFrom(this.hasUpperBound ? this.upperBound - 1L : LongRangeSet.this.last());
            if (this.hasLowerBound && last < this.lowerBound) {
                Exceptions.setNoLast();
            }
            return last;
        }

        public LongSortedSet headSet(long to) {
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(this.hasLowerBound, this.lowerBound, true, to);
        }

        public LongSortedSet tailSet(long from) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            return new SubSet(true, from, this.hasUpperBound, this.upperBound);
        }

        public LongSortedSet subSet(long from, long to) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(true, from, true, to);
        }

        private boolean inSubRange(long v) {
            if (this.hasLowerBound && v < this.lowerBound) {
                return false;
            }
            return !this.hasUpperBound || v < this.upperBound;
        }

        class NonEmptySubSetIterator
        implements LongIterator {
            long first;
            long last;
            int rangeIndexLow;
            int rangeIndexHigh;
            LongRange rangeLow;
            LongRange rangeHigh;
            long previousValue;
            LongRange currRange;
            int currRangeIndex;
            int currOffset;
            boolean valueAvailable;
            int nextIndex;

            NonEmptySubSetIterator(long first, long last, int rangeIndexLow, int rangeIndexHigh) {
                if (rangeIndexLow == rangeIndexHigh) {
                    throw new RuntimeException("Internal error");
                }
                this.first = first;
                this.last = last;
                this.rangeIndexLow = rangeIndexLow;
                this.rangeIndexHigh = rangeIndexHigh;
                this.rangeLow = new LongRange(first, LongRangeSet.this.range(rangeIndexLow).last());
                this.rangeHigh = new LongRange(LongRangeSet.this.range(rangeIndexHigh).first(), last);
                this.currRangeIndex = rangeIndexLow;
                this.currRange = this.rangeLow;
                this.currOffset = 0;
                this.previousValue = first;
                this.valueAvailable = false;
                this.nextIndex = 0;
            }

            private LongRange getRange(int rangeIndex) {
                if (rangeIndex == this.rangeIndexLow) {
                    return this.rangeLow;
                }
                if (rangeIndex == this.rangeIndexHigh) {
                    return this.rangeHigh;
                }
                return LongRangeSet.this.range(rangeIndex);
            }

            private void recalc() {
                int rs;
                this.first = SubSet.this.first();
                this.last = SubSet.this.last();
                this.rangeIndexLow = LongRangeSet.this.getRangeIndexOf(this.first);
                this.rangeIndexHigh = LongRangeSet.this.getRangeIndexOf(this.last);
                if (this.rangeIndexLow == this.rangeIndexHigh) {
                    this.rangeLow = this.rangeHigh = new LongRange(this.first, this.last);
                } else {
                    this.rangeLow = new LongRange(this.first, LongRangeSet.this.range(this.rangeIndexLow).last());
                    this.rangeHigh = new LongRange(LongRangeSet.this.range(this.rangeIndexHigh).first(), this.last);
                }
                this.currOffset = this.nextIndex;
                this.currRangeIndex = this.rangeIndexLow;
                this.currRange = this.rangeLow;
                while (this.currOffset >= (rs = this.currRange.length())) {
                    this.currOffset -= rs;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
            }

            public boolean hasNext() {
                return this.previousValue < this.last;
            }

            public long next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.previousValue = this.currRange.first() + (long)this.currOffset++;
                if (this.currOffset == this.currRange.length() && this.previousValue < this.last) {
                    this.currOffset = 0;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
                ++this.nextIndex;
                this.valueAvailable = true;
                return this.previousValue;
            }

            public void remove() {
                if (!this.valueAvailable) {
                    Exceptions.noElementToRemove();
                }
                LongRangeSet.this.remove(this.previousValue);
                --this.nextIndex;
                this.recalc();
                this.valueAvailable = false;
            }
        }

        class SimpleSubSetIterator
        implements LongIterator {
            int nextIndex;
            int size;
            int lastIndex;
            long lastValue;
            long from;
            long to;

            SimpleSubSetIterator(long from, long to) {
                this.size = (int)(to - from + 1L);
                this.nextIndex = 0;
                this.lastIndex = -1;
                this.from = from;
                this.to = to;
            }

            public boolean hasNext() {
                return this.nextIndex < this.size;
            }

            public long next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = this.from + (long)this.nextIndex;
                this.lastIndex = this.nextIndex++;
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                LongRangeSet.this.remove(this.lastValue);
                this.lastIndex = -1;
            }
        }

        class EmptySubSetIterator
        implements LongIterator {
            EmptySubSetIterator() {
            }

            public boolean hasNext() {
                return false;
            }

            public long next() {
                Exceptions.endOfIterator();
                throw new RuntimeException();
            }

            public void remove() {
                Exceptions.noElementToRemove();
            }
        }
    }
}

