/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.LongIterator;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.hash.LongHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.map.AbstractLongKeyMap;
import bak.pcj.map.LongKeyMap;
import bak.pcj.map.LongKeyMapIterator;
import bak.pcj.set.AbstractLongSet;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class LongKeyOpenHashMap
extends AbstractLongKeyMap
implements LongKeyMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private LongHashFunction keyhash;
    private int size;
    private transient long[] keys;
    private transient Object[] values;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient LongSet ckeys;
    private transient Collection cvalues;

    private LongKeyOpenHashMap(LongHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        capacity = Primes.nextPrime(capacity);
        this.keys = new long[capacity];
        this.values = new Object[capacity];
        this.states = new byte[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.used = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
    }

    private LongKeyOpenHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultLongHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public LongKeyOpenHashMap() {
        this(11);
    }

    public LongKeyOpenHashMap(LongKeyMap map) {
        this();
        this.putAll(map);
    }

    public LongKeyOpenHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public LongKeyOpenHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public LongKeyOpenHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public LongKeyOpenHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongKeyOpenHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public LongKeyOpenHashMap(LongHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public LongKeyOpenHashMap(LongHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public LongKeyOpenHashMap(LongHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public LongKeyOpenHashMap(LongHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public LongKeyOpenHashMap(LongHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongKeyOpenHashMap(LongHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.keys.length * (1.0 + this.growthFactor)) : this.keys.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            long[] newkeys = new long[newcapacity];
            Object[] newvalues = new Object[newcapacity];
            byte[] newstates = new byte[newcapacity];
            this.used = 0;
            int i = 0;
            while (i < this.keys.length) {
                if (this.states[i] == 1) {
                    ++this.used;
                    long k = this.keys[i];
                    Object v = this.values[i];
                    int h = Math.abs(this.keyhash.hash(k));
                    int n = h % newcapacity;
                    if (newstates[n] == 1) {
                        int c = 1 + h % (newcapacity - 2);
                        do {
                            if ((n -= c) >= 0) continue;
                            n += newcapacity;
                        } while (newstates[n] != 0);
                    }
                    newstates[n] = 1;
                    newvalues[n] = v;
                    newkeys[n] = k;
                }
                ++i;
            }
            this.keys = newkeys;
            this.values = newvalues;
            this.states = newstates;
        }
    }

    public LongSet keySet() {
        if (this.ckeys == null) {
            this.ckeys = new KeySet();
        }
        return this.ckeys;
    }

    public Object put(long key, Object value) {
        int i;
        block5: {
            int h = Math.abs(this.keyhash.hash(key));
            i = h % this.keys.length;
            if (this.states[i] == 1) {
                if (this.keys[i] == key) {
                    Object oldValue = this.values[i];
                    this.values[i] = value;
                    return oldValue;
                }
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) < 0) {
                        i += this.keys.length;
                    }
                    if (this.states[i] == 0 || this.states[i] == 2) break block5;
                } while (this.states[i] != 1 || this.keys[i] != key);
                Object oldValue = this.values[i];
                this.values[i] = value;
                return oldValue;
            }
        }
        if (this.states[i] == 0) {
            ++this.used;
        }
        this.states[i] = 1;
        this.keys[i] = key;
        this.values[i] = value;
        ++this.size;
        this.ensureCapacity(this.used);
        return null;
    }

    public Collection values() {
        if (this.cvalues == null) {
            this.cvalues = new ValueCollection();
        }
        return this.cvalues;
    }

    public Object clone() {
        try {
            LongKeyOpenHashMap c = (LongKeyOpenHashMap)super.clone();
            c.keys = new long[this.keys.length];
            System.arraycopy(this.keys, 0, c.keys, 0, this.keys.length);
            c.values = new Object[this.values.length];
            System.arraycopy(this.values, 0, c.values, 0, this.values.length);
            c.states = new byte[this.states.length];
            System.arraycopy(this.states, 0, c.states, 0, this.states.length);
            c.cvalues = null;
            c.ckeys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    public LongKeyMapIterator entries() {
        return new LongKeyMapIterator(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int index) {
                while (index < LongKeyOpenHashMap.this.keys.length && LongKeyOpenHashMap.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            public boolean hasNext() {
                return this.nextEntry < LongKeyOpenHashMap.this.keys.length;
            }

            public void next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
            }

            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((LongKeyOpenHashMap)LongKeyOpenHashMap.this).states[this.lastEntry] = 2;
                ((LongKeyOpenHashMap)LongKeyOpenHashMap.this).values[this.lastEntry] = null;
                LongKeyOpenHashMap.this.size--;
                this.lastEntry = -1;
            }

            public long getKey() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return LongKeyOpenHashMap.this.keys[this.lastEntry];
            }

            public Object getValue() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return LongKeyOpenHashMap.this.values[this.lastEntry];
            }
        };
    }

    public void clear() {
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
        this.used = 0;
    }

    public boolean containsKey(long key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return true;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return false;
            } while (this.states[i] != 1 || this.keys[i] != key);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            int i = 0;
            while (i < this.states.length) {
                if (this.states[i] == 1 && this.values[i] == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.states.length) {
                if (this.states[i] == 1 && value.equals(this.values[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object get(long key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return null;
            } while (this.states[i] != 1 || this.keys[i] != key);
            return this.values[i];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object remove(long key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                Object oldValue = this.values[i];
                this.values[i] = null;
                this.states[i] = 2;
                --this.size;
                return oldValue;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return null;
            } while (this.states[i] != 1 || this.keys[i] != key);
            Object oldValue = this.values[i];
            this.values[i] = null;
            this.states[i] = 2;
            --this.size;
            return oldValue;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.keys.length);
        LongKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeLong(i.getKey());
            s.writeObject(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keys = new long[s.readInt()];
        this.states = new byte[this.keys.length];
        this.values = new Object[this.keys.length];
        this.used = this.size;
        int n = 0;
        while (n < this.size) {
            long key = s.readLong();
            Object value = s.readObject();
            int h = Math.abs(this.keyhash.hash(key));
            int i = h % this.keys.length;
            if (this.states[i] != 0) {
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) >= 0) continue;
                    i += this.keys.length;
                } while (this.states[i] != 0);
            }
            this.states[i] = 1;
            this.keys[i] = key;
            this.values[i] = value;
            ++n;
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        public void clear() {
            LongKeyOpenHashMap.this.clear();
        }

        public boolean contains(Object v) {
            return LongKeyOpenHashMap.this.containsValue(v);
        }

        public Iterator iterator() {
            return new Iterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ ValueCollection this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < LongKeyOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length && LongKeyOpenHashMap.access$300(ValueCollection.access$700(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < LongKeyOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return LongKeyOpenHashMap.access$400(ValueCollection.access$700(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    LongKeyOpenHashMap.access$300((LongKeyOpenHashMap)ValueCollection.access$700((ValueCollection)this.this$1))[this.lastEntry] = 2;
                    LongKeyOpenHashMap.access$400((LongKeyOpenHashMap)ValueCollection.access$700((ValueCollection)this.this$1))[this.lastEntry] = null;
                    LongKeyOpenHashMap.access$510(ValueCollection.access$700(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public int size() {
            return LongKeyOpenHashMap.this.size;
        }

        static /* synthetic */ LongKeyOpenHashMap access$700(ValueCollection x0) {
            return x0.LongKeyOpenHashMap.this;
        }
    }

    private class KeySet
    extends AbstractLongSet {
        private KeySet() {
        }

        public void clear() {
            LongKeyOpenHashMap.this.clear();
        }

        public boolean contains(long v) {
            return LongKeyOpenHashMap.this.containsKey(v);
        }

        public LongIterator iterator() {
            return new LongIterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < LongKeyOpenHashMap.access$200(KeySet.access$600(this.this$1)).length && LongKeyOpenHashMap.access$300(KeySet.access$600(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < LongKeyOpenHashMap.access$200(KeySet.access$600(this.this$1)).length;
                }

                public long next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return LongKeyOpenHashMap.access$200(KeySet.access$600(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    LongKeyOpenHashMap.access$300((LongKeyOpenHashMap)KeySet.access$600((KeySet)this.this$1))[this.lastEntry] = 2;
                    LongKeyOpenHashMap.access$400((LongKeyOpenHashMap)KeySet.access$600((KeySet)this.this$1))[this.lastEntry] = null;
                    LongKeyOpenHashMap.access$510(KeySet.access$600(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public boolean remove(long v) {
            boolean result = LongKeyOpenHashMap.this.containsKey(v);
            if (result) {
                LongKeyOpenHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return LongKeyOpenHashMap.this.size;
        }

        static /* synthetic */ LongKeyOpenHashMap access$600(KeySet x0) {
            return x0.LongKeyOpenHashMap.this;
        }
    }
}

