/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.AbstractBooleanCollection;
import bak.pcj.BooleanCollection;
import bak.pcj.BooleanIterator;
import bak.pcj.IntIterator;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.hash.IntHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.map.AbstractIntKeyBooleanMap;
import bak.pcj.map.IntKeyBooleanMap;
import bak.pcj.map.IntKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.AbstractIntSet;
import bak.pcj.set.IntSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class IntKeyBooleanOpenHashMap
extends AbstractIntKeyBooleanMap
implements IntKeyBooleanMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private IntHashFunction keyhash;
    private int size;
    private transient int[] keys;
    private transient boolean[] values;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient IntSet ckeys;
    private transient BooleanCollection cvalues;
    private transient boolean hasLastValue;
    private transient boolean lastValue;

    private IntKeyBooleanOpenHashMap(IntHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        capacity = Primes.nextPrime(capacity);
        this.keys = new int[capacity];
        this.values = new boolean[capacity];
        this.states = new byte[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.used = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
        this.hasLastValue = false;
    }

    private IntKeyBooleanOpenHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultIntHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public IntKeyBooleanOpenHashMap() {
        this(11);
    }

    public IntKeyBooleanOpenHashMap(IntKeyBooleanMap map) {
        this();
        this.putAll(map);
    }

    public IntKeyBooleanOpenHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public IntKeyBooleanOpenHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public IntKeyBooleanOpenHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public IntKeyBooleanOpenHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public IntKeyBooleanOpenHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public IntKeyBooleanOpenHashMap(IntHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public IntKeyBooleanOpenHashMap(IntHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public IntKeyBooleanOpenHashMap(IntHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public IntKeyBooleanOpenHashMap(IntHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public IntKeyBooleanOpenHashMap(IntHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public IntKeyBooleanOpenHashMap(IntHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.keys.length * (1.0 + this.growthFactor)) : this.keys.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            int[] newkeys = new int[newcapacity];
            boolean[] newvalues = new boolean[newcapacity];
            byte[] newstates = new byte[newcapacity];
            this.used = 0;
            int i = 0;
            while (i < this.keys.length) {
                if (this.states[i] == 1) {
                    ++this.used;
                    int k = this.keys[i];
                    boolean v = this.values[i];
                    int h = Math.abs(this.keyhash.hash(k));
                    int n = h % newcapacity;
                    if (newstates[n] == 1) {
                        int c = 1 + h % (newcapacity - 2);
                        do {
                            if ((n -= c) >= 0) continue;
                            n += newcapacity;
                        } while (newstates[n] != 0);
                    }
                    newstates[n] = 1;
                    newvalues[n] = v;
                    newkeys[n] = k;
                }
                ++i;
            }
            this.keys = newkeys;
            this.values = newvalues;
            this.states = newstates;
        }
    }

    public IntSet keySet() {
        if (this.ckeys == null) {
            this.ckeys = new KeySet();
        }
        return this.ckeys;
    }

    public boolean lget() {
        if (!this.hasLastValue) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public boolean put(int key, boolean value) {
        int i;
        block5: {
            int h = Math.abs(this.keyhash.hash(key));
            i = h % this.keys.length;
            if (this.states[i] == 1) {
                if (this.keys[i] == key) {
                    boolean oldValue = this.values[i];
                    this.values[i] = value;
                    return oldValue;
                }
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) < 0) {
                        i += this.keys.length;
                    }
                    if (this.states[i] == 0 || this.states[i] == 2) break block5;
                } while (this.states[i] != 1 || this.keys[i] != key);
                boolean oldValue = this.values[i];
                this.values[i] = value;
                return oldValue;
            }
        }
        if (this.states[i] == 0) {
            ++this.used;
        }
        this.states[i] = 1;
        this.keys[i] = key;
        this.values[i] = value;
        ++this.size;
        this.ensureCapacity(this.used);
        return MapDefaults.defaultBoolean();
    }

    public BooleanCollection values() {
        if (this.cvalues == null) {
            this.cvalues = new ValueCollection();
        }
        return this.cvalues;
    }

    public Object clone() {
        try {
            IntKeyBooleanOpenHashMap c = (IntKeyBooleanOpenHashMap)super.clone();
            c.keys = new int[this.keys.length];
            System.arraycopy(this.keys, 0, c.keys, 0, this.keys.length);
            c.values = new boolean[this.values.length];
            System.arraycopy(this.values, 0, c.values, 0, this.values.length);
            c.states = new byte[this.states.length];
            System.arraycopy(this.states, 0, c.states, 0, this.states.length);
            c.cvalues = null;
            c.ckeys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    public IntKeyBooleanMapIterator entries() {
        return new IntKeyBooleanMapIterator(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int index) {
                while (index < IntKeyBooleanOpenHashMap.this.keys.length && IntKeyBooleanOpenHashMap.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            public boolean hasNext() {
                return this.nextEntry < IntKeyBooleanOpenHashMap.this.keys.length;
            }

            public void next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
            }

            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((IntKeyBooleanOpenHashMap)IntKeyBooleanOpenHashMap.this).states[this.lastEntry] = 2;
                IntKeyBooleanOpenHashMap.this.size--;
                this.lastEntry = -1;
            }

            public int getKey() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return IntKeyBooleanOpenHashMap.this.keys[this.lastEntry];
            }

            public boolean getValue() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return IntKeyBooleanOpenHashMap.this.values[this.lastEntry];
            }
        };
    }

    public void clear() {
        Arrays.fill(this.states, (byte)0);
        this.size = 0;
        this.used = 0;
    }

    public boolean containsKey(int key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                this.hasLastValue = true;
                this.lastValue = this.values[i];
                return true;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                this.hasLastValue = false;
                return false;
            } while (this.states[i] != 1 || this.keys[i] != key);
            this.hasLastValue = true;
            this.lastValue = this.values[i];
            return true;
        }
        this.hasLastValue = false;
        return false;
    }

    public boolean containsValue(boolean value) {
        int i = 0;
        while (i < this.states.length) {
            if (this.states[i] == 1 && this.values[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean get(int key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return MapDefaults.defaultBoolean();
            } while (this.states[i] != 1 || this.keys[i] != key);
            return this.values[i];
        }
        return MapDefaults.defaultBoolean();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean remove(int key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                boolean oldValue = this.values[i];
                this.states[i] = 2;
                --this.size;
                return oldValue;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return MapDefaults.defaultBoolean();
            } while (this.states[i] != 1 || this.keys[i] != key);
            boolean oldValue = this.values[i];
            this.states[i] = 2;
            --this.size;
            return oldValue;
        }
        return MapDefaults.defaultBoolean();
    }

    public int size() {
        return this.size;
    }

    public boolean tget(int key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                Exceptions.noSuchMapping(String.valueOf(key));
            } while (this.states[i] != 1 || this.keys[i] != key);
            return this.values[i];
        }
        Exceptions.noSuchMapping(String.valueOf(key));
        throw new RuntimeException();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.keys.length);
        IntKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeInt(i.getKey());
            s.writeBoolean(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keys = new int[s.readInt()];
        this.states = new byte[this.keys.length];
        this.values = new boolean[this.keys.length];
        this.used = this.size;
        int n = 0;
        while (n < this.size) {
            int key = s.readInt();
            boolean value = s.readBoolean();
            int h = Math.abs(this.keyhash.hash(key));
            int i = h % this.keys.length;
            if (this.states[i] != 0) {
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) >= 0) continue;
                    i += this.keys.length;
                } while (this.states[i] != 0);
            }
            this.states[i] = 1;
            this.keys[i] = key;
            this.values[i] = value;
            ++n;
        }
    }

    private class ValueCollection
    extends AbstractBooleanCollection {
        private ValueCollection() {
        }

        public void clear() {
            IntKeyBooleanOpenHashMap.this.clear();
        }

        public boolean contains(boolean v) {
            return IntKeyBooleanOpenHashMap.this.containsValue(v);
        }

        public BooleanIterator iterator() {
            return new BooleanIterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ ValueCollection this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < IntKeyBooleanOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length && IntKeyBooleanOpenHashMap.access$300(ValueCollection.access$700(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < IntKeyBooleanOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length;
                }

                public boolean next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return IntKeyBooleanOpenHashMap.access$500(ValueCollection.access$700(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    IntKeyBooleanOpenHashMap.access$300((IntKeyBooleanOpenHashMap)ValueCollection.access$700((ValueCollection)this.this$1))[this.lastEntry] = 2;
                    IntKeyBooleanOpenHashMap.access$410(ValueCollection.access$700(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public int size() {
            return IntKeyBooleanOpenHashMap.this.size;
        }

        static /* synthetic */ IntKeyBooleanOpenHashMap access$700(ValueCollection x0) {
            return x0.IntKeyBooleanOpenHashMap.this;
        }
    }

    private class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        public void clear() {
            IntKeyBooleanOpenHashMap.this.clear();
        }

        public boolean contains(int v) {
            return IntKeyBooleanOpenHashMap.this.containsKey(v);
        }

        public IntIterator iterator() {
            return new IntIterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < IntKeyBooleanOpenHashMap.access$200(KeySet.access$600(this.this$1)).length && IntKeyBooleanOpenHashMap.access$300(KeySet.access$600(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < IntKeyBooleanOpenHashMap.access$200(KeySet.access$600(this.this$1)).length;
                }

                public int next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return IntKeyBooleanOpenHashMap.access$200(KeySet.access$600(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    IntKeyBooleanOpenHashMap.access$300((IntKeyBooleanOpenHashMap)KeySet.access$600((KeySet)this.this$1))[this.lastEntry] = 2;
                    IntKeyBooleanOpenHashMap.access$410(KeySet.access$600(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public boolean remove(int v) {
            boolean result = IntKeyBooleanOpenHashMap.this.containsKey(v);
            if (result) {
                IntKeyBooleanOpenHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return IntKeyBooleanOpenHashMap.this.size;
        }

        static /* synthetic */ IntKeyBooleanOpenHashMap access$600(KeySet x0) {
            return x0.IntKeyBooleanOpenHashMap.this;
        }
    }
}

