/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.comp;

import java.util.logging.Logger;
import org.jzkit.a2j.codec.comp.ASTBuiltinType;
import org.jzkit.a2j.codec.comp.ASTClassNumber;
import org.jzkit.a2j.codec.comp.ASTElementType;
import org.jzkit.a2j.codec.comp.ASTElementTypeList;
import org.jzkit.a2j.codec.comp.ASTNamedType;
import org.jzkit.a2j.codec.comp.ASTSetOrSequenceType;
import org.jzkit.a2j.codec.comp.ASTTag;
import org.jzkit.a2j.codec.comp.ASTTaggedType;
import org.jzkit.a2j.codec.comp.ASTType;
import org.jzkit.a2j.codec.comp.AsnParser;
import org.jzkit.a2j.codec.comp.ChoiceTypeInfo;
import org.jzkit.a2j.codec.comp.CodecBuilderInfo;
import org.jzkit.a2j.codec.comp.SimpleNode;

public class ASTChoiceType
extends SimpleNode {
    private static Logger log = Logger.getLogger(ASTChoiceType.class.getName());

    public ASTChoiceType(int id) {
        super(id);
    }

    public ASTChoiceType(AsnParser p, int id) {
        super(p, id);
    }

    public void getChoiceMembers(ChoiceTypeInfo cti) {
        CodecBuilderInfo info = CodecBuilderInfo.getInfo();
        log.fine("ASTChoiceType::getChoiceMembers");
        ASTElementTypeList choice_elements = (ASTElementTypeList)this.jjtGetChild(0);
        int k = choice_elements.jjtGetNumChildren();
        for (int i = 0; i < k; ++i) {
            boolean is_implicit;
            ASTElementType choice_element = (ASTElementType)choice_elements.jjtGetChild(i);
            if (choice_element.which != 1) continue;
            ASTNamedType name = (ASTNamedType)choice_element.jjtGetChild(0);
            String element_name = null;
            ASTType element_type_info = name.getType();
            boolean has_tagging = false;
            int tag_class = -1;
            int tag_number = -1;
            boolean bl = is_implicit = !info.default_tagging_is_explicit;
            if (element_type_info.which == 1) {
                ASTBuiltinType bit = (ASTBuiltinType)element_type_info.jjtGetChild(0);
                if (bit.which == 6) {
                    has_tagging = true;
                    ASTTaggedType tt = (ASTTaggedType)bit.jjtGetChild(0);
                    is_implicit = tt.isImplicit();
                    element_type_info = tt.getType();
                    ASTTag tag = tt.getTag();
                    tag_class = tag.hasTagClass ? tag.getTagClass().tag_class : 128;
                    ASTClassNumber cn = tag.getClassNumber();
                    if (cn.which == 1) {
                        tag_number = cn.getNumber().getNumber();
                    } else {
                        log.fine("Unhandled tag number type");
                        System.exit(0);
                    }
                }
            }
            String type_name = element_type_info.getTypeName();
            element_name = name.jjtGetNumChildren() == 2 ? name.getName().replace('-', '_') : (type_name + "_var").replace('-', '_');
            if (element_type_info.which == 1) {
                ASTBuiltinType bit = (ASTBuiltinType)element_type_info.jjtGetChild(0);
                switch (bit.which) {
                    case 2: {
                        ASTSetOrSequenceType sos = (ASTSetOrSequenceType)bit.jjtGetChild(0);
                        type_name = element_name + "_inline" + info.getNextInlineCounter();
                        log.fine("Creating inline type " + type_name);
                        info.createTypeInfoFor(type_name, element_type_info);
                        break;
                    }
                    case 3: {
                        type_name = element_name + "_inline" + info.getNextInlineCounter();
                        info.createTypeInfoFor(type_name, element_type_info);
                        break;
                    }
                    case 4: {
                        type_name = element_name + "_inline" + info.getNextInlineCounter();
                        info.createTypeInfoFor(type_name, element_type_info);
                        break;
                    }
                }
            }
            cti.registerTaggedMember(element_name, tag_class, tag_number, is_implicit, type_name, choice_element.optional);
            log.fine("Adding Choice element " + tag_class + " " + tag_number + " " + is_implicit + " " + element_name + " " + type_name + (choice_element.optional ? " OPTIONAL " : ""));
        }
    }
}

