/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services.getrecords;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.Sort;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.Util;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.ResultType;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.csw.services.getrecords.CatalogSearcher;
import org.fao.geonet.kernel.csw.services.getrecords.ResultItem;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.geotools.gml2.GMLConfiguration;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;

public class SearchController {
    public static final String DEFAULT_ELEMENTNAMES_STRATEGY = "relaxed";
    private final Set<String> _selector = Collections.singleton("_id");
    private final Set<String> _uuidselector = Collections.singleton("_uuid");
    private GMLConfiguration _gmlConfig = new GMLConfiguration();
    private ApplicationContext _applicationContext;

    public SearchController(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    public static Element retrieveMetadata(ServiceContext context, String id, ElementSetName setName, String outSchema, Set<String> elemNames, String typeName, ResultType resultType, String strategy, String displayLanguage) throws CatalogException {
        try {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            boolean forEditing = false;
            boolean withValidationErrors = false;
            boolean keepXlinkAttributes = false;
            Element res = ((DataManager)gc.getBean(DataManager.class)).getMetadata(context, id, forEditing, withValidationErrors, keepXlinkAttributes);
            SchemaManager scm = (SchemaManager)gc.getBean(SchemaManager.class);
            if (res == null) {
                return null;
            }
            Element info = res.getChild("info", Edit.NAMESPACE);
            String schema = info.getChildText("schema");
            Attribute schemaLocAtt = scm.getSchemaLocation(schema, context);
            if (schemaLocAtt != null && res.getAttribute(schemaLocAtt.getName(), schemaLocAtt.getNamespace()) == null) {
                res.setAttribute(schemaLocAtt);
                res.removeNamespaceDeclaration(schemaLocAtt.getNamespace());
                res.addNamespaceDeclaration(schemaLocAtt.getNamespace());
            }
            res = org.fao.geonet.csw.common.util.Xml.applyElementSetName(context, scm, schema, res, outSchema, setName, resultType, id, displayLanguage);
            res = SearchController.applyElementNames(context, elemNames, typeName, scm, schema, res, resultType, info, strategy);
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("SearchController:retrieveMetadata: before applying postprocessing on metadata Element for id " + id));
            }
            res = SearchController.applyPostProcessing(context, scm, schema, res, outSchema, setName, resultType, id, displayLanguage);
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("SearchController:retrieveMetadata: All processing is complete on metadata Element for id " + id));
            }
            if (res != null) {
                if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                    Log.debug((String)"geonetwork.csw.search", (Object)("SearchController returns\n" + Xml.getString((Element)res)));
                }
            } else if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)"SearchController returns null");
            }
            return res;
        }
        catch (InvalidParameterValueEx e) {
            throw e;
        }
        catch (Exception e) {
            context.error("Error while getting metadata with id : " + id);
            context.error("  (C) StackTrace:\n" + Util.getStackTrace((Throwable)e));
            throw new NoApplicableCodeEx("Raised exception while getting metadata :" + e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Element applyElementNames(ServiceContext context, Set<String> elementNames, String typeName, SchemaManager schemaManager, String schema, Element result, ResultType resultType, Element info, String strategy) throws InvalidParameterValueEx {
        if (elementNames != null) {
            if (StringUtils.isEmpty((String)strategy)) {
                strategy = DEFAULT_ELEMENTNAMES_STRATEGY;
            }
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("SearchController dealing with # " + elementNames.size() + " elementNames using strategy " + strategy));
            }
            MetadataSchema mds = schemaManager.getSchema(schema);
            List namespaces = mds.getSchemaNS();
            Element matchingMetadata = (Element)result.clone();
            if (strategy.equals("context") || strategy.equals("geonetwork26")) {
                matchingMetadata.removeContent();
            }
            boolean metadataContainsAllRequestedElementNames = true;
            ArrayList nodes = new ArrayList();
            for (String elementName : elementNames) {
                if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                    Log.debug((String)"geonetwork.csw.search", (Object)("SearchController dealing with elementName: " + elementName));
                }
                try {
                    String xpath;
                    if (elementName.startsWith("/")) {
                        xpath = elementName;
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)("elementname start with root: " + elementName));
                        }
                    } else if (elementName.startsWith("csw:Record") || elementName.startsWith("gmd:MD_Metadata")) {
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)("elementname starts with one of the supported typeNames : " + elementName));
                        }
                        xpath = "/" + elementName;
                    } else {
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)("elementname does not start with one of the supported typeNames : " + elementName));
                        }
                        xpath = "/" + typeName + "//" + elementName;
                    }
                    ArrayList<Element> elementsMatching = Xml.selectDocumentNodes((Element)result, (String)xpath, (List)namespaces);
                    if (strategy.equals("context")) {
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)"strategy is context, constructing context to root");
                        }
                        ArrayList<Element> elementsInContextMatching = new ArrayList<Element>();
                        for (Element match : elementsMatching) {
                            for (Element parent = match.getParentElement(); parent != null; parent = parent.getParentElement()) {
                                parent.removeContent();
                                parent.addContent((Content)((Element)match.clone()));
                                match = (Element)parent.clone();
                            }
                            elementsInContextMatching.add(match);
                        }
                        elementsMatching = elementsInContextMatching;
                    }
                    nodes.addAll(elementsMatching);
                    if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                        Log.debug((String)"geonetwork.csw.search", (Object)("elemName " + elementName + " matched # " + nodes.size() + " nodes"));
                    }
                    if (nodes.size() != 0) continue;
                    metadataContainsAllRequestedElementNames = false;
                    break;
                }
                catch (Exception x) {
                    Log.error((String)"geonetwork.csw.search", (Object)x.getMessage(), (Throwable)x);
                    throw new InvalidParameterValueEx("elementName has invalid XPath : " + elementName, x.getMessage());
                }
            }
            if (metadataContainsAllRequestedElementNames) {
                if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                    Log.debug((String)"geonetwork.csw.search", (Object)"metadata containa all requested elementnames: included in response");
                }
                if (strategy.equals("context") || strategy.equals("geonetwork26")) {
                    if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                        Log.debug((String)"geonetwork.csw.search", (Object)"adding only the matching fragments to result");
                    }
                    for (Element node : nodes) {
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)("adding node:\n" + Xml.getString((Element)node)));
                        }
                        matchingMetadata.addContent((Content)node.clone());
                    }
                } else {
                    if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                        Log.debug((String)"geonetwork.csw.search", (Object)"adding the complete metadata to results");
                    }
                    if (strategy.equals("csw202")) {
                        GeonetContext geonetContext = (GeonetContext)context.getHandlerContext("contextName");
                        DataManager dataManager = (DataManager)geonetContext.getBean(DataManager.class);
                        boolean valid = dataManager.validate(result);
                        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                            Log.debug((String)"geonetwork.csw.search", (Object)("strategy csw202: only valid metadata is returned. This one is valid? " + valid));
                        }
                        if (!valid) {
                            return null;
                        }
                    }
                    matchingMetadata = result;
                }
                if (resultType != ResultType.RESULTS_WITH_SUMMARY) return matchingMetadata;
                matchingMetadata.addContent((Content)info.clone());
                return matchingMetadata;
            }
            if (!Log.isDebugEnabled((String)"geonetwork.csw.search")) return null;
            Log.debug((String)"geonetwork.csw.search", (Object)"metadata does not contain all requested elementnames: not included in response");
            return null;
        }
        if (!Log.isDebugEnabled((String)"geonetwork.csw.search")) return result;
        Log.debug((String)"geonetwork.csw.search", (Object)"No ElementNames to apply");
        return result;
    }

    public Pair<Element, Element> search(ServiceContext context, int startPos, int maxRecords, ResultType resultType, String outSchema, ElementSetName setName, Element filterExpr, String filterVersion, Sort sort, Set<String> elemNames, String typeName, int maxHitsFromSummary, String cswServiceSpecificContraint, String strategy) throws CatalogException {
        Element results = new Element("SearchResults", Csw.NAMESPACE_CSW);
        CatalogSearcher searcher = new CatalogSearcher(this._gmlConfig, this._selector, this._uuidselector, this._applicationContext);
        context.getUserSession().setProperty("search.result", (Object)searcher);
        Pair<Element, List<ResultItem>> summaryAndSearchResults = searcher.search(context, filterExpr, filterVersion, typeName, sort, resultType, startPos, maxRecords, maxHitsFromSummary, cswServiceSpecificContraint);
        Element summary = (Element)summaryAndSearchResults.one();
        int numMatches = Integer.parseInt(summary.getAttributeValue("count"));
        if (numMatches != 0 && startPos > numMatches) {
            throw new InvalidParameterValueEx("startPosition", String.format("Start position (%d) can't be greater than number of matching records (%d for current search).", startPos, numMatches));
        }
        SettingInfo settingInfo = ((SearchManager)context.getBean(SearchManager.class)).getSettingInfo();
        String displayLanguage = LuceneSearcher.determineLanguage((ServiceContext)context, (Element)filterExpr, (SettingInfo)settingInfo).presentationLanguage;
        int counter = this.retrieveMetadataMatchingResults(context, results, summaryAndSearchResults, maxRecords, setName, outSchema, elemNames, typeName, resultType, strategy, displayLanguage);
        results.setAttribute("numberOfRecordsMatched", numMatches + "");
        results.setAttribute("numberOfRecordsReturned", counter + "");
        results.setAttribute("elementSet", setName.toString());
        int nextRecord = counter + startPos;
        if (nextRecord > numMatches) {
            results.setAttribute("nextRecord", "0");
        } else {
            results.setAttribute("nextRecord", nextRecord + "");
        }
        return Pair.read((Object)summary, (Object)results);
    }

    private int retrieveMetadataMatchingResults(ServiceContext context, Element results, Pair<Element, List<ResultItem>> summaryAndSearchResults, int maxRecords, ElementSetName elementSetName, String outputSchema, Set<String> elementNames, String typeName, ResultType resultType, String strategy, String displayLanguage) throws CatalogException {
        List resultsList = (List)summaryAndSearchResults.two();
        int counter = 0;
        for (int i = 0; i < maxRecords && i < resultsList.size(); ++i) {
            ResultItem resultItem = (ResultItem)resultsList.get(i);
            String id = resultItem.getID();
            Element md = null;
            try {
                md = SearchController.retrieveMetadata(context, id, elementSetName, outputSchema, elementNames, typeName, resultType, strategy, displayLanguage);
                if (md == null) {
                    results.addContent((Content)new Comment(String.format("Metadata with id '%s' returned null.", id)));
                    context.warning("SearchController : Metadata not found or invalid schema : " + id);
                } else if (resultType == ResultType.RESULTS || resultType == ResultType.RESULTS_WITH_SUMMARY) {
                    results.addContent((Content)md);
                }
            }
            catch (InvalidParameterValueEx e) {
                results.addContent((Content)new Comment(e.getMessage()));
            }
            ++counter;
        }
        return counter;
    }

    private static Element applyPostProcessing(ServiceContext context, SchemaManager schemaManager, String schema, Element result, String outputSchema, ElementSetName elementSetName, ResultType resultType, String id, String displayLanguage) throws InvalidParameterValueEx {
        Path schemaDir = schemaManager.getSchemaCSWPresentDir(schema);
        NodeInfo nodeInfo = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
        Path styleSheet = schemaDir.resolve(outputSchema + "-" + (context.getService().equals("csw") ? nodeInfo.getId() : context.getService()) + "-postprocessing.xsl");
        if (Files.exists(styleSheet, new LinkOption[0])) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("lang", displayLanguage);
            params.put("displayInfo", resultType == ResultType.RESULTS_WITH_SUMMARY ? "true" : "false");
            try {
                result = Xml.transform((Element)result, (Path)styleSheet, params);
            }
            catch (Exception e) {
                context.error("Error while transforming metadata with id : " + id + " using " + styleSheet);
                context.error("  (C) StackTrace:\n" + Util.getStackTrace((Throwable)e));
                return null;
            }
        }
        return result;
    }
}

