/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fao.geonet.kernel.schema.CSWPlugin;
import org.fao.geonet.kernel.schema.HttpLink;
import org.fao.geonet.kernel.schema.SavedQuery;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class SchemaPlugin
implements CSWPlugin {
    public static final String LOGGER_NAME = "geonetwork.schema-plugin";
    public final String identifier;
    private List<SavedQuery> savedQueries = new ArrayList<SavedQuery>();
    private ImmutableSet<Namespace> allNamespaces;
    private List<String> xpathTitle;
    protected List<String> elementsToProcess = new ArrayList<String>();
    protected List<HttpLink> analyzedLinks;

    protected SchemaPlugin(String identifier, ImmutableSet<Namespace> allNamespaces) {
        this.identifier = identifier;
        this.allNamespaces = allNamespaces;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<SavedQuery> getSavedQueries() {
        return this.savedQueries;
    }

    public void setSavedQueries(List<SavedQuery> savedQueries) {
        this.savedQueries = savedQueries;
    }

    @Nullable
    public SavedQuery getSavedQuery(@Nonnull String queryKey) {
        for (SavedQuery query : this.getSavedQueries()) {
            if (!queryKey.equals(query.getId())) continue;
            return query;
        }
        return null;
    }

    public Set<Namespace> getNamespaces() {
        return this.allNamespaces;
    }

    public void setXpathTitle(List<String> xpathTitle) {
        this.xpathTitle = xpathTitle;
    }

    public List<String> getXpathTitle() {
        return this.xpathTitle;
    }

    public void setElementsToProcess(List<String> elementsToProcess) {
        this.elementsToProcess = elementsToProcess;
    }

    public void setAnalyzedLinks(List<HttpLink> analyzedLinks) {
        this.analyzedLinks = analyzedLinks;
    }

    public List<HttpLink> getAnalyzedLinks() {
        return this.analyzedLinks;
    }

    public Element processElement(Element el, String attributeName, String parsedAttributeName, String attributeValue) {
        return el;
    }
}

