/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thesaurus;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.search.KeywordsSearcher;
import org.fao.geonet.kernel.search.keyword.KeywordRelation;
import org.fao.geonet.kernel.search.keyword.KeywordSort;
import org.fao.geonet.kernel.search.keyword.SortDirection;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.jdom.Content;
import org.jdom.Element;

public class EditElement
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        ThesaurusManager thesaurusMan;
        GeonetContext gc;
        String ref = Util.getParam((Element)params, (String)"ref");
        String id = Util.getParam((Element)params, (String)"id", (String)"");
        String uri = Util.getParam((Element)params, (String)"uri", (String)"");
        String mode = Util.getParam((Element)params, (String)"mode", (String)"");
        String lang = ((IsoLanguagesMapper)context.getBean(IsoLanguagesMapper.class)).iso639_2_to_iso639_1(context.getLanguage());
        String modeType = "add";
        Element elResp = new Element("response");
        if (!id.equals("") || !uri.equals("")) {
            KeywordBean kb = null;
            if (!id.equals("")) {
                UserSession session = context.getUserSession();
                KeywordsSearcher searcher = (KeywordsSearcher)session.getProperty("search.keywords.result");
                kb = searcher.getKeywordFromResultsById(id);
            } else {
                gc = (GeonetContext)context.getHandlerContext("contextName");
                thesaurusMan = (ThesaurusManager)gc.getBean(ThesaurusManager.class);
                KeywordsSearcher searcher = new KeywordsSearcher(context, (ThesaurusFinder)thesaurusMan);
                kb = searcher.searchById(uri, ref, new String[]{lang});
            }
            elResp.addContent((Content)new Element("prefLab").setText(kb.getDefaultValue()));
            elResp.addContent((Content)new Element("definition").setText(kb.getDefaultDefinition()));
            elResp.addContent((Content)new Element("relCode").setText(kb.getRelativeCode()));
            elResp.addContent((Content)new Element("nsCode").setText(kb.getNameSpaceCode()));
            if (kb.getCoordEast() != null) {
                elResp.addContent((Content)new Element("east").setText(kb.getCoordEast()));
            }
            if (kb.getCoordWest() != null) {
                elResp.addContent((Content)new Element("west").setText(kb.getCoordWest()));
            }
            if (kb.getCoordSouth() != null) {
                elResp.addContent((Content)new Element("south").setText(kb.getCoordSouth()));
            }
            if (kb.getCoordNorth() != null) {
                elResp.addContent((Content)new Element("north").setText(kb.getCoordNorth()));
            }
            modeType = "edit";
            uri = kb.getRelativeCode();
        } else {
            elResp.addContent((Content)new Element("nsCode").setText("#"));
        }
        if (mode.equals("consult")) {
            ArrayList<KeywordRelation> reqType = new ArrayList<KeywordRelation>();
            reqType.add(KeywordRelation.BROADER);
            reqType.add(KeywordRelation.NARROWER);
            reqType.add(KeywordRelation.RELATED);
            gc = (GeonetContext)context.getHandlerContext("contextName");
            thesaurusMan = (ThesaurusManager)gc.getBean(ThesaurusManager.class);
            KeywordsSearcher searcherBNR = new KeywordsSearcher(context, (ThesaurusFinder)thesaurusMan);
            for (int i = 0; i <= reqType.size() - 1; ++i) {
                searcherBNR.searchForRelated(uri, ref, (KeywordRelation)reqType.get(i), KeywordSort.defaultLabelSorter((SortDirection)SortDirection.DESC), new String[]{lang});
                String type = reqType.get(i) == KeywordRelation.BROADER ? "narrower" : (reqType.get(i) == KeywordRelation.NARROWER ? "broader" : "related");
                Element keywordType = new Element(type);
                keywordType.addContent((Collection)searcherBNR.getResults());
                elResp.addContent((Content)keywordType);
            }
        }
        String thesaType = ref;
        thesaType = thesaType.substring(thesaType.indexOf(46) + 1, thesaType.length());
        thesaType = thesaType.substring(0, thesaType.indexOf(46));
        elResp.addContent((Content)new Element("thesaType").setText(thesaType));
        elResp.addContent((Content)new Element("thesaurus").setText(ref));
        elResp.addContent((Content)new Element("mode").setText(modeType));
        return elResp;
    }
}

