/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.password;

import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.services.MailSendingService;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.util.PasswordUtil;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class SendLink
extends MailSendingService {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String CHANGE_EMAIL_XSLT = "password-forgotten-email.xsl";
    private static String FS = File.separator;
    private Path stylePath;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.stylePath = appPath.resolve("xslt").resolve("services").resolve("account");
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String username = Util.getParam((Element)params, (String)"username");
        String template = Util.getParam((Element)params, (String)"template", (String)CHANGE_EMAIL_XSLT);
        User user = ((UserRepository)context.getBean(UserRepository.class)).findOneByUsername(username);
        if (user == null) {
            throw new UserNotFoundEx(username);
        }
        if (user.getProfile() != Profile.RegisteredUser) {
            throw new IllegalArgumentException("Only users with profile RegisteredUser can change their password using this option");
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = (SettingManager)gc.getBean(SettingManager.class);
        String adminEmail = sm.getValue("system/feedback/email");
        String thisSite = sm.getSiteName();
        SettingInfo si = (SettingInfo)context.getBean(SettingInfo.class);
        String siteURL = si.getSiteUrl() + context.getBaseUrl();
        String scrambledPassword = user.getPassword();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String todaysDate = sdf.format(cal.getTime());
        String changeKey = PasswordUtil.encode((ServiceContext)context, (String)(scrambledPassword + todaysDate));
        Element root = new Element("root");
        root.addContent((Content)new Element("username").setText(username));
        for (String email : user.getEmailAddresses()) {
            root.addContent((Content)new Element("email").setText(email));
        }
        root.addContent((Content)new Element("site").setText(thisSite));
        root.addContent((Content)new Element("siteURL").setText(siteURL));
        root.addContent((Content)new Element("changeKey").setText(changeKey));
        FilePathChecker.verify((String)template);
        Path emailXslt = this.stylePath.resolve(template);
        Element elEmail = Xml.transform((Element)root, (Path)emailXslt);
        String subject = elEmail.getChildText("subject");
        String to = elEmail.getChildText("to");
        String content = elEmail.getChildText("content");
        if (!MailUtil.sendMail((String)to, (String)subject, (String)content, null, (SettingManager)sm, (String)adminEmail, (String)"").booleanValue()) {
            throw new OperationAbortedEx("Could not send email");
        }
        return new Element("response");
    }
}

