/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.mef;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.search.IndexAndTaxonomy;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.IO;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class Import
extends NotInReadOnlyModeService {
    private static final Set<String> UUID_FIELD_LOADER = Sets.newHashSet((Object[])new String[]{"_uuid"});
    private Path stylePath;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        super.init(appPath, params);
        this.stylePath = appPath.resolve("xsl/conversion/import");
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        Element result;
        String mefFile = Util.getParam((Element)params, (String)"mefFile");
        String fileType = Util.getParam((Element)params, (String)"file_type", (String)"mef");
        Path uploadDir = context.getUploadDir();
        FilePathChecker.verify((String)mefFile);
        Path file = uploadDir.resolve(mefFile);
        List id = MEFLib.doImport((Element)params, (ServiceContext)context, (Path)file, (Path)this.stylePath);
        StringBuilder ids = new StringBuilder();
        StringBuilder uuidString = new StringBuilder();
        BooleanQuery query = new BooleanQuery();
        for (String item : id) {
            ids.append(item).append(";");
            query.add((Query)new TermQuery(new Term("_id", item)), BooleanClause.Occur.SHOULD);
        }
        ArrayList uuids = Lists.newArrayList();
        try (IndexAndTaxonomy idxTax = ((SearchManager)context.getBean(SearchManager.class)).getNewIndexReader(null);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)idxTax.indexReader);
            TopDocs search = searcher.search((Query)query, 500);
            for (ScoreDoc scoreDoc : search.scoreDocs) {
                Document doc = idxTax.indexReader.document(scoreDoc.doc, UUID_FIELD_LOADER);
                String uuid = doc.get("_uuid");
                uuids.add(uuid);
                uuidString.append(uuid).append(';');
            }
        }
        IO.deleteFile((Path)file, (boolean)false, (String)"geonetwork.mef");
        if (context.getService().equals("mef.import")) {
            result = new Element("id");
            result.setText(ids.toString());
            result.setAttribute("uuid", uuidString.toString());
        } else {
            result = new Element("response");
            if (fileType.equals("single") && id.size() == 1) {
                result.addContent((Content)new Element("id").setText((String)id.get(0) + ""));
                result.addContent((Content)new Element("uuid").setText((String)uuids.get(0) + ""));
            } else {
                result.addContent((Content)new Element("records").setText(id.size() + ""));
            }
        }
        return result;
    }
}

