/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.services.util.SearchDefaults;
import org.jdom.Content;
import org.jdom.Element;

public class Search
implements Service {
    private ServiceConfig _config;

    public void init(Path appPath, ServiceConfig config) throws Exception {
        this._config = config;
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        SelectionManager oldSelection;
        UserSession session;
        Object oldSearcher;
        String[] bounds;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
        Element elData = SearchDefaults.getDefaultSearch((ServiceContext)context, (Element)params);
        Element bbox = elData.getChild("bbox");
        Element westBL = elData.getChild("westBL");
        Element southBL = elData.getChild("southBL");
        Element eastBL = elData.getChild("eastBL");
        Element northBL = elData.getChild("northBL");
        if (bbox != null && westBL == null && southBL == null && eastBL == null && northBL == null && (bounds = bbox.getText().split(",")).length == 4) {
            elData.addContent((Content)new Element("westBL").addContent(bounds[0]));
            elData.addContent((Content)new Element("southBL").addContent(bounds[1]));
            elData.addContent((Content)new Element("eastBL").addContent(bounds[2]));
            elData.addContent((Content)new Element("northBL").addContent(bounds[3]));
        }
        if ((oldSearcher = (session = context.getUserSession()).getProperty("search.result")) != null && oldSearcher instanceof LuceneSearcher) {
            ((LuceneSearcher)oldSearcher).close();
        }
        if ((oldSelection = (SelectionManager)session.getProperty("selected.result")) != null) {
            oldSelection.close();
        }
        MetaSearcher searcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");
        searcher.search(context, elData, this._config);
        session.setProperty("search.result", (Object)searcher);
        session.removeProperty("search.request");
        context.info("Getting summary");
        return searcher.getSummary();
    }
}

