/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.userfeedback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.userfeedback.UserFeedbackDTO;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.userfeedback.Rating;
import org.fao.geonet.domain.userfeedback.RatingCriteria;
import org.fao.geonet.domain.userfeedback.UserFeedback;
import org.fao.geonet.repository.userfeedback.RatingCriteriaRepository;
import org.fao.geonet.util.XslUtil;

public class UserFeedbackUtils {
    public static UserFeedback convertFromDto(UserFeedbackDTO inputDto, User author) {
        RatingCriteria criteria;
        UserFeedback userfeedback = new UserFeedback();
        if (inputDto.getUuid() == null || inputDto.getUuid().equals("")) {
            userfeedback.setUuid(UUID.randomUUID().toString());
        } else {
            userfeedback.setUuid(inputDto.getUuid());
        }
        userfeedback.setCommentText(inputDto.getComment());
        ArrayList<Rating> ratingList = null;
        ratingList = new ArrayList<Rating>();
        userfeedback.setDetailedRatingList(ratingList);
        boolean avg = false;
        boolean avgCount = false;
        RatingCriteriaRepository ratingCriteriaRepository = (RatingCriteriaRepository)ApplicationContextHolder.get().getBean(RatingCriteriaRepository.class);
        List criteriaList = ratingCriteriaRepository.findAll();
        if (inputDto.getRating() != null) {
            for (Integer criteriaId : inputDto.getRating().keySet()) {
                RatingCriteria criteria2 = ratingCriteriaRepository.findById(criteriaId);
                if (criteria2 == null) continue;
                Rating rating = new Rating();
                rating.setUserfeedback(userfeedback);
                rating.setCategory(criteria2);
                rating.setRating(inputDto.getRating().get(criteriaId));
                ratingList.add(rating);
            }
        }
        if (inputDto.getRatingAVG() != null && (criteria = ratingCriteriaRepository.findById(RatingCriteria.AVERAGE_ID)) != null) {
            Rating rating = new Rating();
            rating.setUserfeedback(userfeedback);
            rating.setCategory(criteria);
            rating.setRating(inputDto.getRatingAVG());
            ratingList.add(rating);
        }
        Metadata metadata = new Metadata();
        metadata.setUuid(inputDto.getMetadataUUID());
        userfeedback.setMetadata(metadata);
        if (inputDto.getParentUuid() != null) {
            UserFeedback parent = new UserFeedback();
            parent.setUuid(inputDto.getParentUuid());
            userfeedback.setParent(parent);
        }
        userfeedback.setCreationDate(new ISODate(System.currentTimeMillis()).toDate());
        if (author != null) {
            userfeedback.setAuthorId(author);
            userfeedback.setAuthorName(author.getName() + " " + author.getSurname());
            userfeedback.setAuthorEmail(author.getEmail());
            userfeedback.setAuthorOrganization(author.getOrganisation());
            userfeedback.setStatus(UserFeedback.UserRatingStatus.PUBLISHED);
            userfeedback.setAuthorPrivacy(1);
        } else {
            userfeedback.setAuthorId(null);
            userfeedback.setAuthorName(inputDto.getAuthorName());
            userfeedback.setAuthorEmail(inputDto.getAuthorEmail());
            userfeedback.setAuthorOrganization(inputDto.getAuthorOrganization());
            userfeedback.setStatus(UserFeedback.UserRatingStatus.WAITING_FOR_APPROVAL);
            if (inputDto.isOptionPrivacy()) {
                userfeedback.setAuthorPrivacy(1);
            } else {
                userfeedback.setAuthorPrivacy(0);
            }
        }
        userfeedback.setKeywords(null);
        userfeedback.setApprover(null);
        return userfeedback;
    }

    public static UserFeedbackDTO convertToDto(UserFeedback input) {
        UserFeedbackDTO userfeedbackDto = new UserFeedbackDTO();
        userfeedbackDto.setUuid(input.getUuid());
        userfeedbackDto.setComment(input.getCommentText());
        userfeedbackDto.setMetadataUUID(input.getMetadata().getUuid());
        userfeedbackDto.setDate(new ISODate(input.getCreationDate().getTime()).getDateAndTime());
        if (input.getAuthorId() != null) {
            userfeedbackDto.setAuthorUserId(input.getAuthorId().getId());
        } else {
            userfeedbackDto.setAuthorUserId(0);
        }
        if (input.getParent() != null) {
            userfeedbackDto.setParentUuid(input.getParent().getUuid());
        }
        List ratingList = input.getDetailedRatingList();
        HashMap<Integer, Integer> ratings = new HashMap<Integer, Integer>();
        for (Rating rating : ratingList) {
            Integer id = rating.getCategory().getId();
            if (id == RatingCriteria.AVERAGE_ID) {
                userfeedbackDto.setRatingAVG(rating.getRating());
                continue;
            }
            ratings.put(id, rating.getRating());
        }
        userfeedbackDto.setRating(ratings);
        if (input.getAuthorPrivacy() == 0) {
            userfeedbackDto.setAuthorName("Anonymous");
            userfeedbackDto.setAuthorOrganization("");
        } else {
            userfeedbackDto.setAuthorName(input.getAuthorName());
            userfeedbackDto.setAuthorEmail(input.getAuthorEmail());
            userfeedbackDto.setAuthorOrganization(input.getAuthorOrganization());
        }
        if (input.getStatus().equals((Object)UserFeedback.UserRatingStatus.PUBLISHED)) {
            userfeedbackDto.setPublished(true);
            if (input.getApprover() != null) {
                userfeedbackDto.setApproverName(input.getApprover().getName());
            }
        } else {
            userfeedbackDto.setPublished(false);
        }
        userfeedbackDto.setMetadataTitle(XslUtil.getIndexField(null, (Object)userfeedbackDto.getMetadataUUID(), (Object)"title", (Object)""));
        return userfeedbackDto;
    }

    public RatingAverage getAverage(List<UserFeedback> list) {
        int ratingCount = 0;
        ISODate maxDate = null;
        RatingAverage v = null;
        if (list.size() > 0) {
            HashMap<Integer, Integer> ratingAverages = new HashMap<Integer, Integer>();
            RatingCriteriaRepository criteriaRepository = (RatingCriteriaRepository)ApplicationContextHolder.get().getBean(RatingCriteriaRepository.class);
            List criteriaList = criteriaRepository.findAll();
            criteriaList.forEach(e -> ratingAverages.put(e.getId(), 0));
            for (UserFeedback userFeedback : list) {
                if (maxDate == null || userFeedback.getCreationDate() != null && userFeedback.getCreationDate().after(maxDate.toDate())) {
                    maxDate = new ISODate(userFeedback.getCreationDate().getTime());
                }
                if (userFeedback.getDetailedRatingList() == null || userFeedback.getDetailedRatingList().size() <= 0) continue;
                for (Rating rating : userFeedback.getDetailedRatingList()) {
                    Integer criteriaId = rating.getCategory().getId();
                    Integer value = rating.getRating();
                    if (value != null && value > 0 && ratingAverages.get(criteriaId) != null) {
                        ratingAverages.put(criteriaId, ((Integer)ratingAverages.get(criteriaId) + value) / 2);
                    }
                    if (criteriaId != RatingCriteria.AVERAGE_ID) continue;
                    ++ratingCount;
                }
            }
            v = new RatingAverage(ratingAverages, list.size(), maxDate.getDateAndTime(), ratingCount);
        } else {
            v = new RatingAverage(new HashMap<Integer, Integer>(), 0, null, ratingCount);
        }
        return v;
    }

    public class RatingAverage {
        private int ratingCount;
        private Map<Integer, Integer> ratingAverages = new HashMap<Integer, Integer>();
        private int userfeedbackCount;
        private String lastComment;

        public RatingAverage(Map<Integer, Integer> ratingAverages, int userfeedbackCount, String lastComment, int ratingCount) {
            this.ratingAverages = ratingAverages;
            this.userfeedbackCount = userfeedbackCount;
            this.lastComment = lastComment;
            this.ratingCount = ratingCount;
        }

        public String getLastComment() {
            return this.lastComment;
        }

        public Map<Integer, Integer> getRatingAverages() {
            return this.ratingAverages;
        }

        public int getUserfeedbackCount() {
            return this.userfeedbackCount;
        }

        public void setLastComment(String lastComment) {
            this.lastComment = lastComment;
        }

        public void setRatingAverages(Map<Integer, Integer> ratingAverages) {
            this.ratingAverages = ratingAverages;
        }

        public void setUserfeedbackCount(int userfeedbackCount) {
            this.userfeedbackCount = userfeedbackCount;
        }

        public int getRatingCount() {
            return this.ratingCount;
        }

        public void setRatingCount(int ratingCount) {
            this.ratingCount = ratingCount;
        }
    }
}

