/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.sources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.Source_;
import org.fao.geonet.guiapi.search.XsltResponseWriter;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.resources.Resources;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/sources", "/{portal}/api/0.1/sources"})
@Api(value="sources", tags={"sources"}, description="Source catalogue operations")
@Controller(value="sources")
public class SourcesApi {
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    LanguageRepository langRepository;

    @ApiOperation(value="Get all sources", notes="Sources are the local catalogue, subportal, external catalogue (when importing MEF files) or harvesters.", nickname="getSources")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of source catalogues.")})
    @ResponseBody
    public List<Source> getSources(@ApiParam(value="Group owner of the source (only applies to subportal).") @RequestParam(value="group", required=false) Integer group) throws Exception {
        if (group != null) {
            return this.sourceRepository.findByGroupOwner(group.intValue());
        }
        return this.sourceRepository.findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Source_.name}));
    }

    @ApiOperation(value="Get portal list", notes="List all subportal available.", nickname="getSubPortal")
    @RequestMapping(produces={"text/html"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of portals.")})
    @ResponseBody
    public void getSubPortal(@ApiIgnore HttpServletResponse response) throws Exception {
        List sources = this.sourceRepository.findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Source_.name}));
        Element sourcesList = new Element("sources");
        sources.stream().map(GeonetEntity::asXml).forEach(arg_0 -> ((Element)sourcesList).addContent(arg_0));
        response.setContentType("text/html");
        response.getWriter().write(new XsltResponseWriter("portal").withJson("catalog/locales/en-core.json").withJson("catalog/locales/en-search.json").withXml(sourcesList).withParam("cssClass", "gn-portal").withXsl("xslt/ui-search/portal-list.xsl").asHtml());
    }

    @ApiOperation(value="Add a source", notes="", nickname="addSource")
    @RequestMapping(method={RequestMethod.PUT}, produces={"text/plain"})
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Source created."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    public ResponseEntity addSource(@ApiParam(name="source") @RequestBody Source source, @ApiIgnore HttpServletRequest request) {
        Source existing = (Source)this.sourceRepository.findOne((Serializable)((Object)source.getUuid()));
        if (existing != null) {
            throw new IllegalArgumentException(String.format("A source with uuid '%s' already exist", source.getUuid()));
        }
        existing = this.sourceRepository.findOneByName(source.getName());
        if (existing != null) {
            throw new IllegalArgumentException(String.format("A source with name '%s' already exist", source.getName()));
        }
        List allLanguages = this.langRepository.findAll();
        Map labelTranslations = source.getLabelTranslations();
        for (Language l : allLanguages) {
            String label = (String)labelTranslations.get(l.getId());
            source.getLabelTranslations().put(l.getId(), label == null ? source.getName() : label);
        }
        Source sourceCreated = (Source)this.sourceRepository.save((Object)source);
        this.copySourceLogo(source, request);
        return new ResponseEntity((Object)sourceCreated.getUuid(), HttpStatus.CREATED);
    }

    private void copySourceLogo(Source source, HttpServletRequest request) {
        if (source.getLogo() != null) {
            ServiceContext context = ApiUtils.createServiceContext(request);
            ((Resources)context.getBean(Resources.class)).copyLogo(context, "images" + File.separator + "harvesting" + File.separator + source.getLogo(), source.getUuid());
        }
    }

    @ApiOperation(value="Update a source", notes="", nickname="updateSource")
    @RequestMapping(value={"/{sourceIdentifier}"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Source updated."), @ApiResponse(code=404, message="Source not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    public ResponseEntity updateSource(@ApiParam(value="Source identifier", required=true) @PathVariable String sourceIdentifier, @ApiParam(name="source") @RequestBody Source source, @ApiIgnore HttpServletRequest request) throws Exception {
        Source existingSource = (Source)this.sourceRepository.findOne((Serializable)((Object)sourceIdentifier));
        if (existingSource == null) {
            throw new ResourceNotFoundException(String.format("Source with uuid '%s' does not exist.", sourceIdentifier));
        }
        this.updateSource(sourceIdentifier, source, this.sourceRepository);
        this.copySourceLogo(source, request);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Remove a source", notes="", nickname="deleteSource")
    @RequestMapping(value={"/{sourceIdentifier}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=201, message="Source deleted."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    public ResponseEntity deleteSource(@ApiParam(value="Source identifier", required=true) @PathVariable String sourceIdentifier, @ApiIgnore HttpServletRequest request) throws ResourceNotFoundException {
        Source existingSource = (Source)this.sourceRepository.findOne((Serializable)((Object)sourceIdentifier));
        if (existingSource != null) {
            if (existingSource.getLogo() != null) {
                ServiceContext context = ApiUtils.createServiceContext(request);
                Resources resources = (Resources)context.getBean(Resources.class);
                Path logoDir = resources.locateLogosDir(context);
                try {
                    resources.deleteImageIfExists(existingSource.getUuid() + "." + FilenameUtils.getExtension((String)existingSource.getLogo()), logoDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            throw new ResourceNotFoundException(String.format("Source with uuid '%s' does not exist.", sourceIdentifier));
        }
        this.sourceRepository.delete((Object)existingSource);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private void updateSource(String sourceIdentifier, Source source, SourceRepository sourceRepository) {
        sourceRepository.update((Serializable)((Object)sourceIdentifier), entity -> {
            entity.setName(source.getName());
            entity.setUuid(source.getUuid());
            entity.setType(source.getType());
            entity.setFilter(source.getFilter());
            entity.setGroupOwner(source.getGroupOwner());
            entity.setServiceRecord(source.getServiceRecord());
            entity.setUiConfig(source.getUiConfig());
            entity.setLogo(source.getLogo());
            Map labelTranslations = source.getLabelTranslations();
            if (labelTranslations != null) {
                entity.getLabelTranslations().clear();
                entity.getLabelTranslations().putAll(labelTranslations);
            }
        });
    }
}

