/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import groovy.lang.Closure;
import groovy.util.slurpersupport.GPathResult;
import java.io.IOException;
import java.util.List;
import org.fao.geonet.api.records.formatters.groovy.HandlerResult;
import org.fao.geonet.api.records.formatters.groovy.Logging;
import org.fao.geonet.api.records.formatters.groovy.Selectable;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;

public abstract class Handler
extends Selectable
implements Comparable<Handler> {
    private Closure handlerFunction;
    private boolean group = false;

    public Handler(int priority, Closure handlerFunction) {
        super(priority);
        this.handlerFunction = handlerFunction;
    }

    public static void processResult(Object result, StringBuilder resultantXml) throws IOException {
        if (result == null) {
            return;
        }
        resultantXml.append(result);
    }

    protected static void createPath(GPathResult element, StringBuilder path) {
        Handler.createPath(element, path, 0);
    }

    protected static void createPath(GPathResult element, StringBuilder path, int depth) {
        if (element != null) {
            if (depth > 10) {
                path.append("... >");
            } else if (element.parent() != element) {
                Handler.createPath(element.parent(), path, depth + 1);
                path.append(">");
            }
            path.append(element.name());
        }
    }

    @Override
    public int compareTo(Handler o) {
        return Integer.compare(o.priority, this.priority);
    }

    public HandlerResult handle(TransformationContext context, List<GPathResult> elem, StringBuilder resultantXml) throws IOException {
        Object result;
        Logging.debug("Executing handler '%2$s' on element %1$s.", elem, new Object[]{this});
        GPathResult elParam = null;
        if (this.group) {
            elParam = elem;
        } else if (!elem.isEmpty()) {
            elParam = elem.get(0);
        }
        int maximumNumberOfParameters = this.handlerFunction.getMaximumNumberOfParameters();
        switch (maximumNumberOfParameters) {
            case 0: {
                result = this.handlerFunction.call();
                break;
            }
            case 1: {
                result = this.handlerFunction.call((Object)elParam);
                break;
            }
            case 2: {
                result = this.handlerFunction.call(new Object[]{elParam, context});
                break;
            }
            default: {
                throw new IllegalStateException("Too many arguments in handler '" + this + "' there are: " + maximumNumberOfParameters);
            }
        }
        Handler.processResult(result, resultantXml);
        return new HandlerResult();
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    @Override
    public final String extraToString() {
        return this.handlerExtraToString();
    }

    protected abstract String handlerExtraToString();
}

