/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import org.fao.geonet.api.records.formatters.cache.Key;
import org.fao.geonet.api.records.formatters.cache.PersistentStore;
import org.fao.geonet.api.records.formatters.cache.StoreInfo;
import org.fao.geonet.api.records.formatters.cache.StoreInfoAndData;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;

public class FilesystemStore
implements PersistentStore {
    public static final String WITHHELD_MD_DIRNAME = "withheld_md";
    public static final String FULL_MD_NAME = "full_md";
    private static final String BASE_CACHE_DIR = "formatter-cache";
    private static final String INFO_TABLE = "info";
    private static final String KEY = "keyhash";
    private static final String CHANGE_DATE = "changedate";
    private static final String PUBLISHED = "published";
    private static final String PATH = "path";
    private static final String STATS_TABLE = "stats";
    private static final String NAME = "name";
    private static final String CURRENT_SIZE = "currentsize";
    private static final String VALUE = "value";
    public static final String QUERY_SETCURRENT_SIZE = "MERGE INTO stats (name, value) VALUES ('currentsize', ?)";
    public static final String QUERY_GETCURRENT_SIZE = "SELECT value FROM stats WHERE name = 'currentsize'";
    private static final String QUERY_GET_INFO = "SELECT * FROM info WHERE keyhash=?";
    private static final String QUERY_GET_INFO_FOR_RESIZE = "SELECT keyhash,path FROM info ORDER BY changedate ASC";
    private static final String QUERY_PUT = "MERGE INTO info (keyhash,changedate,published,path) VALUES (?,?,?, ?)";
    private static final String QUERY_REMOVE = "DELETE FROM info WHERE keyhash=?";
    private static final String QUERY_CLEAR_INFO = "DELETE FROM info";
    private static final String QUERY_CLEAR_STATS = "DELETE FROM stats";
    @VisibleForTesting
    Connection metadataDb;
    @Autowired
    private GeonetworkDataDirectory geonetworkDataDir;
    private boolean testing = false;
    private volatile long maxSizeB = 10000L;
    private volatile long currentSize = 0L;
    private volatile boolean initialized = false;

    private synchronized void init() throws SQLException {
        if (!this.initialized) {
            try {
                Class.forName("org.h2.Driver");
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
            Object[] initSql = new String[]{"CREATE SCHEMA IF NOT EXISTS info", "CREATE TABLE IF NOT EXISTS info(keyhash INT PRIMARY KEY, changedate BIGINT NOT NULL, published BOOL NOT NULL, path CLOB  NOT NULL)", "CREATE TABLE IF NOT EXISTS stats (name VARCHAR(64) PRIMARY KEY, value VARCHAR(32) NOT NULL)"};
            String init = ";INIT=" + Joiner.on((String)"\\;").join(initSql) + ";DB_CLOSE_DELAY=-1";
            String dbPath = this.testing ? "mem:" + UUID.randomUUID() : this.getBaseCacheDir().resolve("info-store").toString();
            this.metadataDb = DriverManager.getConnection("jdbc:h2:" + dbPath + init, "fsStore", "");
            try (Statement statement = this.metadataDb.createStatement();
                 ResultSet rs = statement.executeQuery(QUERY_GETCURRENT_SIZE);){
                if (rs.next()) {
                    this.currentSize = Long.parseLong(rs.getString(1));
                }
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FilesystemStore.this.close();
                    }
                    catch (ClassNotFoundException | SQLException e) {
                        Log.error((String)"geonetwork.formatter", (Object)"Error shutting down FilesystemStore Database", (Throwable)e);
                    }
                }
            }));
            this.initialized = true;
        }
    }

    @PreDestroy
    synchronized void close() throws ClassNotFoundException, SQLException {
        Log.info((String)"geonetwork.formatter", (Object)"Stopping the FileSystemStore");
        if (this.metadataDb != null) {
            this.metadataDb.close();
        }
    }

    @Override
    public synchronized StoreInfoAndData get(@Nonnull Key key) throws IOException, SQLException {
        this.init();
        StoreInfo info = this.getInfo(key);
        if (info == null) {
            return null;
        }
        byte[] data = Files.readAllBytes(this.getPrivatePath(key));
        return new StoreInfoAndData(info, data);
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized StoreInfo getInfo(@Nonnull Key key) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized void put(@Nonnull Key key, @Nonnull StoreInfoAndData data) throws IOException, SQLException {
        this.init();
        this.resizeIfRequired(key, data);
        Path privatePath = this.getPrivatePath(key);
        if (Files.exists(privatePath, new LinkOption[0])) {
            this.currentSize -= Files.size(privatePath);
        }
        Files.createDirectories(privatePath.getParent(), new FileAttribute[0]);
        Files.write(privatePath, data.data, new OpenOption[0]);
        this.currentSize += (long)data.data.length;
        this.updateDbCurrentSize();
        Path publicPath = this.getPublicPath(key);
        Files.deleteIfExists(publicPath);
        if (data.isPublished() && key.hideWithheld) {
            Files.createDirectories(publicPath.getParent(), new FileAttribute[0]);
            try {
                Files.createLink(publicPath, privatePath);
            }
            catch (SecurityException | UnsupportedOperationException e) {
                Files.copy(privatePath, publicPath, new CopyOption[0]);
            }
        }
        try (PreparedStatement statement = this.metadataDb.prepareStatement(QUERY_PUT);){
            statement.setInt(1, key.hashCode());
            statement.setLong(2, data.getChangeDate());
            statement.setBoolean(3, data.isPublished());
            statement.setString(4, privatePath.toUri().toString());
            statement.execute();
        }
    }

    private void updateDbCurrentSize() throws SQLException {
        try (PreparedStatement statement = this.metadataDb.prepareStatement(QUERY_SETCURRENT_SIZE);){
            statement.setString(1, String.valueOf(this.currentSize));
            statement.execute();
        }
    }

    private void resizeIfRequired(Key key, StoreInfoAndData data) throws IOException, SQLException {
        if (this.currentSize + (long)data.data.length > this.maxSizeB) {
            Path privatePath = this.getPrivatePath(key);
            if (Files.exists(privatePath, new LinkOption[0])) {
                long fileSize = Files.size(privatePath);
                if (this.currentSize - fileSize + (long)data.data.length > this.maxSizeB) {
                    this.resize();
                }
            } else {
                this.resize();
            }
        }
    }

    private void resize() throws SQLException, IOException {
        int targetSize = (int)(this.maxSizeB / 2L);
        Log.warning((String)"geonetwork.formatter", (Object)("Resizing Formatter cache.  Required to reduce size by " + targetSize));
        long startTime = System.currentTimeMillis();
        try (Statement statement = this.metadataDb.createStatement();
             ResultSet resultSet = statement.executeQuery(QUERY_GET_INFO_FOR_RESIZE);){
            while (this.currentSize > (long)targetSize && resultSet.next()) {
                Path path = IO.toPath((URI)new URI(resultSet.getString(PATH)));
                this.doRemove(path, resultSet.getInt(KEY), false);
            }
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        Log.warning((String)"geonetwork.formatter", (Object)("Resize took " + (System.currentTimeMillis() - startTime) + "ms to complete"));
    }

    @Override
    @Nullable
    public byte[] getPublished(@Nonnull Key key) throws IOException {
        try {
            this.init();
        }
        catch (SQLException e) {
            throw new Error(e);
        }
        Path publicPath = this.getPublicPath(key);
        if (Files.exists(publicPath, new LinkOption[0])) {
            return Files.readAllBytes(publicPath);
        }
        return null;
    }

    @Override
    public synchronized void remove(@Nonnull Key key) throws IOException, SQLException {
        this.init();
        Path path = this.getPrivatePath(key);
        int keyHashCode = key.hashCode();
        this.doRemove(path, keyHashCode, true);
    }

    @Override
    public void setPublished(int metadataId, final boolean published) throws IOException {
        Path metadataDir = Lib.resource.getMetadataDir(this.getBaseCacheDir().resolve("private"), String.valueOf(metadataId));
        if (Files.exists(metadataDir, new LinkOption[0])) {
            Files.walkFileTree(metadataDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.getFileName().toString().equals(FilesystemStore.FULL_MD_NAME)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path privatePath, BasicFileAttributes attrs) throws IOException {
                    Path publicPath = FilesystemStore.this.toPublicPath(privatePath);
                    if (published) {
                        if (!Files.exists(publicPath, new LinkOption[0])) {
                            if (!Files.exists(publicPath.getParent(), new LinkOption[0])) {
                                Files.createDirectories(publicPath.getParent(), new FileAttribute[0]);
                            }
                            Files.createLink(publicPath, privatePath);
                        }
                    } else {
                        Files.deleteIfExists(publicPath);
                    }
                    return super.visitFile(privatePath, attrs);
                }
            });
        }
    }

    @Override
    public void clear() throws SQLException, IOException {
        this.init();
        try (Statement statement = this.metadataDb.createStatement();){
            statement.execute(QUERY_CLEAR_INFO);
            statement.execute(QUERY_CLEAR_STATS);
            this.currentSize = 0L;
            Files.walkFileTree(this.getBaseCacheDir(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return super.visitFile(file, attrs);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRemove(Path privatePath, int keyHashCode, boolean updateDbCurrentSize) throws IOException, SQLException {
        try {
            if (!Files.exists(privatePath, new LinkOption[0])) return;
            this.currentSize -= Files.size(privatePath);
            Files.delete(privatePath);
            return;
        }
        finally {
            try {
                Path publicPath = this.toPublicPath(privatePath);
                Files.deleteIfExists(publicPath);
            }
            finally {
                try (PreparedStatement statement = this.metadataDb.prepareStatement(QUERY_REMOVE);){
                    statement.setInt(1, keyHashCode);
                    statement.execute();
                }
                finally {
                    if (updateDbCurrentSize) {
                        this.updateDbCurrentSize();
                    }
                }
            }
        }
    }

    private Path toPublicPath(Path privatePath) {
        Path relativePrivate = this.getBaseCacheDir().resolve("private").relativize(privatePath);
        return this.getBaseCacheDir().resolve("public").resolve(relativePrivate);
    }

    public void setGeonetworkDataDir(GeonetworkDataDirectory geonetworkDataDir) {
        this.geonetworkDataDir = geonetworkDataDir;
    }

    public Path getPrivatePath(Key key) {
        return this.getCacheFile(key, false);
    }

    public Path getPublicPath(Key key) {
        return this.getCacheFile(key, true);
    }

    private Path getCacheFile(Key key, boolean isPublicCache) {
        String accessDir = isPublicCache ? "public" : "private";
        String sMdId = String.valueOf(key.mdId);
        Path metadataDir = Lib.resource.getMetadataDir(this.getBaseCacheDir().resolve(accessDir), sMdId);
        String hidden = key.hideWithheld ? WITHHELD_MD_DIRNAME : FULL_MD_NAME;
        return metadataDir.resolve(key.formatterId).resolve(key.lang).resolve(hidden).resolve(key.hashCode() + "." + key.formatType.name());
    }

    private Path getBaseCacheDir() {
        return this.geonetworkDataDir.getHtmlCacheDir().resolve(BASE_CACHE_DIR);
    }

    public void setMaxSizeKb(long maxSize) {
        this.maxSizeB = maxSize * 1024L;
    }

    public void setMaxSizeMb(int maxSize) {
        this.setMaxSizeKb((long)maxSize * 1024L);
    }

    public void setMaxSizeGb(int maxSize) {
        this.setMaxSizeMb(maxSize * 1024);
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }
}

