/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.XslProcessUtils;
import org.fao.geonet.api.processing.report.XsltMetadataProcessingReport;
import org.fao.geonet.events.history.RecordProcessingChangeEvent;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.MetadataIndexerProcessor;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/processes", "/{portal}/api/0.1/processes"})
@Api(value="processes", tags={"processes"}, description="Processing operations")
@Controller(value="xslprocess")
@ReadWriteController
public class XslProcessApi {
    @Autowired
    DataManager dataMan;
    @Autowired
    SchemaManager schemaMan;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Preview process result applied to one or more records", nickname="previewProcessRecordsUsingXslt", notes="Preview result of a process applied to metadata records with an XSL transformation declared in the metadata schema (See the process folder). Parameters sent to the service are forwarded to XSL process. Append mode has 2 limitations. First, it only support a set of records in the same schema. Secondly, it does not propagate URL parameters. This mode is mainly used to create custom reports based on metadata records content.If process name ends with '.csv', the XSL process output a text document which is returned. When errors occur during processing, the processing report is returned in JSON format.")
    @RequestMapping(value={"/{process}"}, method={RequestMethod.GET}, consumes={"text/html", "*/*"}, produces={"*/*"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Processed records."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    public Object previewProcessRecords(@ApiParam(value="Process identifier") @PathVariable String process, @ApiParam(value="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="Append documents before processing", required=false, example="false") @RequestParam(required=false, defaultValue="false") boolean appendFirst, @ApiIgnore HttpSession httpSession, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws IllegalArgumentException {
        UserSession session = ApiUtils.getUserSession(httpSession);
        XsltMetadataProcessingReport xslProcessingReport = new XsltMetadataProcessingReport(process);
        Element preview = new Element("preview");
        StringBuffer output = new StringBuffer();
        boolean isText = process.endsWith(".csv");
        response.setHeader("Content-Type", isText ? "text/plain" : "application/xml");
        try {
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
            String siteURL = request.getRequestURL().toString() + "?" + request.getQueryString();
            Element mergedDocuments = new Element("records");
            String schema = null;
            for (String uuid : records) {
                String id = this.dataMan.getMetadataId(uuid);
                Log.info((String)"org.fao.geonet.services.metadata", (Object)("Processing metadata for preview with id:" + id));
                if (appendFirst) {
                    String currentSchema = this.dataMan.getMetadataSchema(id);
                    if (schema != null && !currentSchema.equals(schema)) {
                        throw new IllegalArgumentException(String.format("When using append mode, process preview cannot process records with different schemas. Record with uuid '%s' as schema '%s'. Select only records in the same schema (ie. '%s')", uuid, currentSchema, schema));
                    }
                    schema = currentSchema;
                    mergedDocuments.addContent((Content)this.dataMan.getMetadata(id));
                    continue;
                }
                if (isText) {
                    output.append(XslProcessUtils.processAsText(ApiUtils.createServiceContext(request), id, process, false, xslProcessingReport, siteURL, request.getParameterMap()));
                    continue;
                }
                Element record = XslProcessUtils.process(ApiUtils.createServiceContext(request), id, process, false, false, false, xslProcessingReport, siteURL, request.getParameterMap());
                if (record == null) continue;
                preview.addContent(record.detach());
            }
            if (appendFirst) {
                Path xslProcessing = this.schemaMan.getSchemaDir(schema).resolve("process").resolve(process + ".xsl");
                if (process.endsWith(".csv")) {
                    StringWriter sw = new StringWriter();
                    Xml.transform((Element)mergedDocuments, (Path)xslProcessing, (Result)new StreamResult(sw), null);
                    String string = sw.toString();
                    return string;
                }
                Element element = Xml.transform((Element)mergedDocuments, (Path)xslProcessing);
                return element;
            }
        }
        catch (Exception exception) {
            xslProcessingReport.addError(exception);
        }
        finally {
            xslProcessingReport.close();
        }
        if (xslProcessingReport.getErrors().size() > 0) {
            response.setHeader("Content-Type", "application/json");
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writeValueAsString((Object)xslProcessingReport);
            }
            catch (JsonProcessingException errorReportException) {
                return String.format("Failed to generate error report due to '%s'.", errorReportException.getMessage().toString());
            }
        }
        return isText ? output.toString() : preview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Apply a process to one or more records", nickname="processRecordsUsingXslt", notes="Process a metadata with an XSL transformation declared in the metadata schema (See the process folder). Parameters sent to the service are forwarded to XSL process.")
    @RequestMapping(value={"/{process}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=201, message="Report about processed records."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    public XsltMetadataProcessingReport processRecords(@ApiParam(value="Process identifier") @PathVariable String process, @ApiParam(value="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="If true updates the DateStamp (or equivalent in standards different to ISO 19139) field in the metadata with the current timestamp", required=false, defaultValue="true") @RequestParam(required=false, defaultValue="true") boolean updateDateStamp, @ApiParam(value="Index after processing", required=false, example="false") @RequestParam(required=false, defaultValue="true") boolean index, @ApiIgnore HttpSession httpSession, @ApiIgnore HttpServletRequest request) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        try (XsltMetadataProcessingReport xslProcessingReport = new XsltMetadataProcessingReport(process);){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
            UserSession userSession = ApiUtils.getUserSession(httpSession);
            String siteURL = request.getRequestURL().toString() + "?" + request.getQueryString();
            xslProcessingReport.setTotalRecords(records.size());
            BatchXslMetadataReindexer m = new BatchXslMetadataReindexer(ApiUtils.createServiceContext(request), this.dataMan, records, process, httpSession, siteURL, xslProcessingReport, request, index, updateDateStamp, userSession.getUserIdAsInt());
            m.process();
        }
        return xslProcessingReport;
    }

    static final class BatchXslMetadataReindexer
    extends MetadataIndexerProcessor {
        private final boolean index;
        private final boolean updateDateStamp;
        Set<String> records;
        String process;
        String siteURL;
        HttpSession session;
        XsltMetadataProcessingReport xslProcessingReport;
        HttpServletRequest request;
        ServiceContext context;
        int userId;

        public BatchXslMetadataReindexer(ServiceContext context, DataManager dm, Set<String> records, String process, HttpSession session, String siteURL, XsltMetadataProcessingReport xslProcessingReport, HttpServletRequest request, boolean index, boolean updateDateStamp, int userId) {
            super(dm);
            this.records = records;
            this.process = process;
            this.session = session;
            this.index = index;
            this.updateDateStamp = updateDateStamp;
            this.siteURL = siteURL;
            this.request = request;
            this.xslProcessingReport = xslProcessingReport;
            this.context = context;
            this.userId = userId;
        }

        public void process() throws Exception {
            DataManager dataMan = (DataManager)this.context.getBean(DataManager.class);
            IMetadataUtils metadataUtils = (IMetadataUtils)this.context.getBean(IMetadataUtils.class);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            for (String uuid : this.records) {
                List idList = metadataUtils.findAllIdsBy(MetadataSpecs.hasMetadataUuid((String)uuid));
                if (idList.size() > 1) {
                    this.xslProcessingReport.setTotalRecords(this.xslProcessingReport.getNumberOfRecords() + 1);
                }
                for (Integer id : idList) {
                    Log.info((String)"org.fao.geonet.services.metadata", (Object)("Processing metadata with id:" + id));
                    Element beforeMetadata = dataMan.getMetadata(this.context, String.valueOf(id), false, false, false);
                    XslProcessUtils.process(this.context, String.valueOf(id), this.process, true, this.index, this.updateDateStamp, this.xslProcessingReport, this.siteURL, this.request.getParameterMap());
                    Element afterMetadata = dataMan.getMetadata(this.context, String.valueOf(id), false, false, false);
                    XMLOutputter outp = new XMLOutputter();
                    String xmlAfter = outp.outputString(afterMetadata);
                    String xmlBefore = outp.outputString(beforeMetadata);
                    new RecordProcessingChangeEvent(id, Integer.valueOf(this.userId), xmlBefore, xmlAfter, this.process).publish((ApplicationContext)appContext);
                }
            }
        }
    }
}

