/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.util.EventObject;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class FeatureEvent
extends EventObject {
    private static final long serialVersionUID = 3154238322369916485L;
    public static final int FEATURES_ADDED = 1;
    public static final int FEATURES_CHANGED = 0;
    public static final int FEATURES_REMOVED = -1;
    protected Type type;
    protected ReferencedEnvelope bounds;
    protected FeatureSource featureSource;
    protected Filter filter;

    public FeatureEvent(FeatureEvent origional) {
        super(origional.getSource());
        this.type = origional.type;
        this.bounds = new ReferencedEnvelope(origional.bounds);
        this.filter = origional.filter;
        this.featureSource = origional.getFeatureSource();
    }

    public FeatureEvent(Object source, Type type, ReferencedEnvelope bounds, Filter filter) {
        super(source);
        this.type = type;
        this.bounds = bounds;
        this.filter = filter;
        if (source instanceof FeatureSource) {
            this.featureSource = (FeatureSource)source;
        }
    }

    public FeatureEvent(FeatureSource<? extends FeatureType, ? extends Feature> featureSource, int eventType, Envelope bounds) {
        super(featureSource);
        switch (eventType) {
            case 1: {
                this.type = Type.ADDED;
                break;
            }
            case 0: {
                this.type = Type.CHANGED;
                break;
            }
            case -1: {
                this.type = Type.REMOVED;
                break;
            }
            default: {
                this.type = Type.CHANGED;
            }
        }
        this.bounds = ReferencedEnvelope.reference(bounds);
        this.featureSource = featureSource;
    }

    public FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource() {
        return (FeatureSource)this.source;
    }

    public void setFeatureSource(FeatureSource featureSource) {
        this.source = featureSource;
    }

    public int getEventType() {
        return this.type.type;
    }

    public Type getType() {
        return this.type;
    }

    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public static enum Type {
        ADDED(1),
        CHANGED(0),
        REMOVED(-1),
        COMMIT(0),
        ROLLBACK(0);

        final int type;

        private Type(int type) {
            this.type = type;
        }

        static Type fromValue(int value) {
            switch (value) {
                case 1: {
                    return ADDED;
                }
                case 0: {
                    return CHANGED;
                }
                case -1: {
                    return REMOVED;
                }
            }
            return CHANGED;
        }
    }
}

